/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.destination.response;

import java.io.IOException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.commons.destination.response.LegacyBaseResponse;

public class LegacyDestinationResponse
extends LegacyBaseResponse {
    private final String responseContent;

    private LegacyDestinationResponse(String responseString, Integer statusCode) {
        super(statusCode);
        if (responseString == null) {
            throw new IllegalArgumentException("Response is missing");
        }
        this.responseContent = responseString;
    }

    public LegacyDestinationResponse(StreamInput streamInput) throws IOException {
        super(streamInput);
        this.responseContent = streamInput.readString();
    }

    public String getResponseContent() {
        return this.responseContent;
    }

    @Override
    public void writeTo(StreamOutput streamOutput) throws IOException {
        super.writeTo(streamOutput);
        streamOutput.writeString(this.responseContent);
    }

    public static class Builder {
        private String responseContent;
        private Integer statusCode;

        public Builder withResponseContent(String responseContent) {
            this.responseContent = responseContent;
            return this;
        }

        public Builder withStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public LegacyDestinationResponse build() {
            return new LegacyDestinationResponse(this.responseContent, this.statusCode);
        }
    }
}

