/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public class BroadcastToAllWebsocketMessage
implements WebsocketMessage,
Writeable {
    private static final String PREFIX = "[BROADCAST_TO_ALL]";
    private final String message;

    public BroadcastToAllWebsocketMessage(String message) {
        Objects.requireNonNull(message, "'message' must not be null");
        this.message = message;
    }

    public BroadcastToAllWebsocketMessage(WebsocketMessage websocketMessage) throws WebsocketMessageException {
        Objects.requireNonNull(websocketMessage, "'websocketMessage' must not be null");
        this.message = websocketMessage.getMessageToSend();
    }

    public BroadcastToAllWebsocketMessage(StreamInput in) throws IOException {
        this.message = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.message);
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static BroadcastToAllWebsocketMessage createFromMessage(String websocketMessage) {
        String message = websocketMessage.substring(PREFIX.length());
        return new BroadcastToAllWebsocketMessage(message);
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        return PREFIX + this.message;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BroadcastToAllWebsocketMessage that = (BroadcastToAllWebsocketMessage)o;
        return Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }

    public String toString() {
        return "BroadcastToAllWebsocketMessage{message='" + this.message + "'}";
    }
}

