/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.IndexOperationDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.util.Map;
import org.opensearch.common.xcontent.ToXContent;

public class IndexOperationWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "IndexOperation:::";
    private final IndexOperationDTO indexOperation;

    public IndexOperationWebsocketMessage(IndexOperationDTO indexOperation) {
        this.indexOperation = indexOperation;
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static IndexOperationWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String indexOperationJson = websocketMessage.substring(PREFIX.length());
            Map indexOperationResultAsMap = JsonUtil.asMap((String)indexOperationJson);
            IndexOperationDTO indexOperation = new IndexOperationDTO(indexOperationResultAsMap);
            return new IndexOperationWebsocketMessage(indexOperation);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + IndexOperationWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + JsonUtil.asJsonString((ToXContent)this.indexOperation);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public IndexOperationDTO getIndexOperation() {
        return this.indexOperation;
    }

    public String toString() {
        return "IndexOperationWebsocketMessage{indexOperation=" + this.indexOperation + "}";
    }
}

