/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.ServerStateInfoDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.util.Map;
import org.opensearch.common.xcontent.ToXContent;

public class ServerStateInfoWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "ServerStateInfo:::";
    private final ServerStateInfoDTO serverStateInfo;

    public ServerStateInfoWebsocketMessage(ServerStateInfoDTO serverStateInfo) {
        this.serverStateInfo = serverStateInfo;
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString((ToXContent)this.serverStateInfo);
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static ServerStateInfoWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String serverStateInfoJsonString = websocketMessage.substring(PREFIX.length());
            Map serverStateInfoMap = JsonUtil.asMap((String)serverStateInfoJsonString);
            ServerStateInfoDTO serverStateInfo = new ServerStateInfoDTO(serverStateInfoMap);
            return new ServerStateInfoWebsocketMessage(serverStateInfo);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + ServerStateInfoWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public ServerStateInfoDTO getServerStateInfo() {
        return this.serverStateInfo;
    }

    public String toString() {
        return "ServerStateInfoWebsocketMessage{serverStateInfo=" + this.serverStateInfo + "}";
    }
}

