/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractEventHandler
implements EventHandler {
    private static final Logger LOG = Logger.getLogger(AbstractEventHandler.class.getName());

    public void handleEvent(Event event) {
        LOG.finest(this.getClass().getSimpleName() + ".handleEvent event=" + event);
        try {
            if (this.canProcessEvent(event)) {
                this.processEvent(event);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed to process event.", ex);
        }
    }

    protected boolean canProcessEvent(Event event) {
        return true;
    }

    protected abstract void processEvent(Event var1);
}

