/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.License;
import de.virtimo.bpc.api.LicenseKey;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractLicense
implements License {
    private static final Logger LOG = Logger.getLogger(AbstractLicense.class.getName());
    protected static final String LICENSE_EXPIRATION_DATE_FORMAT = "yyyy-MM-dd";
    private String name;
    private Map<String, Object> licenseMap;

    public AbstractLicense(String name) {
        this(name, new HashMap<String, Object>());
    }

    protected AbstractLicense(String name, Map<String, Object> licenseMap) {
        this.licenseMap = licenseMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue(String licenseKey) {
        if (this.licenseMap == null) {
            return null;
        }
        return this.licenseMap.get(licenseKey);
    }

    @Override
    public Object getValue(LicenseKey licenseKey) {
        return this.getValue(licenseKey.name());
    }

    @Override
    public Set<String> getLicenseKeys() {
        return this.licenseMap.keySet();
    }

    protected void setLicenseMap(Map<String, Object> licenseMap) {
        this.licenseMap = licenseMap;
    }

    public String toString() {
        Object s = "";
        for (Map.Entry<String, Object> entry : this.licenseMap.entrySet()) {
            s = (String)s + entry.getKey() + " : " + entry.getValue() + "\n";
        }
        return s;
    }

    @Override
    public boolean isExpired() {
        Long expiresInDays = this.getExpiresInDays();
        return expiresInDays == null || expiresInDays <= 0L;
    }

    @Override
    public LocalDate getExpirationDate() {
        try {
            String formattedDate = (String)this.getValue(LicenseKey.LICENSE_EXPIRATION_DATE.name());
            if (formattedDate != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(LICENSE_EXPIRATION_DATE_FORMAT).withZone(ZoneId.systemDefault());
                return LocalDate.parse(formattedDate, formatter);
            }
            LOG.log(Level.WARNING, "Invalid license. The " + LicenseKey.LICENSE_EXPIRATION_DATE.name() + " entry is missing or not set.");
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Invalid license. Failed to parse the license expiration date.", t);
        }
        return null;
    }

    @Override
    public Long getExpiresInDays() {
        LocalDate expirationDate = this.getExpirationDate();
        return expirationDate != null ? Long.valueOf(ChronoUnit.DAYS.between(LocalDate.now(), expirationDate)) : null;
    }

    @Override
    public Period getExpiresInPeriod() {
        LocalDate expirationDate = this.getExpirationDate();
        return expirationDate != null ? Period.between(LocalDate.now(), expirationDate) : null;
    }
}

