/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public abstract class AbstractMaintenanceModeAcknowledgeEventHandler
extends AbstractEventHandler {
    private static final Logger LOG = Logger.getLogger(AbstractMaintenanceModeAcknowledgeEventHandler.class.getName());
    private final BundleContext bundleContext;
    private final String moduleId;

    public AbstractMaintenanceModeAcknowledgeEventHandler(BundleContext bundleContext, String moduleId) {
        this.bundleContext = bundleContext;
        this.moduleId = moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(Event event) {
        LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
        try {
            Boolean maintenanceModeEnabled = (Boolean)event.getProperty("enabled");
            LOG.info("maintenanceModeEnabled? " + maintenanceModeEnabled);
            this.processNewMaintenanceMode(maintenanceModeEnabled);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to process the maintenance mode changed event: " + event, ex);
        }
        finally {
            try (BpcServicesTracker<EventManager> eventManagerTracker = new BpcServicesTracker<EventManager>(this.bundleContext, EventManager.class);){
                eventManagerTracker.getService().fireMaintenanceModeAcknowledgedEvent(this.moduleId, this.getClass().getName());
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to send the maintenance mode acknowledged event.", ex);
            }
        }
    }

    public abstract void processNewMaintenanceMode(boolean var1);
}

