/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.util.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class BackupSetting {
    private static final Logger LOG = Logger.getLogger(BackupSetting.class.getName());
    public static final boolean DEFAULT_ENABLED = true;
    public static final long DEFAULT_INTERVAL_IN_SECONDS = 86400L;
    public static final long DEFAULT_KEEP_BACKUPS_DURATION_IN_SECONDS = 2592000L;
    private final boolean enabled;
    private final long intervalInSeconds;
    private final long keepBackupsDurationInSeconds;
    private final Set<String> indicesToBackup;

    @Deprecated(since="4.1.0", forRemoval=true)
    public static BackupSetting buildFrom(Setting backupSetting, String[] indices) {
        return BackupSettingFactory.createFrom(backupSetting, indices);
    }

    private BackupSetting(BackupSettingBuilder builder) {
        LOG.info("BackupSetting builder=" + builder);
        this.enabled = builder.enabled;
        this.intervalInSeconds = builder.intervalInSeconds;
        this.keepBackupsDurationInSeconds = builder.keepBackupsDurationInSeconds;
        this.indicesToBackup = builder.indicesToBackup;
    }

    public static BackupSettingBuilder copyOf(BackupSetting backupSetting) {
        return BackupSettingBuilder.newInstance().copyOf(backupSetting);
    }

    public static BackupSettingBuilder withEnabled(boolean enabled) {
        return BackupSettingBuilder.newInstance().withEnabled(enabled);
    }

    public static BackupSettingBuilder withIntervalInSeconds(long intervalInSeconds) {
        return BackupSettingBuilder.newInstance().withIntervalInSeconds(intervalInSeconds);
    }

    public static BackupSettingBuilder withKeepBackupsDurationInSeconds(long keepBackupsDurationInSeconds) {
        return BackupSettingBuilder.newInstance().withKeepBackupsDurationInSeconds(keepBackupsDurationInSeconds);
    }

    public static BackupSettingBuilder withIndicesToBackup(String ... indicesToBackup) {
        return BackupSettingBuilder.newInstance().withIndicesToBackup(indicesToBackup);
    }

    public static BackupSettingBuilder withIndicesToBackup(Set<String> indicesToBackup) {
        return BackupSettingBuilder.newInstance().withIndicesToBackup(indicesToBackup);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public long getKeepBackupsDurationInSeconds() {
        return this.keepBackupsDurationInSeconds;
    }

    public Set<String> getIndicesToBackup() {
        return this.indicesToBackup;
    }

    public String getIndicesToBackupNamesAsKey() {
        return StringUtil.implode("_", this.indicesToBackup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupSetting that = (BackupSetting)o;
        return this.enabled == that.enabled && this.intervalInSeconds == that.intervalInSeconds && this.keepBackupsDurationInSeconds == that.keepBackupsDurationInSeconds && Objects.equals(this.indicesToBackup, that.indicesToBackup);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.intervalInSeconds, this.keepBackupsDurationInSeconds, this.indicesToBackup);
    }

    public String toString() {
        return "BackupSetting{enabled=" + this.enabled + ", intervalInSeconds=" + this.intervalInSeconds + ", keepBackupsDurationInSeconds=" + this.keepBackupsDurationInSeconds + ", indicesToBackup=" + this.indicesToBackup + "}";
    }

    public static class BackupSettingBuilder {
        private boolean enabled = true;
        private long intervalInSeconds = 86400L;
        private long keepBackupsDurationInSeconds = 2592000L;
        private final Set<String> indicesToBackup = new HashSet<String>();

        private BackupSettingBuilder() {
        }

        private static BackupSettingBuilder newInstance() {
            return new BackupSettingBuilder();
        }

        public BackupSettingBuilder copyOf(BackupSetting backupSetting) {
            this.enabled = backupSetting.enabled;
            this.intervalInSeconds = backupSetting.intervalInSeconds;
            this.keepBackupsDurationInSeconds = backupSetting.keepBackupsDurationInSeconds;
            if (backupSetting.indicesToBackup != null) {
                this.indicesToBackup.addAll(backupSetting.indicesToBackup);
            }
            return this;
        }

        public BackupSettingBuilder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public BackupSettingBuilder withIntervalInSeconds(long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public BackupSettingBuilder withKeepBackupsDurationInSeconds(long keepBackupsDurationInSeconds) {
            this.keepBackupsDurationInSeconds = keepBackupsDurationInSeconds;
            return this;
        }

        public BackupSettingBuilder withIndicesToBackup(String ... indicesToBackup) {
            this.indicesToBackup.clear();
            if (indicesToBackup != null) {
                Collections.addAll(this.indicesToBackup, indicesToBackup);
            }
            return this;
        }

        public BackupSettingBuilder withIndicesToBackup(Set<String> indicesToBackup) {
            this.indicesToBackup.clear();
            if (indicesToBackup != null) {
                this.indicesToBackup.addAll(indicesToBackup);
            }
            return this;
        }

        public BackupSetting build() {
            return new BackupSetting(this);
        }
    }
}

