/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public interface Checker {
    public static final Logger LOG = Logger.getLogger(Checker.class.getName());

    public void startChecker();

    public void stopChecker();

    public static void stop(Checker checker) {
        if (checker != null) {
            Bundle checkerBundle = FrameworkUtil.getBundle(checker.getClass());
            LOG.info(checkerBundle.getSymbolicName() + ": Stopping the " + checker.getClass().getSimpleName());
            long startTS = System.currentTimeMillis();
            try {
                checker.stopChecker();
                LOG.info(checkerBundle.getSymbolicName() + ": Stopped the " + checker.getClass().getSimpleName() + " in " + (System.currentTimeMillis() - startTS) + "ms");
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, checkerBundle.getSymbolicName() + ": Failed to stop the " + checker.getClass().getSimpleName(), ex);
            }
        }
    }
}

