/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.License;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.NoSuitableConnectionTesterFoundException;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface ModuleManager {
    public int getModelVersionOfBpcConfigurationIndex() throws ServiceNotFoundException;

    @Deprecated(since="4.0.0", forRemoval=true)
    public ModuleConfiguration getModuleConfiguration(String var1);

    public Map<String, ModuleConfiguration> getModuleInstanceConfiguration(InstantiableModule var1) throws SettingException, ServiceNotFoundException, OpenSearchRelatedException;

    public Map<String, Module> getLoadedModules();

    public Map<String, Module> getAllModules();

    public Module getModule(String var1);

    @NotNull
    public Module getModuleById(String var1) throws ModuleNotFoundException;

    @NotNull
    public <T> T getModuleByClass(Class<T> var1) throws ModuleNotFoundException;

    public void loadModule(Module var1) throws SettingException, ServiceNotFoundException;

    public void unloadModule(Module var1);

    public void reloadAllModules() throws SettingException, ServiceNotFoundException;

    public ModuleConfiguration manageConfigurationPersistence(Module var1, ModuleConfiguration var2) throws SettingException;

    public void deleteModuleInstance(ModuleInstance var1) throws ServiceNotFoundException, OpenSearchRelatedException;

    public void deleteModuleInstance(String var1, String var2) throws ServiceNotFoundException, OpenSearchRelatedException;

    @Deprecated(since="3.1", forRemoval=true)
    public void setLicense(License var1) throws LicenseException, SettingException, ServiceNotFoundException;

    @NotNull
    public List<SettingValidator> getSettingValidators();

    public void setSettingValidator(SettingValidator var1);

    public void removeSettingValidator(SettingValidator var1);

    @NotNull
    public List<ConnectionTester> getConnectionTesters();

    public void setConnectionTester(ConnectionTester var1);

    public void removeConnectionTester(ConnectionTester var1);

    public Map<Module, List<ModuleInstance>> getModulesAndModuleInstancesForUserSession(String var1, UserSession var2);

    @NotNull
    public Set<String> readModuleInstanceIDs(String var1, String var2) throws ServiceNotFoundException, OpenSearchRelatedException;

    public Map<String, Setting> readModuleSettings(String var1, String var2, String var3) throws ServiceNotFoundException, SettingException;

    public Map<String, Setting> readModuleSettings(String var1, String var2) throws ServiceNotFoundException, SettingException;

    public Map<String, Setting> readModuleSettings(Module var1) throws ServiceNotFoundException, SettingException;

    public List<FrontendWarningException> validateModuleSettings(String var1, Collection<Setting> var2, Collection<? extends Setting> var3) throws ValidationException;

    public List<FrontendWarningException> validateModuleInstanceSettings(String var1, String var2, String var3, Collection<Setting> var4, Collection<? extends Setting> var5) throws ValidationException;

    public void performConnectionTest(ModuleInstance var1, Map<String, Object> var2) throws NoSuitableConnectionTesterFoundException, ConnectionTestException;
}

