/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.auditlog;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.auditlog.AuditLogLevel;
import de.virtimo.bpc.api.auditlog.AuditLogService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class AuditLog {
    private static final Logger LOG = Logger.getLogger(AuditLog.class.getName());

    public static synchronized void log(AuditLogLevel level, String originator, String action, String description, Object oldValues, Object newValues) {
        LOG.info("log level=" + level + ", originator=" + originator + ", action=" + action + ", description=" + description + ", oldValues=..., newValues=...");
        BundleContext bundleContext = FrameworkUtil.getBundle(AuditLog.class).getBundleContext();
        try (BpcServicesTracker<AuditLogService> auditLogServiceTracker = new BpcServicesTracker<AuditLogService>(bundleContext, AuditLogService.class);){
            AuditLogService auditLogService = auditLogServiceTracker.getService();
            auditLogService.log(level, originator, action, description, oldValues, newValues);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not perform the audit logging.", ex);
        }
    }
}

