/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.auditlog;

import java.util.HashSet;
import java.util.Set;

public class AuditLogLevel {
    private static Set<AuditLogLevel> KnownLevels = new HashSet<AuditLogLevel>();
    public static final AuditLogLevel OFF = new AuditLogLevel("OFF", Integer.MAX_VALUE);
    public static final AuditLogLevel ALL = new AuditLogLevel("ALL", Integer.MIN_VALUE);
    public static final AuditLogLevel ERROR = new AuditLogLevel("ERROR", 1000);
    public static final AuditLogLevel WARNING = new AuditLogLevel("WARNING", 900);
    public static final AuditLogLevel INFO = new AuditLogLevel("INFO", 800);
    public static final AuditLogLevel DEBUG = new AuditLogLevel("DEBUG", 500);
    private final String name;
    private final int value;

    public static AuditLogLevel parse(String name) {
        for (AuditLogLevel knownLevel : KnownLevels) {
            if (!knownLevel.getName().equals(name)) continue;
            return knownLevel;
        }
        return null;
    }

    protected AuditLogLevel(String name, int value) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.value = value;
        KnownLevels.add(this);
    }

    public String getName() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogLevel that = (AuditLogLevel)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

