/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch.querybuilder;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilterBuilder;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

@JsonDeserialize(using=FilterDeserializer.class)
public class BpcDataFilter {
    private static final Logger LOG = Logger.getLogger(BpcDataFilter.class.getName());
    private final String property;
    private final String value;
    private final String[] values;
    private final String operator;
    private final String source;
    private final boolean invert;

    public static BpcDataFilter fromJsonObject(String jsonString) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            BpcDataFilter bpcDataFilter = (BpcDataFilter)objectMapper.readValue(jsonString, BpcDataFilter.class);
            return bpcDataFilter;
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
        }
    }

    public static List<BpcDataFilter> fromJsonArray(String jsonArrayString) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            List list = (List)objectMapper.readValue(jsonArrayString, (TypeReference)new TypeReference<List<BpcDataFilter>>(){});
            return list;
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
        }
    }

    public BpcDataFilter(String property, String value, String[] values, String operator, String source, boolean invert) {
        this.property = property;
        this.value = value;
        this.values = values;
        this.operator = operator;
        this.source = source;
        this.invert = invert;
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getValueAsBoolean() {
        if (this.hasMultiValues()) {
            for (String value : this.getValues()) {
                if (!this.isBooleanTrue(value)) continue;
                return true;
            }
            return false;
        }
        return this.isBooleanTrue(this.getValue());
    }

    private boolean isBooleanTrue(String filterValue) {
        return filterValue != null && Arrays.asList("true", "1", "ja", "yes", "on").contains(filterValue.toLowerCase());
    }

    public boolean hasMultiValues() {
        return this.values != null;
    }

    public String[] getValues() {
        return this.values;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public String toString() {
        return this.getProperty() + " : " + this.getOperator() + " " + this.getValue() + " " + Arrays.toString(this.getValues());
    }

    public static class FilterDeserializer
    extends JsonDeserializer<BpcDataFilter> {
        public BpcDataFilter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            BpcDataFilterBuilder dataFilterBuilder = new BpcDataFilterBuilder();
            if (node.has("operator")) {
                dataFilterBuilder.withOperator(node.get("operator").asText());
            } else {
                dataFilterBuilder.withOperator("=");
            }
            if (node.has("source")) {
                dataFilterBuilder.withSource(node.get("source").asText());
            } else {
                dataFilterBuilder.withSource("analyzed");
            }
            dataFilterBuilder.withProperty(node.get("property").asText());
            if (node.get("value").isArray()) {
                Iterator valueIterator = node.get("value").elements();
                ArrayList<String> values = new ArrayList<String>();
                while (valueIterator.hasNext()) {
                    String value = ((JsonNode)valueIterator.next()).asText();
                    values.add(value);
                }
                dataFilterBuilder.withValues(values.toArray(new String[values.size()]));
            } else {
                String value = node.get("value").asText();
                dataFilterBuilder.withValue(value);
            }
            if (node.has("invert")) {
                dataFilterBuilder.withInvert(node.get("invert").asBoolean());
            } else {
                dataFilterBuilder.withInvert(false);
            }
            return dataFilterBuilder.build();
        }
    }
}

