/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.storage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StoreItemRestriction {
    private final String user;
    private final Set<String> organisations;
    private final Set<String> roles;
    private final Set<String> rights;

    private StoreItemRestriction(StoreItemRestrictionBuilder storeItemRestrictionBuilder) {
        if (!StringUtil.isNullOrEmpty(storeItemRestrictionBuilder.user)) {
            this.user = storeItemRestrictionBuilder.user;
            this.organisations = null;
            this.roles = null;
            this.rights = null;
        } else {
            this.user = null;
            this.organisations = storeItemRestrictionBuilder.organisations;
            this.roles = storeItemRestrictionBuilder.roles;
            this.rights = storeItemRestrictionBuilder.rights;
        }
    }

    @JsonIgnore
    public boolean isValid() {
        if (!StringUtil.isNullOrEmpty(this.user)) {
            return true;
        }
        if (this.organisations != null && !this.organisations.isEmpty()) {
            return true;
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            return true;
        }
        return this.rights != null && !this.rights.isEmpty();
    }

    public static StoreItemRestrictionBuilder withOrganisations(String ... organisations) {
        return StoreItemRestrictionBuilder.newInstance().withOrganisations(organisations);
    }

    public static StoreItemRestrictionBuilder withOrganisations(Set<String> organisations) {
        return StoreItemRestrictionBuilder.newInstance().withOrganisations(organisations);
    }

    public static StoreItemRestrictionBuilder withRoles(String ... roles) {
        return StoreItemRestrictionBuilder.newInstance().withRoles(roles);
    }

    public static StoreItemRestrictionBuilder withRoles(Set<String> roles) {
        return StoreItemRestrictionBuilder.newInstance().withRoles(roles);
    }

    public static StoreItemRestrictionBuilder withRights(String ... rights) {
        return StoreItemRestrictionBuilder.newInstance().withRights(rights);
    }

    public static StoreItemRestrictionBuilder withRights(Set<String> rights) {
        return StoreItemRestrictionBuilder.newInstance().withRights(rights);
    }

    public static StoreItemRestrictionBuilder withUser(String user) {
        return StoreItemRestrictionBuilder.newInstance().withUser(user);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Set<String> getOrganisations() {
        return this.organisations;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Set<String> getRoles() {
        return this.roles;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Set<String> getRights() {
        return this.rights;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUser() {
        return this.user;
    }

    public boolean hasAccess(UserSession userSession) {
        if (!StringUtil.isNullOrEmpty(this.user)) {
            return this.user.equalsIgnoreCase(userSession.getLoginName());
        }
        if (this.organisations != null && !userSession.hasAnyOrganisation(this.organisations)) {
            return false;
        }
        if (this.roles != null && !userSession.hasAnyRole(this.roles)) {
            return false;
        }
        return this.rights == null || userSession.hasAllRights(this.rights);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreItemRestriction that = (StoreItemRestriction)o;
        return Objects.equals(this.organisations, that.organisations) && Objects.equals(this.roles, that.roles) && Objects.equals(this.rights, that.rights) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.organisations, this.roles, this.rights, this.user);
    }

    public String toString() {
        return "StoreItemRestriction{organisations=" + this.organisations + ", roles=" + this.roles + ", rights=" + this.rights + ", user='" + this.user + "'}";
    }

    public static class StoreItemRestrictionBuilder {
        private Set<String> organisations;
        private Set<String> roles;
        private Set<String> rights;
        private String user;

        private StoreItemRestrictionBuilder() {
        }

        private static StoreItemRestrictionBuilder newInstance() {
            return new StoreItemRestrictionBuilder();
        }

        public StoreItemRestrictionBuilder withOrganisations(String ... organisations) {
            this.organisations = new HashSet<String>(Arrays.asList(organisations));
            return this;
        }

        public StoreItemRestrictionBuilder withOrganisations(Set<String> organisations) {
            this.organisations = organisations;
            return this;
        }

        public StoreItemRestrictionBuilder withRoles(String ... roles) {
            this.roles = new HashSet<String>(Arrays.asList(roles));
            return this;
        }

        public StoreItemRestrictionBuilder withRoles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        public StoreItemRestrictionBuilder withRights(String ... rights) {
            this.rights = new HashSet<String>(Arrays.asList(rights));
            return this;
        }

        public StoreItemRestrictionBuilder withRights(Set<String> rights) {
            this.rights = rights;
            return this;
        }

        public StoreItemRestrictionBuilder withUser(String user) {
            this.user = user;
            return this;
        }

        public StoreItemRestriction build() {
            return new StoreItemRestriction(this);
        }
    }
}

