/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.Configuration;

public abstract class AbstractBundleBasedConfiguration {
    private static final Logger LOG = Logger.getLogger(AbstractBundleBasedConfiguration.class.getName());

    protected abstract Configuration getConfiguration();

    protected abstract Properties getDefaultProperties();

    protected Properties loadResourceProperties(String fileName) throws IOException {
        try (InputStream resourceStream = FrameworkUtil.getBundle(this.getClass()).getResource(fileName).openStream();){
            Properties bundleProperties = new Properties();
            bundleProperties.load(resourceStream);
            Properties properties = bundleProperties;
            return properties;
        }
    }

    public boolean existsUnprocessedSystemProperty(String systemPropertyName) {
        if (this.getConfiguration() != null && !StringUtil.isNullOrEmpty(systemPropertyName)) {
            return this.getConfiguration().getProperties().get(systemPropertyName) != null;
        }
        return false;
    }

    public boolean existsSystemProperty(String systemPropertyName) {
        if (this.getConfiguration() != null && !StringUtil.isNullOrEmpty(systemPropertyName)) {
            return this.getConfiguration().getProcessedProperties(null).get(systemPropertyName) != null;
        }
        return false;
    }

    public boolean getUnprocessedSystemPropertyValueAsBoolean(String systemPropertyName, boolean defaultValue) {
        return this.getSystemPropertyValueAsBoolean(this.getConfiguration().getProperties(), systemPropertyName, defaultValue);
    }

    public boolean getSystemPropertyValueAsBoolean(String systemPropertyName, boolean defaultValue) {
        return this.getSystemPropertyValueAsBoolean(this.getConfiguration().getProcessedProperties(null), systemPropertyName, defaultValue);
    }

    private boolean getSystemPropertyValueAsBoolean(Dictionary<String, Object> configProps, String systemPropertyName, boolean defaultValue) {
        String defaultPropertyValue;
        Boolean result = null;
        Object valueObject = null;
        try {
            valueObject = configProps.get(systemPropertyName);
            if (valueObject != null) {
                result = valueObject instanceof String ? Boolean.valueOf(Boolean.parseBoolean((String)valueObject)) : Boolean.valueOf((Boolean)valueObject);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to get the system configuration property value of '" + systemPropertyName + "' as 'boolean': " + valueObject + ". Going to use the default config value.", ex);
        }
        if (result == null && !StringUtil.isNullOrEmpty(defaultPropertyValue = this.getDefaultProperties().getProperty(systemPropertyName))) {
            try {
                result = Boolean.parseBoolean(defaultPropertyValue);
            }
            catch (Exception ex) {
                LOG.warning("Failed using the default system configuration property value of '" + systemPropertyName + "' as 'boolean': " + defaultPropertyValue + ". Going to use the given default config value.");
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public int getUnprocessedSystemPropertyValueAsInt(String systemPropertyName, int defaultValue) {
        return this.getSystemPropertyValueAsInt(this.getConfiguration().getProperties(), systemPropertyName, defaultValue);
    }

    public int getSystemPropertyValueAsInt(String systemPropertyName, int defaultValue) {
        return this.getSystemPropertyValueAsInt(this.getConfiguration().getProcessedProperties(null), systemPropertyName, defaultValue);
    }

    private int getSystemPropertyValueAsInt(Dictionary<String, Object> configProps, String systemPropertyName, int defaultValue) {
        String defaultPropertyValue;
        Integer result = null;
        Object valueObject = null;
        try {
            valueObject = configProps.get(systemPropertyName);
            if (valueObject != null) {
                result = valueObject instanceof String ? Integer.valueOf(Integer.parseInt((String)valueObject)) : (valueObject instanceof Number ? Integer.valueOf(((Number)valueObject).intValue()) : Integer.valueOf((Integer)valueObject));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to get the system configuration property value of '" + systemPropertyName + "' as 'int': " + valueObject + ". Going to use the default config value.", ex);
        }
        if (result == null && !StringUtil.isNullOrEmpty(defaultPropertyValue = this.getDefaultProperties().getProperty(systemPropertyName))) {
            try {
                result = Integer.parseInt(defaultPropertyValue);
            }
            catch (Exception ex) {
                LOG.warning("Failed using the default system configuration property value of '" + systemPropertyName + "' as 'int': " + defaultPropertyValue + ". Going to use the given default config value.");
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public long getUnprocessedSystemPropertyValueAsLong(String systemPropertyName, long defaultValue) {
        return this.getSystemPropertyValueAsLong(this.getConfiguration().getProperties(), systemPropertyName, defaultValue);
    }

    public long getSystemPropertyValueAsLong(String systemPropertyName, long defaultValue) {
        return this.getSystemPropertyValueAsLong(this.getConfiguration().getProcessedProperties(null), systemPropertyName, defaultValue);
    }

    private long getSystemPropertyValueAsLong(Dictionary<String, Object> configProps, String systemPropertyName, long defaultValue) {
        String defaultPropertyValue;
        Long result = null;
        Object valueObject = null;
        try {
            valueObject = configProps.get(systemPropertyName);
            if (valueObject != null) {
                result = valueObject instanceof String ? Long.valueOf(Long.parseLong((String)valueObject)) : (valueObject instanceof Number ? Long.valueOf(((Number)valueObject).longValue()) : Long.valueOf((Long)valueObject));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to get the system configuration property value of '" + systemPropertyName + "' as 'long': " + valueObject + ". Going to use the default config value.", ex);
        }
        if (result == null && !StringUtil.isNullOrEmpty(defaultPropertyValue = this.getDefaultProperties().getProperty(systemPropertyName))) {
            try {
                result = Long.parseLong(defaultPropertyValue);
            }
            catch (Exception ex) {
                LOG.warning("Failed using the default system configuration property value of '" + systemPropertyName + "' as 'long': " + defaultPropertyValue + ". Going to use the given default config value.");
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public String getUnprocessedSystemPropertyValueAsString(String systemPropertyName, String defaultValue) {
        return this.getSystemPropertyValueAsString(this.getConfiguration().getProperties(), systemPropertyName, defaultValue);
    }

    public String getSystemPropertyValueAsString(String systemPropertyName, String defaultValue) {
        return this.getSystemPropertyValueAsString(this.getConfiguration().getProcessedProperties(null), systemPropertyName, defaultValue);
    }

    private String getSystemPropertyValueAsString(Dictionary<String, Object> configProps, String systemPropertyName, String defaultValue) {
        String defaultPropertyValue;
        String result = null;
        Object valueObject = null;
        try {
            valueObject = configProps.get(systemPropertyName);
            if (valueObject != null) {
                result = valueObject instanceof String ? (String)valueObject : String.valueOf(valueObject);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to get the system configuration property value of '" + systemPropertyName + "' as 'string'" + valueObject + ". Going to use the default config value.", ex);
        }
        if (result == null && (defaultPropertyValue = this.getDefaultProperties().getProperty(systemPropertyName)) != null) {
            result = defaultPropertyValue;
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private void setSystemPropertyValueAsString(String systemPropertyName, String value) throws IOException {
        Configuration configuration = this.getConfiguration();
        Dictionary properties = configuration.getProperties();
        properties.put(systemPropertyName, value);
        configuration.update(properties);
    }

    public void setSystemPropertyValue(String systemPropertyName, String value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, value);
    }

    public void setSystemPropertyValue(String systemPropertyName, Boolean value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, String.valueOf(value));
    }

    public void setSystemPropertyValue(String systemPropertyName, Integer value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, String.valueOf(value));
    }

    public void setSystemPropertyValue(String systemPropertyName, Long value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, String.valueOf(value));
    }

    public void setSystemPropertyValue(String systemPropertyName, Float value) throws IOException {
        this.setSystemPropertyValueAsString(systemPropertyName, String.valueOf(value));
    }
}

