/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.License;
import de.virtimo.bpc.core.license.LicenseService;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class GeneralMetricsCollector
extends Collector {
    private static final Logger LOG = Logger.getLogger(GeneralMetricsCollector.class.getName());
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<LicenseService> licenseServiceTracker;

    public GeneralMetricsCollector(BundleContext bundleContext) {
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(bundleContext, LicenseService.class);
    }

    public void unregister() {
        LOG.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        BpcServicesTracker.stopAll((Object)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        LOG.info("collect");
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_jvm_uptime_in_milliseconds", "Uptime of the BPC JVM in milliseconds.", (double)this.runtimeMXBean.getUptime()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_maintenance_mode_enabled", "Status of the maintenance mode (1=enabled; 0=disabled)", coreBundleConfiguration.isMaintenanceModeEnabled() ? 1.0 : 0.0));
        }
        catch (Throwable coreBundleConfiguration) {
            // empty catch block
        }
        try {
            License license = this.licenseServiceTracker.getService().getLicense();
            double licenseStatus = 0.0;
            Long licenseExpiresInDays = null;
            LocalDate localLicenseExpirationDate = null;
            if (license != null) {
                if (license.isExpired()) {
                    licenseStatus = 2.0;
                    licenseExpiresInDays = 0L;
                } else {
                    licenseStatus = 1.0;
                    licenseExpiresInDays = license.getExpiresInDays();
                }
                localLicenseExpirationDate = license.getExpirationDate();
            }
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_license_status", "Status of the license (0=missing; 1=valid; 2=expired)", licenseStatus));
            if (licenseExpiresInDays != null) {
                mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_license_expires_in_days", "Number of days until the license expires", (double)licenseExpiresInDays.longValue()));
            }
            if (localLicenseExpirationDate != null) {
                long licenseExpiresOnUtcTimestampInMillis = localLicenseExpirationDate.atStartOfDay().atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
                mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_license_expires_on_utc_timestamp_millis", "UTC timestamp in millis when the license expires", (double)licenseExpiresOnUtcTimestampInMillis));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }
}

