/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auditlog;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.auditlog.AuditLogLevel;
import de.virtimo.bpc.api.auditlog.AuditLogger;
import de.virtimo.bpc.api.auditlog.AuditLoggerException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class OpenSearchAuditLogger
implements AuditLogger {
    private static final Logger LOG = Logger.getLogger(OpenSearchAuditLogger.class.getName());
    public static final String INDEX_NAME = "bpc-auditlog";
    private ScheduledExecutorService executorService;
    private final int cleanupPeriodInMinutes;
    private final String deleteEntriesOlderThan;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private final EventRegistration eventRegistration;
    private boolean bpcAuditlogIndexRestoreInProgress = false;

    public OpenSearchAuditLogger(BundleContext bundleContext, CoreBundleConfiguration coreBundleConfiguration) {
        this.cleanupPeriodInMinutes = coreBundleConfiguration.getSystemPropertyValueAsInt(OpenSearchAuditLogger.class.getName() + ".auditlog.cleanupPeriodInMinutes", -1);
        this.deleteEntriesOlderThan = coreBundleConfiguration.getSystemPropertyValueAsString(OpenSearchAuditLogger.class.getName() + ".auditlog.deleteEntriesOlderThan", null);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-auditlog-opensearch"));
        this.startAuditLoggerIndexCleanupTask();
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forIndexRestoreFromBackupStartEvents(new IndexBackupRestoreStartEventHandler());
        this.eventRegistration.forIndexRestoredFromBackupDoneEvents(new IndexBackupRestoreDoneEventHandler());
    }

    @Override
    public AuditLogLevel getDefaultAuditLogLevel() {
        return AuditLogLevel.INFO;
    }

    @Override
    public void stop() {
        LOG.info("stop");
        this.stopAuditLoggerIndexCleanupTask();
        if (this.executorService != null) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
                this.executorService = null;
            }
            catch (InterruptedException | RuntimeException ex) {
                LOG.log(Level.SEVERE, "Could not shutdown the audit log cleanup task");
            }
        }
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    private synchronized OpenSearchService getOpenSearchServiceWithPreparedAuditLogIndex() throws AuditLoggerException {
        LOG.info("getOpenSearchServiceWithPreparedAuditLogIndex");
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            BpcIndexState bpcAuditLogIndexState = oss.getIndexState(INDEX_NAME);
            bpcAuditLogIndexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    return oss.getManagedIndicesHandler().createManagedIndex(OpenSearchAuditLogger.INDEX_NAME);
                }
            });
            return oss;
        }
        catch (ServiceNotFoundException ex) {
            throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, "OpenSearch service is not registered.");
        }
        catch (Exception ex) {
            throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, (Throwable)ex);
        }
    }

    @Override
    public FutureTask<Exception> log(List<Map<String, Object>> logEntries) throws AuditLoggerException {
        LOG.info("log logEntries=...");
        if (logEntries == null || logEntries.isEmpty()) {
            return null;
        }
        if (this.bpcAuditlogIndexRestoreInProgress) {
            LOG.warning("Audit logging is ignored while a audit log backup gets restored.");
            return null;
        }
        final OpenSearchService oss = this.getOpenSearchServiceWithPreparedAuditLogIndex();
        try {
            RestHighLevelClient osClient = oss.getClient();
            BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
            for (Map<String, Object> logEntry : logEntries) {
                bulkRequest.add(new IndexRequest(INDEX_NAME).source(logEntry, XContentType.JSON));
            }
            final BulkResponse bulkResponse = osClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, "Audit log indexing failed: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
            }
            return new FutureTask<Exception>(new Callable<Exception>(){

                @Override
                public Exception call() {
                    try {
                        OpenSearchAuditLogger.this.percolatorsManagerTracker.getService().informClientsAboutReplicatedData(oss, OpenSearchAuditLogger.INDEX_NAME, bulkResponse);
                        return null;
                    }
                    catch (ServiceNotFoundException ex) {
                        LOG.log(Level.WARNING, "Failed to inform clients about new log entry. Can be ignored when a shutdown is in progress.");
                        return ex;
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, ex.getMessage(), ex);
                        return ex;
                    }
                }
            });
        }
        catch (IOException | OpenSearchException ex) {
            throw new AuditLoggerException((ErrorCode)CoreErrorCode.AUDIT_LOGGER_LOGGING_FAILED, "Audit log indexing failed: ${error}", MapUtil.mapOf("error", ex.getMessage()));
        }
    }

    private void stopAuditLoggerIndexCleanupTask() {
        LOG.info("stopAuditLoggerIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_NAME);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to stop/cancel the running cleanup task for the index 'bpc-auditlog'.", ex);
        }
    }

    private void startAuditLoggerIndexCleanupTask() {
        LOG.info("startAuditLoggerIndexCleanupTask");
        try {
            this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_NAME, "timestamp", this.deleteEntriesOlderThan, this.cleanupPeriodInMinutes, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to schedule the index cleanup task for the index 'bpc-auditlog'.", ex);
        }
    }

    private class IndexBackupRestoreStartEventHandler
    extends AbstractEventHandler {
        private IndexBackupRestoreStartEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            Object aliases;
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            if (event != null && (aliases = event.getProperty("aliases")) instanceof List && ((List)aliases).contains(OpenSearchAuditLogger.INDEX_NAME)) {
                OpenSearchAuditLogger.this.bpcAuditlogIndexRestoreInProgress = true;
            }
        }
    }

    private class IndexBackupRestoreDoneEventHandler
    extends AbstractEventHandler {
        private IndexBackupRestoreDoneEventHandler() {
        }

        @Override
        protected void processEvent(Event event) {
            Object aliases;
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            if (event != null && (aliases = event.getProperty("aliases")) instanceof List && ((List)aliases).contains(OpenSearchAuditLogger.INDEX_NAME)) {
                OpenSearchAuditLogger.this.bpcAuditlogIndexRestoreInProgress = false;
            }
        }
    }
}

