/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auditlog.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auditlog.AuditLog;
import de.virtimo.bpc.api.auditlog.AuditLogLevel;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.LogServiceException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.auditlog.resource.AuditLogData;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="auditlog")
public class AuditLogEndpoint {
    private static final Logger LOG = Logger.getLogger(AuditLogEndpoint.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public AuditLogEndpoint(BundleContext bundleContext) {
        LOG.info("AuditLogEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @POST
    @Path(value="/log")
    @BpcRoleOrRightRequired(role="AUDIT_LOG_USER", right="AUDIT_LOG_CREATE_ENTRY")
    public Response log(String json) {
        LOG.info("log");
        try {
            AuditLogData auditLogData;
            if (StringUtil.isNullOrEmpty(json)) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "No audit log data given");
            }
            try {
                auditLogData = JsonUtil.getInstance().convertJsonStringToPojo(json, AuditLogData.class);
            }
            catch (IOException ex) {
                throw new LogServiceException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Could not convert the given data to a AuditLogData object. Invalid JSON structure?", ex);
            }
            AuditLog.log(AuditLogLevel.parse(auditLogData.getLevel()), auditLogData.getOriginator(), auditLogData.getAction(), auditLogData.getDescription(), auditLogData.getOldValues(), auditLogData.getNewValues());
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to create the audit log entry", ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

