/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.RestrictedSetting;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.auth.BpcAdminRole;
import de.virtimo.bpc.api.auth.BpcUserRole;
import de.virtimo.bpc.api.auth.InactiveOrganisation;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.auth.IdentityProviderAdditionalInfoApplyer;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.IdentityProviderMappings;
import de.virtimo.bpc.core.auth.IdentityProviderMappingsApplyer;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationImpl;
import de.virtimo.bpc.util.StringUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractUserSession
implements UserSession {
    private static final Logger LOG = Logger.getLogger(AbstractUserSession.class.getName());
    private boolean isInitialised = false;
    protected Set<Organisation> organisations = new HashSet<Organisation>();
    protected Set<InactiveOrganisation> inactiveOrganisations = new HashSet<InactiveOrganisation>();
    protected Set<Role> roles = new HashSet<Role>();
    protected Set<Right> rights = new HashSet<Right>();
    protected Map<String, List<String>> principals = new HashMap<String, List<String>>();
    protected Map<String, Object> customData = new HashMap<String, Object>();
    protected Map<String, Object> sensitiveCustomData = new HashMap<String, Object>();

    public AbstractUserSession() {
        ArrayList<String> tokenList = new ArrayList<String>();
        tokenList.add(this.generateRandomBase64Token(128));
        this.principals.put("X-Csrf-Token", tokenList);
        this.roles.add(RolesFactory.getBpcUserRole());
    }

    private String generateRandomBase64Token(int byteLength) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] token = new byte[byteLength];
        secureRandom.nextBytes(token);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(token);
    }

    private void init() {
        if (this.isInitialised) {
            return;
        }
        LOG.log(Level.FINEST, "init");
        Role existingBpcAdminRole = null;
        for (Role role : this.roles) {
            if (!role.getName().equalsIgnoreCase("bpcadmin")) continue;
            existingBpcAdminRole = role;
            break;
        }
        if (existingBpcAdminRole != null && !(existingBpcAdminRole instanceof BpcAdminRole)) {
            this.roles.remove(existingBpcAdminRole);
            this.roles.add(RolesFactory.getBpcAdminRole());
        }
        Role existingBpcUserRole = null;
        for (Role role : this.roles) {
            if (!role.getName().equalsIgnoreCase("bpcuser")) continue;
            existingBpcUserRole = role;
            break;
        }
        if (existingBpcUserRole == null) {
            this.roles.add(RolesFactory.getBpcUserRole());
        } else if (!(existingBpcUserRole instanceof BpcUserRole)) {
            this.roles.remove(existingBpcUserRole);
            this.roles.add(RolesFactory.getBpcUserRole());
        }
        try {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            if (bundle == null) {
                LOG.log(Level.WARNING, "Bundle missing. Maybe a test");
                return;
            }
            BundleContext bundleContext = bundle.getBundleContext();
            IdentityProviderConfiguration idpConfiguration = CoreModule.getCurrentIdentityProviderConfiguration(bundleContext);
            if (idpConfiguration != null) {
                IdentityProviderMappings identityProviderMappings;
                if (idpConfiguration.isFetchAdditionalInfoEnabled()) {
                    IdentityProviderAdditionalInfoApplyer identityProviderAdditionalInfoApplyer = new IdentityProviderAdditionalInfoApplyer(this.organisations, this.roles, this.rights);
                    identityProviderAdditionalInfoApplyer.apply(idpConfiguration, this.getLoginName());
                }
                if ((identityProviderMappings = idpConfiguration.getIdentityProviderMappings()) != null) {
                    IdentityProviderMappingsApplyer identityProviderMappingsApplyer = new IdentityProviderMappingsApplyer(this.organisations, this.roles, this.rights);
                    identityProviderMappingsApplyer.applyIdentityProviderMappings(identityProviderMappings);
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            LOG.log(Level.WARNING, "ModuleManager missing. Maybe a test");
            return;
        }
        catch (ModuleNotFoundException moduleNotFoundException) {
            LOG.log(Level.WARNING, "Core module missing. Maybe a test");
            return;
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Failed to initialize user session", exception);
        }
        this.isInitialised = true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    @Override
    public Map<String, Object> getSensitiveCustomData() {
        return this.sensitiveCustomData;
    }

    @Override
    public boolean hasRight(String rightName) {
        LOG.fine("hasRight rightName:" + rightName);
        this.init();
        return this.rights.contains(RightFactory.getRight(rightName)) || this.roles.contains(RolesFactory.getBpcAdminRole());
    }

    @Override
    public boolean hasAnyRight(Set<String> rightNames) {
        LOG.fine("hasAnyRight rightNames:" + rightNames);
        this.init();
        if (rightNames != null) {
            for (String rightName : rightNames) {
                if (!this.hasRight(rightName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAllRights(Set<String> rightNames) {
        LOG.fine("hasAllRights rightNames:" + rightNames);
        this.init();
        if (rightNames != null) {
            for (String rightName : rightNames) {
                if (this.hasRight(rightName)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasRole(String roleName) {
        LOG.fine("hasRole roleName:" + roleName);
        this.init();
        return this.roles.contains(RolesFactory.getRole(roleName));
    }

    @Override
    public boolean hasAnyRole(Set<String> roleNames) {
        LOG.fine("hasAnyRole roleNames:" + roleNames);
        this.init();
        if (roleNames != null) {
            for (String roleName : roleNames) {
                if (!this.hasRole(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAllRoles(Set<String> roleNames) {
        LOG.fine("hasAllRoles roleNames:" + roleNames);
        this.init();
        if (roleNames != null) {
            for (String roleName : roleNames) {
                if (this.hasRole(roleName)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasOrganisation(String orgName) {
        LOG.fine("hasOrganisation orgName:" + orgName);
        this.init();
        return this.organisations.contains(OrganisationFactory.getOrganisation(orgName));
    }

    @Override
    public boolean hasAnyOrganisation(Set<String> orgNames) {
        LOG.fine("hasAnyOrganisation orgNames:" + orgNames);
        this.init();
        if (orgNames != null) {
            for (String orgName : orgNames) {
                if (!this.hasOrganisation(orgName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAllOrganisations(Set<String> orgNames) {
        LOG.fine("hasAllOrganisations orgNames:" + orgNames);
        this.init();
        if (orgNames != null) {
            for (String orgName : orgNames) {
                if (this.hasOrganisation(orgName)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final List<Role> getRoles() {
        LOG.finest("getRoles");
        this.init();
        return new ArrayList<Role>(this.roles);
    }

    @Override
    public final List<Right> getRights() {
        LOG.finest("getRights");
        this.init();
        return new ArrayList<Right>(this.rights);
    }

    @Override
    public List<Organisation> getOrganisations() {
        LOG.finest("getOrganisations " + this.organisations.size());
        this.init();
        return new ArrayList<Organisation>(this.organisations);
    }

    @Override
    public List<InactiveOrganisation> getInactiveOrganisations() {
        LOG.finest("getInactiveOrganisations " + this.inactiveOrganisations.size());
        this.init();
        return new ArrayList<InactiveOrganisation>(this.inactiveOrganisations);
    }

    @Override
    public Map<String, List<String>> getPrincipals() {
        LOG.finest("getPrincipals " + this.principals.size());
        this.init();
        return this.principals;
    }

    @Override
    public boolean hasLoadModuleRight(Module module) {
        LOG.finest("hasLoadModuleRight module=" + module);
        this.init();
        if (module == null) {
            return false;
        }
        return this.hasLoadModuleRight(module.getModuleId());
    }

    @Override
    public boolean hasLoadModuleRight(String moduleId) {
        LOG.finest("hasLoadModuleRight moduleId=" + moduleId);
        this.init();
        if (StringUtil.isNullOrEmpty(moduleId)) {
            return false;
        }
        if (this.hasRole("bpcadmin")) {
            return true;
        }
        if ("_core".equals(moduleId)) {
            return true;
        }
        if (this.hasRight("loadModule_" + moduleId)) {
            LOG.finest("User '" + this.getLoginName() + "' is allowed to use module '" + moduleId + "'");
            return true;
        }
        LOG.finest("User '" + this.getLoginName() + "' is NOT allowed to use module '" + moduleId + "'");
        return false;
    }

    @Override
    public boolean hasUseModuleInstanceRight(ModuleInstance moduleInstance) {
        LOG.finest("hasUseModuleInstanceRight moduleInstance=" + moduleInstance);
        this.init();
        if (moduleInstance == null) {
            return false;
        }
        return this.hasUseModuleInstanceRight(moduleInstance.getParentModule(), moduleInstance.getModuleId());
    }

    @Override
    public boolean hasUseModuleInstanceRight(InstantiableModule instantiableModule, String moduleInstanceId) {
        LOG.finest("hasUseModuleInstanceRight instantiableModule=" + instantiableModule + ", moduleInstanceId=" + moduleInstanceId);
        this.init();
        if (instantiableModule == null || moduleInstanceId == null) {
            return false;
        }
        if (!this.hasLoadModuleRight(instantiableModule)) {
            return false;
        }
        if (this.hasRole("bpcadmin")) {
            return true;
        }
        boolean moduleWithRestrictedAccess = (Boolean)instantiableModule.getConfiguration().getSetting("module_restrictInstanceAccess").getValue();
        if (moduleWithRestrictedAccess) {
            for (Right right : this.getRights()) {
                String moduleInstanceIdFromRight;
                if (!right.getName().startsWith("useModuleInstance_") || !moduleInstanceId.equalsIgnoreCase(moduleInstanceIdFromRight = right.getName().substring("useModuleInstance_".length()))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasDeleteModuleInstancesRight(ModuleInstance moduleInstance) {
        LOG.finest("hasDeleteModuleInstanceRight moduleInstance=" + moduleInstance);
        this.init();
        if (moduleInstance == null) {
            return false;
        }
        return this.hasDeleteModuleInstancesRight(moduleInstance.getParentModule(), moduleInstance.getModuleId());
    }

    @Override
    public boolean hasDeleteModuleInstancesRight(InstantiableModule instantiableModule, String moduleInstanceId) {
        LOG.finest("hasDeleteModuleInstanceRight instantiableModule=" + instantiableModule + ", moduleInstanceId=" + moduleInstanceId);
        this.init();
        if (instantiableModule == null || moduleInstanceId == null) {
            return false;
        }
        if (!this.hasLoadModuleRight(instantiableModule)) {
            return false;
        }
        if (this.hasRole("bpcadmin")) {
            return true;
        }
        String moduleId = instantiableModule.getModuleId();
        for (Right right : this.getRights()) {
            String moduleIdFromRight;
            if (!right.getName().startsWith("deleteModuleInstances_") || !moduleId.equalsIgnoreCase(moduleIdFromRight = right.getName().substring("deleteModuleInstances_".length()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCreateModuleInstancesRight(InstantiableModule instantiableModule) {
        LOG.finest("hasCreateModuleInstancesRight instantiableModule=" + instantiableModule);
        this.init();
        if (instantiableModule == null) {
            return false;
        }
        if (!this.hasLoadModuleRight(instantiableModule)) {
            return false;
        }
        if (this.hasRole("bpcadmin")) {
            return true;
        }
        String moduleId = instantiableModule.getModuleId();
        for (Right right : this.getRights()) {
            String moduleIdFromRight;
            if (!right.getName().startsWith("createModuleInstances_") || !moduleId.equalsIgnoreCase(moduleIdFromRight = right.getName().substring("createModuleInstances_".length()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasReadAccessToSettings(Module targetModule, List<? extends Setting> settings) {
        LOG.finest("hasReadAccessToSettings targetModule=" + targetModule + ", settings=...");
        this.init();
        for (Setting setting : settings) {
            RestrictedSetting restrictedTargetSetting;
            Setting targetSetting = this.getModuleDefaultSetting(targetModule, setting);
            if (!(targetSetting instanceof RestrictedSetting) || (restrictedTargetSetting = (RestrictedSetting)targetSetting).isReadableByRoles(this.getRoles())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasReadAccessToSetting(Module targetModule, Setting setting) {
        LOG.finest("hasReadAccessToSetting targetModule=" + targetModule + ", setting=...");
        this.init();
        return this.hasReadAccessToSettings(targetModule, Collections.singletonList(setting));
    }

    @Override
    public boolean hasWriteAccessToSettings(Module targetModule, List<? extends Setting> settings) {
        LOG.finest("hasWriteAccessToSettings targetModule=" + targetModule + ", settings=...");
        this.init();
        for (Setting setting : settings) {
            RestrictedSetting restrictedTargetSetting;
            Setting targetSetting = this.getModuleDefaultSetting(targetModule, setting);
            if (!(targetSetting instanceof RestrictedSetting) || (restrictedTargetSetting = (RestrictedSetting)targetSetting).isWriteableByRoles(this.getRoles())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasWriteAccessToSetting(Module targetModule, Setting setting) {
        LOG.finest("hasWriteAccessToSetting targetModule=" + targetModule + ", setting=...");
        this.init();
        return this.hasWriteAccessToSettings(targetModule, Collections.singletonList(setting));
    }

    @Override
    public boolean hasImpersonator() {
        return !StringUtil.isNullOrEmpty(this.getImpersonatorUsername());
    }

    @Override
    public String getImpersonatorUsername() {
        Object usernameObject;
        Map impersonator;
        Object impersonatorObject;
        Map<String, Object> customData = this.getCustomData();
        if (customData != null && customData.containsKey("impersonator") && (impersonatorObject = customData.get("impersonator")) instanceof Map && (impersonator = (Map)impersonatorObject).containsKey("username") && (usernameObject = impersonator.get("username")) != null) {
            return String.valueOf(usernameObject);
        }
        return null;
    }

    public String toString() {
        LOG.finest("toString");
        this.init();
        return "AbstractUserSession{roles=" + this.roles + ", rightList=" + this.rights + "}";
    }

    public Setting getModuleDefaultSetting(Module module, Setting setting) {
        LOG.log(Level.FINEST, "getModuleDefaultSetting");
        ModuleConfiguration mc = module.getConfiguration();
        if (mc instanceof ModuleConfigurationImpl) {
            return ((ModuleConfigurationImpl)mc).getDefaultSettings().get(setting.getName());
        }
        LOG.severe("Hi BPC devs, I have found a bug in your module model. The module '" + module + "' uses an unexpected ModuleConfiguration implementation: '" + (mc == null ? null : mc.getClass().getName()) + "'. This must be fixed!");
        return null;
    }
}

