/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class ClientSessionsChecker
implements Checker {
    private static final Logger LOG = Logger.getLogger(ClientSessionsChecker.class.getName());
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;

    public ClientSessionsChecker(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private CoreModule getCoreModule() throws ServiceNotFoundException, ModuleNotFoundException {
        return this.moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
    }

    private long getSessionCheckIntervalInSeconds(CoreModule coreModule) {
        return coreModule.getConfiguration().getSettingValue("clientSession.checkInterval").asLong(60L);
    }

    private int getInactiveSessionTimeoutMinutes(CoreModule coreModule) {
        return coreModule.getConfiguration().getSettingValue("clientSession.inactiveSessionTimeoutMinutes").asInt(0);
    }

    @Override
    public void startChecker() {
        LOG.info("startChecker");
        if (this.checkerHandle != null) {
            LOG.info("Client sessions checker is already running");
            return;
        }
        BpcServicesTracker.stopAll(this);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        try {
            long sessionCheckIntervalInSeconds = this.getSessionCheckIntervalInSeconds(this.getCoreModule());
            LOG.info("Init client sessions checker with interval: " + sessionCheckIntervalInSeconds + " seconds");
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-sessionchecker"));
            this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createCheckerRunnable(), sessionCheckIntervalInSeconds, sessionCheckIntervalInSeconds, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to start the client sessions checker.", ex);
        }
    }

    @Override
    public void stopChecker() {
        LOG.info("stopChecker");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOG.info("Running client sessions checker cancelled");
            } else {
                LOG.warning("Could not cancel the running client sessions checker");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        BpcServicesTracker.stopAll(this);
    }

    private Runnable createCheckerRunnable() {
        LOG.info("createCheckerRunnable");
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.info("Check all client sessions: START");
                long sessionCheckStartTime = System.currentTimeMillis();
                try {
                    ClientSessionManager clientSessionManager = ClientSessionsChecker.this.clientSessionManagerTracker.getService();
                    CoreModule coreModule = ClientSessionsChecker.this.getCoreModule();
                    IdentityProvider identityProvider = coreModule.getIdentityProvider();
                    if (identityProvider == null) {
                        LOG.warning("Could not check the client sessions without an identity provider!");
                        return;
                    }
                    if (clientSessionManager == null) {
                        LOG.warning("Could not check the client sessions without the client session manager!");
                        return;
                    }
                    long sessionCheckIntervalInSeconds = ClientSessionsChecker.this.getSessionCheckIntervalInSeconds(coreModule);
                    LOG.fine("sessionCheckIntervalInSeconds = " + sessionCheckIntervalInSeconds);
                    int inactiveSessionTimeoutInMinutes = ClientSessionsChecker.this.getInactiveSessionTimeoutMinutes(coreModule);
                    LOG.fine("inactiveSessionTimeoutInMinutes = " + inactiveSessionTimeoutInMinutes);
                    for (ClientSession clientSession : clientSessionManager.getAllSessions()) {
                        String sessionId = clientSession.getSessionId();
                        UserSession userSession = clientSession.getUserSession();
                        if (userSession != null) {
                            if (inactiveSessionTimeoutInMinutes > 0 && clientSession.isInactiveSinceMinutes(inactiveSessionTimeoutInMinutes)) {
                                LOG.warning("Inactivity check: User session without websocket sessions since " + inactiveSessionTimeoutInMinutes + " minutes ... removing session");
                                UserAuditLog.warning(userSession, "logout", "Inactivity logout");
                                clientSessionManager.removeSession(sessionId, true, identityProvider);
                            }
                            UserSession us = null;
                            if (identityProvider.isOwner(userSession)) {
                                try {
                                    us = identityProvider.checkSession(userSession, sessionCheckIntervalInSeconds);
                                }
                                catch (IdentityProviderException ex) {
                                    LOG.log(Level.WARNING, null, ex);
                                }
                            }
                            if (us != null && !us.getExpirationDate().before(new Date())) continue;
                            LOG.warning("IdentityProvider check: No user session or expired date ... removing session");
                            clientSessionManager.removeSession(sessionId, true, identityProvider);
                            continue;
                        }
                        LOG.warning("There is a client session without a user session. That should not be possible and gets removed.");
                        clientSessionManager.removeSession(sessionId, true, identityProvider);
                    }
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to check for expired client sessions.", ex);
                }
                finally {
                    LOG.info("Check all client sessions: STOP (" + (System.currentTimeMillis() - sessionCheckStartTime) + " ms)");
                }
            }
        };
    }
}

