/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class IdentityProviderChecker
implements Checker {
    private final CoreModule coreModule;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;

    public IdentityProviderChecker(CoreModule coreModule) {
        this.coreModule = coreModule;
    }

    @Override
    public void startChecker() {
        LOG.info("IdentityProviderChecker.startChecker");
        if (this.checkerHandle != null) {
            LOG.warning("Identity provider checker is already running");
            return;
        }
        try {
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-idpchecker"));
            this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createCheckerRunnable(), 60L, 30L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to start the identity provider checker.", ex);
        }
    }

    @Override
    public void stopChecker() {
        LOG.info("IdentityProviderChecker.stopChecker");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOG.info("Running identity provider checker cancelled");
            } else {
                LOG.warning("Failed to cancel the running identity provider checker");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private Runnable createCheckerRunnable() {
        LOG.info("createCheckerRunnable");
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (IdentityProviderChecker.this.coreModule.shouldTryToRefreshIdentityProvider()) {
                        IdentityProviderChecker.this.coreModule.refreshIdentityProvider();
                    }
                }
                catch (Throwable t) {
                    Checker.LOG.log(Level.SEVERE, "Failed to perform the identity provider check.", t);
                }
            }
        };
    }
}

