/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.jaas.inubit.InubitBackingEngine;
import de.virtimo.bpc.core.auth.oidc.KeycloakIdentityProvider;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.util.MapUtil;
import java.util.Map;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class IdentityProviderConnectionTester
implements ConnectionTester {
    private static final Logger LOG = Logger.getLogger(IdentityProviderConnectionTester.class.getName());
    private final BundleContext bundleContext;

    public IdentityProviderConnectionTester(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
    }

    @Override
    public boolean canBeUsedToPerformConnectionTest(ModuleInstance moduleInstance) {
        LOG.info("canBeUsedToPerformConnectionTest moduleInstance=...");
        return moduleInstance != null && "backendconnection".equalsIgnoreCase(moduleInstance.getParentModule().getModuleId()) && "identity_provider".equalsIgnoreCase(moduleInstance.getInstanceType());
    }

    @Override
    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws ConnectionTestException {
        block8: {
            LOG.info("performConnectionTest moduleInstance=..., testData=...");
            try {
                IdentityProviderConfiguration idpConfiguration = new IdentityProviderConfiguration(moduleInstance.getConfiguration());
                String idpName = idpConfiguration.getIdentityProviderName();
                if ("karaf".equalsIgnoreCase(idpName)) {
                    this.performKarafConnectionTest(idpConfiguration, testData);
                    break block8;
                }
                if ("jdbc".equalsIgnoreCase(idpName)) {
                    this.performJdbcConnectionTest(idpConfiguration, testData);
                    break block8;
                }
                if ("inubit".equalsIgnoreCase(idpName)) {
                    this.performInubitConnectionTest(idpConfiguration, testData);
                    break block8;
                }
                if ("oidc".equalsIgnoreCase(idpName)) {
                    this.performOidcConnectionTest(idpConfiguration, testData);
                    break block8;
                }
                if ("keycloak".equalsIgnoreCase(idpName)) {
                    this.performKeycloakConnectionTest(idpConfiguration, testData);
                    break block8;
                }
                throw new ConnectionTestException("Invalid identity provider name: ${idpName}", MapUtil.mapOf("idpName", idpName));
            }
            catch (ConnectionTestException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ConnectionTestException(ex);
            }
        }
    }

    private void performKarafConnectionTest(IdentityProviderConfiguration idpConfiguration, Map<String, Object> testData) throws ConnectionTestException {
        LOG.info("performKarafConnectionTest idpConfiguration=..., testData=...");
    }

    private void performJdbcConnectionTest(IdentityProviderConfiguration idpConfiguration, Map<String, Object> testData) throws ConnectionTestException {
        LOG.info("performJdbcConnectionTest idpConfiguration=..., testData=...");
        try (BpcServicesTracker<DatabaseManager> databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(this.bundleContext, DatabaseManager.class);){
            DatabaseManager databaseManager = databaseManagerTracker.getService();
            Map<String, Object> jdbcIdentityProviderSettings = idpConfiguration.getSpecificConfigurationAsMap();
            String dataSourceName = (String)jdbcIdentityProviderSettings.get("datasource");
            databaseManager.performConnectionTest(dataSourceName);
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInubitConnectionTest(IdentityProviderConfiguration idpConfiguration, Map<String, Object> testData) throws ConnectionTestException {
        LOG.info("performInubitConnectionTest idpConfiguration=..., testData=...");
        InubitBackingEngine inubitBackingEngine = new InubitBackingEngine(null);
        try {
            inubitBackingEngine.performConnectionTest(idpConfiguration);
        }
        finally {
            inubitBackingEngine.destroy();
        }
    }

    private void performOidcConnectionTest(IdentityProviderConfiguration idpConfiguration, Map<String, Object> testData) throws ConnectionTestException {
        LOG.info("performOidcConnectionTest idpConfiguration=..., testData=...");
        try {
            String discoveryUrl = idpConfiguration.getIdentityProviderUrl();
            Map<String, Object> config = idpConfiguration.getSpecificConfigurationAsMap();
            int sessionExpirationMinutes = idpConfiguration.getSessionExpirationInMinutes();
            OidcIdentityProvider oidcIdP = new OidcIdentityProvider(this.bundleContext, discoveryUrl, config, sessionExpirationMinutes);
            oidcIdP.performConnectionTest();
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }

    private void performKeycloakConnectionTest(IdentityProviderConfiguration idpConfiguration, Map<String, Object> testData) throws ConnectionTestException {
        LOG.info("performKeycloakConnectionTest idpConfiguration=..., testData=...");
        try {
            String discoveryUrl = idpConfiguration.getIdentityProviderUrl();
            Map<String, Object> config = idpConfiguration.getSpecificConfigurationAsMap();
            int sessionExpirationMinutes = idpConfiguration.getSessionExpirationInMinutes();
            KeycloakIdentityProvider keycloakIdP = new KeycloakIdentityProvider(this.bundleContext, discoveryUrl, config, sessionExpirationMinutes);
            keycloakIdP.performConnectionTest();
        }
        catch (ConnectionTestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
    }
}

