/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.apikey.APIKeySession;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.core.auth.UserIdentification;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;

public class IpPinningServiceImpl
implements IpPinningService,
BpcService {
    private static final Logger LOG = Logger.getLogger(IpPinningServiceImpl.class.getName());
    public static final String USER_IDENTIFICATION_OBJECT_KEY = "userIdentificationObject";
    private final BundleContext bundleContext;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;

    public IpPinningServiceImpl(BundleContext bundleContext) {
        LOG.info("IpPinningServiceImpl bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean isValidRequest(HttpServletRequest httpServletRequest, UserSession userSession) {
        if (userSession instanceof APIKeySession) {
            return true;
        }
        if (!this.isIpPinningEnabled()) {
            return true;
        }
        UserIdentification userIdentificationOfServletRequest = new UserIdentification(httpServletRequest);
        UserIdentification identificationOfUserSession = (UserIdentification)userSession.getSensitiveCustomData().get(USER_IDENTIFICATION_OBJECT_KEY);
        boolean valid = userIdentificationOfServletRequest.equals(identificationOfUserSession);
        if (!valid) {
            LOG.warning("IP-Pinning mismatch found! User identification from user session: " + identificationOfUserSession + " and from servlet request: " + userIdentificationOfServletRequest);
        }
        return valid;
    }

    @Override
    public boolean isIpPinningEnabled() {
        try {
            return this.coreBundleConfigurationTracker.getService().isIpPinningCheckEnabled();
        }
        catch (ServiceNotFoundException ex) {
            LOG.log(Level.SEVERE, "Failed to get the info if IP pinning is enabled.", ex);
            return false;
        }
    }
}

