/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerUnsupportedOperationException;
import de.virtimo.bpc.core.auth.IdentityProviderMappings;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import java.util.Set;
import java.util.logging.Logger;

public class UnsupportedIdentityProviderOperationsFallbackHandler {
    private static final Logger LOG = Logger.getLogger(UnsupportedIdentityProviderOperationsFallbackHandler.class.getName());
    private ModuleConfiguration idpConfiguration;
    private Setting oldIdpMappingsSetting;
    private IdentityProviderMappings idpMappings;

    public UnsupportedIdentityProviderOperationsFallbackHandler(ModuleConfiguration idpConfiguration) {
        this.initialize(idpConfiguration);
    }

    public void initialize(ModuleConfiguration idpConfiguration) {
        this.idpConfiguration = idpConfiguration;
        this.oldIdpMappingsSetting = idpConfiguration.getSetting("identityProvider_mappings");
        this.idpMappings = new IdentityProviderMappings(this.oldIdpMappingsSetting);
    }

    public boolean isUnsupportedOperationException(Exception ex) {
        LOG.info("isUnsupportedOperationException ex=...");
        if (ex instanceof UnsupportedOperationException) {
            return true;
        }
        if (ex instanceof IdentityManagerUnsupportedOperationException) {
            return true;
        }
        if (ex instanceof IdentityManagerException) {
            IdentityManagerException ime = (IdentityManagerException)ex;
            if (ime.isErrorCode(BpcErrorCode.IM_UNSUPPORTED_OPERATION)) {
                return true;
            }
        }
        return false;
    }

    private void updateIdpMappingsSettingInModuleConfiguration() throws SettingException {
        LOG.info("updateIdpMappingsSettingInModuleConfiguration");
        SimpleSettingImpl updatedIdpMappingsSetting = new SimpleSettingImpl(this.oldIdpMappingsSetting, this.idpMappings.asMap());
        this.idpConfiguration.updateSetting(updatedIdpMappingsSetting, false);
    }

    public void addOrganisation(String userId, String organisationName) throws SettingException {
        LOG.info("addOrganisation userId" + userId + ", organisationName=" + organisationName);
        this.idpMappings.addOrganisationToUser(organisationName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public void deleteOrganisation(String userId, String organisationName) throws SettingException {
        LOG.info("deleteOrganisation userId" + userId + ", organisationName=" + organisationName);
        this.idpMappings.removeOrganisationFromUser(organisationName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public Set<Organisation> getOrganisations() {
        LOG.info("getOrganisations");
        return OrganisationFactory.getOrganisations(this.idpMappings.getOrganisationsOfAllUsers());
    }

    public Set<Organisation> getUserOrganisations(String userId) {
        LOG.info("getUserOrganisations userId=" + userId);
        return OrganisationFactory.getOrganisations(this.idpMappings.getOrganisationsOfUser(userId));
    }

    public Set<Organisation> getManuallySetOrganisationsFromIdpMappings() {
        LOG.info("getManuallySetOrganisationsFromIdpMappings");
        return OrganisationFactory.getOrganisations(this.idpMappings.getManuallySetOrganisations());
    }

    public void addRole(String userId, String roleName) throws SettingException {
        LOG.info("addRole userId" + userId + ", roleName=" + roleName);
        this.idpMappings.addRoleToUser(roleName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public void deleteRole(String userId, String roleName) throws SettingException {
        LOG.info("deleteRole userId" + userId + ", roleName=" + roleName);
        this.idpMappings.removeRoleFromUser(roleName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public Set<Role> getRoles() {
        LOG.info("getRoles");
        return RolesFactory.getRoles(this.idpMappings.getRolesOfAllUsers());
    }

    public Set<Role> getUserRoles(String userId) {
        LOG.info("getUserRoles userId=" + userId);
        return RolesFactory.getRoles(this.idpMappings.getRolesOfUser(userId));
    }

    public Set<Role> getManuallySetRolesFromIdpMappings() {
        LOG.info("getManuallySetRolesFromIdpMappings");
        return RolesFactory.getRoles(this.idpMappings.getManuallySetRoles());
    }

    public void addRight(String userId, String rightName) throws SettingException {
        LOG.info("addRight userId" + userId + ", rightName=" + rightName);
        this.idpMappings.addRightToUser(rightName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public void deleteRight(String userId, String rightName) throws SettingException {
        LOG.info("deleteRight userId" + userId + ", rightName=" + rightName);
        this.idpMappings.removeRightFromUser(rightName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public Set<Right> getRights() {
        LOG.info("getRights");
        return RightFactory.getRights(this.idpMappings.getRightsOfAllUsers());
    }

    public Set<Right> getUserRights(String userId) {
        LOG.info("getUserRights userId=" + userId);
        return RightFactory.getRights(this.idpMappings.getRightsOfUser(userId));
    }

    public Set<Right> getManuallySetRightsFromIdpMappings() {
        LOG.info("getManuallySetRightsFromIdpMappings");
        return RightFactory.getRights(this.idpMappings.getManuallySetRights());
    }
}

