/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class UserIdentification {
    private final String remoteHost;
    private final String remoteAddress;
    private final String forwardedForAddress;

    public UserIdentification(HttpServletRequest httpServletRequest) {
        this.remoteHost = httpServletRequest.getRemoteHost();
        this.remoteAddress = httpServletRequest.getRemoteAddr();
        this.forwardedForAddress = httpServletRequest.getHeader("X-Forwarded-For");
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getForwardedForAddress() {
        return this.forwardedForAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserIdentification that = (UserIdentification)o;
        return this.remoteHost.equals(that.remoteHost) && this.remoteAddress.equals(that.remoteAddress) && Objects.equals(this.forwardedForAddress, that.forwardedForAddress);
    }

    public int hashCode() {
        return Objects.hash(this.remoteHost, this.remoteAddress, this.forwardedForAddress);
    }

    public String toString() {
        return "[host:" + this.remoteHost + "] [ip:" + this.remoteAddress + "] [X-Forwarded-For:" + this.forwardedForAddress + "]";
    }
}

