/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.auth.idp.UserSessionRequest;
import de.virtimo.bpc.api.auth.jaas.BpcCallbackHandler;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerUnsupportedOperationException;
import de.virtimo.bpc.core.auth.UnsupportedIdentityProviderOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.idp.HttpUserSessionRequest;
import de.virtimo.bpc.core.auth.idp.IdentityProviderWithUnsupportedOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.jaas.BackingEngineDataConverter;
import de.virtimo.bpc.core.auth.jaas.BpcCallbackHandlerImpl;
import de.virtimo.bpc.core.auth.jaas.ExtBackingEngine;
import de.virtimo.bpc.core.auth.jaas.JaasSession;
import de.virtimo.bpc.core.auth.jaas.RightPrincipal;
import de.virtimo.bpc.core.auth.jaas.inubit.InubitUserSession;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.Generic;
import de.virtimo.bpc.util.MapUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.karaf.jaas.modules.properties.PropertiesBackingEngine;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class JaasProvider
implements IdentityProvider,
IdentityManager,
IdentityProviderWithUnsupportedOperationsFallbackHandler {
    private static final Logger LOG = Logger.getLogger(JaasProvider.class.getName());
    public static final String KARAF = "karaf";
    public static final String INUBIT = "inubit";
    public static final String JDBC = "jdbc";
    private final BundleContext bundleContext;
    private final Map<String, UserSession> sessionMap;
    private int sessionExpirationInMinutes;
    private final String loginContextId;
    private UnsupportedIdentityProviderOperationsFallbackHandler unsupportedIdentityProviderOperationsFallbackHandler;

    public JaasProvider(BundleContext bundleContext, String loginContextId, int sessionExpirationInMinutes) {
        LOG.info("JaasProvider bundleContext=" + bundleContext + ", loginContextId=" + loginContextId + ", sessionExpirationInMinutes=" + sessionExpirationInMinutes);
        this.bundleContext = bundleContext;
        this.sessionMap = new HashMap<String, UserSession>();
        this.loginContextId = loginContextId;
        this.sessionExpirationInMinutes = sessionExpirationInMinutes;
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
    }

    public String getLoginContextId() {
        return this.loginContextId;
    }

    @Override
    public UnsupportedIdentityProviderOperationsFallbackHandler getUnsupportedIdentityProviderOperationsFallbackHandler() {
        return this.unsupportedIdentityProviderOperationsFallbackHandler;
    }

    @Override
    public void setUnsupportedIdentityProviderOperationsFallbackHandler(UnsupportedIdentityProviderOperationsFallbackHandler unsupportedIdentityProviderOperationsFallbackHandler) {
        this.unsupportedIdentityProviderOperationsFallbackHandler = unsupportedIdentityProviderOperationsFallbackHandler;
    }

    public void setSessionExpirationInMinutes(int sessionExpirationInMinutes) {
        this.sessionExpirationInMinutes = sessionExpirationInMinutes;
    }

    @Override
    public boolean isOwner(UserSession userSession) {
        return userSession instanceof JaasSession || userSession instanceof InubitUserSession;
    }

    @Override
    public UserSession checkSession(UserSession userSession, long sessionCheckIntervalInSeconds) {
        LOG.log(Level.FINEST, "checkSession userSession=..., sessionCheckIntervalInSeconds=" + sessionCheckIntervalInSeconds);
        if (userSession == null) {
            return null;
        }
        String sessionId = userSession.getSessionId();
        return this.checkSession(sessionId);
    }

    private UserSession checkSession(String sessionId) {
        UserSession userSession;
        block18: {
            LOG.log(Level.FINEST, "checkSession");
            if (sessionId == null) {
                return null;
            }
            userSession = this.sessionMap.get(sessionId);
            if (userSession != null) {
                long diff = userSession.getExpirationDate().getTime() - new Date().getTime();
                if (diff <= 0L) {
                    LOG.log(Level.FINEST, "session expired");
                    this.sessionMap.remove(sessionId);
                    userSession = null;
                } else {
                    LOG.log(Level.FINEST, "try to check via BackingEngine");
                    try {
                        BackingEngine backingEngine = this.getBackingEngine();
                        if (backingEngine instanceof ExtBackingEngine) {
                            boolean sessionOk = ((ExtBackingEngine)backingEngine).checkSession(sessionId);
                            if (!sessionOk) {
                                LOG.log(Level.INFO, "BackingEngine returned false on session check; Session will be destroyed");
                                this.sessionMap.remove(sessionId);
                                userSession = null;
                            } else {
                                LOG.log(Level.FINEST, "session is ok");
                            }
                            break block18;
                        }
                        LOG.log(Level.FINEST, "didn't find appropriate ExtBackingEngine");
                    }
                    catch (IdentityProviderException ipe) {
                        LOG.log(Level.FINEST, "IdentityProviderException", ipe);
                    }
                    catch (UnsupportedOperationException uoe) {
                        LOG.log(Level.FINEST, "session check not supported by BackingEngine");
                    }
                }
            } else {
                LOG.log(Level.FINEST, "no session found in cache, check BackingEngine");
                try {
                    BackingEngine backingEngine = this.getBackingEngine();
                    if (backingEngine instanceof ExtBackingEngine) {
                        userSession = ((ExtBackingEngine)backingEngine).getSession(sessionId);
                        if (userSession != null) {
                            LOG.log(Level.INFO, "BackingEngine returned an session ; Session will be added");
                            this.sessionMap.put(sessionId, userSession);
                        } else {
                            LOG.log(Level.FINEST, "no session from BackingEngine");
                        }
                    } else {
                        LOG.log(Level.FINEST, "didn't find appropriate ExtBackingEngine");
                    }
                }
                catch (IdentityProviderException ipe) {
                    LOG.log(Level.FINEST, "IdentityProviderException", ipe);
                }
                catch (UnsupportedOperationException uoe) {
                    LOG.log(Level.FINEST, "session check not supported by BackingEngine");
                }
            }
        }
        return userSession;
    }

    @Override
    public UserSession login(String tenant, String username, String password) throws IdentityProviderException {
        LOG.log(Level.FINEST, "login");
        BpcCallbackHandlerImpl cbh = new BpcCallbackHandlerImpl();
        cbh.setPassword(password.toCharArray());
        cbh.setUsername(username);
        cbh.setTenant(tenant);
        return this.login(cbh);
    }

    @Override
    public UserSession login(BpcCallbackHandler bpcCallbackHandler) throws IdentityProviderException {
        LOG.log(Level.FINEST, "login");
        try {
            JaasSession session;
            LoginContext lc = new LoginContext(this.loginContextId, bpcCallbackHandler);
            lc.login();
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
                Set<Organisation> userOrganisations = this.unsupportedIdentityProviderOperationsFallbackHandler.getUserOrganisations(bpcCallbackHandler.getUsername());
                for (Organisation organisation : userOrganisations) {
                    lc.getSubject().getPrincipals().add((Principal)new GroupPrincipal(organisation.getName()));
                }
                Set<Role> userRoles = this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRoles(bpcCallbackHandler.getUsername());
                for (Role userRole : userRoles) {
                    lc.getSubject().getPrincipals().add((Principal)new RolePrincipal(userRole.getName()));
                }
                Set<Right> set = this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRights(bpcCallbackHandler.getUsername());
                for (Right userRight : set) {
                    lc.getSubject().getPrincipals().add(new RightPrincipal(userRight.getName()));
                }
            }
            if ((session = new JaasSession(lc, bpcCallbackHandler, this.getBackingEngine(), this.sessionExpirationInMinutes)).hasRole("bpcNoFrontend")) {
                LOG.warning("Login denied because user has role bpcNoFrontend");
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_ROLE_CHECK_FAILED, "CORE_ERROR_IDENTITY_PROVIDER_LOGIN_FAILED_USER_HAS_ROLE", MapUtil.mapOf("role", "bpcNoFrontend"));
            }
            this.sessionMap.put(session.getSessionId(), session);
            return session;
        }
        catch (IdentityProviderException ex) {
            throw ex;
        }
        catch (LoginException ex) {
            LOG.log(Level.SEVERE, "Error login", ex);
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_LOGIN_FAILED, "CORE_ERROR_IDENTITY_PROVIDER_LOGIN_FAILED", ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unexpected error login", ex);
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.UNEXPECTED, "CORE_ERROR_IDENTITY_PROVIDER_LOGIN_FAILED", ex);
        }
    }

    @Override
    public UserSession updateSession(UserSession oldSession, String newTenant) throws IdentityProviderException {
        LOG.log(Level.FINEST, "updateSession");
        if (!(oldSession instanceof JaasSession)) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_JAAS_SESSION_UPDATE_FAILED");
        }
        JaasSession oldJaasSession = (JaasSession)oldSession;
        if (oldJaasSession.getBpcCallbackHandler() == null) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_JAAS_SESSION_UPDATE_FAILED");
        }
        BpcCallbackHandler bpcCallbackHandler = oldJaasSession.getBpcCallbackHandler();
        bpcCallbackHandler.setTenant(newTenant);
        UserSession newSession = this.login(bpcCallbackHandler);
        this.sessionMap.remove(oldSession.getSessionId());
        return newSession;
    }

    @Override
    public void logout(String sessionId) {
        LOG.log(Level.FINEST, "logout");
        UserSession session = this.sessionMap.remove(sessionId);
        if (session != null) {
            session.destroy();
        }
    }

    @Override
    public boolean canUpdateUserPasswords() throws IdentityProviderException {
        LOG.info("canUpdateUserPasswords");
        BackingEngine backingEngine = this.getBackingEngine();
        if (backingEngine == null) {
            return false;
        }
        if (backingEngine instanceof PropertiesBackingEngine) {
            return true;
        }
        try {
            boolean checkPasswordMethodExists = backingEngine.getClass().getDeclaredMethod("checkPassword", String.class, String.class) != null;
            boolean updatePasswordMethodExists = backingEngine.getClass().getDeclaredMethod("updatePassword", String.class, String.class) != null;
            return checkPasswordMethodExists && updatePasswordMethodExists;
        }
        catch (NoSuchMethodException | NullPointerException ex) {
            return false;
        }
    }

    @Override
    public void updateUserPassword(String userName, String oldPassword, String newPassword) throws IdentityProviderException {
        LOG.info("updateUserPassword userName=" + userName + ", oldPassword=..., newPassword=...");
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof PropertiesBackingEngine) {
                PropertiesBackingEngine propertiesBackingEngine = (PropertiesBackingEngine)backingEngine;
                if (!this.checkUserPassword(propertiesBackingEngine, userName, oldPassword)) {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_DOES_NOT_MATCH");
                }
                this.updateUserPassword(propertiesBackingEngine, userName, newPassword);
            } else {
                Method checkPasswordMethod = backingEngine.getClass().getDeclaredMethod("checkPassword", String.class, String.class);
                if (checkPasswordMethod.invoke((Object)backingEngine, userName, oldPassword).equals(Boolean.FALSE)) {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_DOES_NOT_MATCH");
                }
                Method updatePasswordMethod = backingEngine.getClass().getDeclaredMethod("updatePassword", String.class, String.class);
                updatePasswordMethod.invoke((Object)backingEngine, userName, newPassword);
            }
        }
        catch (IdentityProviderException ex) {
            throw ex;
        }
        catch (UnsupportedOperationException ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_UNSUPPORTED_OPERATION, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_UNSUPPORTED");
        }
        catch (Exception ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.UNEXPECTED, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD", ex);
        }
    }

    @Override
    public UserSession requestUserSession(UserSessionRequest userSessionRequest) throws IdentityProviderException {
        LOG.finest("requestUserSession");
        if (!(userSessionRequest instanceof HttpUserSessionRequest)) {
            throw new IllegalArgumentException("only support HttpUserSessionRequest");
        }
        HttpUserSessionRequest httpUserSessionRequest = (HttpUserSessionRequest)userSessionRequest;
        String sessionId = httpUserSessionRequest.getCookieValue("BPC_J_S");
        UserSession userSession = this.checkSession(sessionId);
        if (userSession == null) {
            String username = httpUserSessionRequest.getFormParam("username");
            String password = httpUserSessionRequest.getFormParam("password");
            if (username != null && password != null) {
                userSession = this.login(Generic.getValueOrDefault(httpUserSessionRequest.getFormParam("tenantname"), ""), username, password);
            }
        }
        return userSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackingEngine getBackingEngineOfCurrentLoginModule() throws InvalidSyntaxException {
        LOG.log(Level.FINEST, "getBackingEngineOfCurrentLoginModule");
        Collection backingEngineFactoryReferences = this.bundleContext.getServiceReferences(BackingEngineFactory.class, null);
        if (backingEngineFactoryReferences == null) {
            return null;
        }
        Configuration config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return Configuration.getConfiguration();
            }
        });
        AppConfigurationEntry[] entries = config.getAppConfigurationEntry(this.loginContextId);
        LOG.log(Level.FINEST, "loginContextId: " + this.loginContextId);
        for (AppConfigurationEntry entry : entries) {
            String loginModuleClassName = (String)entry.getOptions().get("org.apache.karaf.jaas.module");
            LOG.info("loginModuleClassName = " + loginModuleClassName);
            String loginModulePackageName = loginModuleClassName.substring(0, loginModuleClassName.lastIndexOf(46));
            LOG.info("loginModulePackageName = " + loginModulePackageName);
            Map<String, ?> loginModuleOptions = entry.getOptions();
            LOG.info("loginModuleOptions = " + loginModuleOptions);
            for (ServiceReference backingEngineFactoryReference : backingEngineFactoryReferences) {
                try {
                    BackingEngineFactory backingEngineFactory = (BackingEngineFactory)this.bundleContext.getService(backingEngineFactoryReference);
                    String backingEngineFactoryPackageName = backingEngineFactory.getClass().getPackage().getName();
                    LOG.info("backingEngineFactory package = " + backingEngineFactoryPackageName);
                    if (!backingEngineFactoryPackageName.equals(loginModulePackageName)) continue;
                    LOG.info("backingEngineFactory = " + backingEngineFactory);
                    BackingEngine backingEngine = backingEngineFactory.build(loginModuleOptions);
                    return backingEngine;
                }
                finally {
                    this.bundleContext.ungetService(backingEngineFactoryReference);
                }
            }
        }
        return null;
    }

    private BackingEngine getBackingEngine() throws IdentityProviderException {
        LOG.log(Level.FINEST, "getBackingEngine");
        try {
            return this.getBackingEngineOfCurrentLoginModule();
        }
        catch (Exception ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_BACKING_ENGINE", ex);
        }
    }

    @Override
    public User getUser(String userId) throws IdentityManagerException {
        LOG.info("getUser");
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                return ((IdentityManager)backingEngine).getUser(userId);
            }
            return BackingEngineDataConverter.getUser(backingEngine, userId);
        }
        catch (IdentityManagerException ex) {
            throw ex;
        }
        catch (UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER", e);
        }
    }

    @Override
    public List<User> getUsers() throws IdentityManagerException {
        LOG.info("getUsers");
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                return ((IdentityManager)backingEngine).getUsers();
            }
            return BackingEngineDataConverter.getUsers(backingEngine);
        }
        catch (IdentityManagerException ex) {
            throw ex;
        }
        catch (UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USERS_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USERS", e);
        }
    }

    @Override
    public Set<Organisation> getOrganisations() throws IdentityManagerException {
        LOG.info("getOrganisations");
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                return ((IdentityManager)backingEngine).getOrganisations();
            }
            return BackingEngineDataConverter.getOrganisations(backingEngine);
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getOrganisations();
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_ORGANISATIONS_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_ORGANISATIONS", e);
        }
    }

    @Override
    public Set<Role> getRoles() throws IdentityManagerException {
        LOG.info("getRoles");
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                return ((IdentityManager)backingEngine).getRoles();
            }
            return BackingEngineDataConverter.getRoles(backingEngine);
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getRoles();
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_ROLES_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_ROLES", e);
        }
    }

    @Override
    public Set<Right> getRights() throws IdentityManagerException {
        LOG.info("getRights");
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                return ((IdentityManager)backingEngine).getRights();
            }
            throw new UnsupportedOperationException("Get rights is not supported by this identity provider.");
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getRights();
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_RIGHTS_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_RIGHTS", e);
        }
    }

    @Override
    public Set<Organisation> getUserOrganisations(String userId) throws IdentityManagerException {
        LOG.info("getUserOrganisations userId=" + userId);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                return ((IdentityManager)backingEngine).getUserOrganisations(userId);
            }
            return BackingEngineDataConverter.getUserOrganisations(backingEngine, userId, true);
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getUserOrganisations(userId);
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ORGANISATIONS_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ORGANISATIONS", e);
        }
    }

    @Override
    public Set<Role> getUserRoles(String userId) throws IdentityManagerException {
        LOG.info("getUserRoles userId=" + userId);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                return ((IdentityManager)backingEngine).getUserRoles(userId);
            }
            return BackingEngineDataConverter.getUserRoles(backingEngine, userId, true);
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRoles(userId);
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ROLES_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ROLES", MapUtil.mapOf("user", userId), (Throwable)e);
        }
    }

    @Override
    public Set<Right> getUserRights(String userId) throws IdentityManagerException {
        LOG.info("getUserRights userId=" + userId);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                return ((IdentityManager)backingEngine).getUserRights(userId);
            }
            throw new UnsupportedOperationException("Get user rights is not supported by this identity provider.");
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                return this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRights(userId);
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_USER_RIGHTS_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_RIGHTS", MapUtil.mapOf("user", userId), (Throwable)e);
        }
    }

    @Override
    public void addUser(String userId, String userPassword) throws IdentityManagerException {
        LOG.info("addUser userId=" + userId + ", userPassword=" + userPassword);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                ((IdentityManager)backingEngine).addUser(userId, userPassword);
            } else {
                backingEngine.addUser(userId, userPassword);
            }
        }
        catch (IdentityManagerException ex) {
            throw ex;
        }
        catch (UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER", e);
        }
    }

    @Override
    public void addUser(User user, String userPassword) throws IdentityManagerException {
        LOG.info("addUser user=" + user + ", userPassword=...");
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                ((IdentityManager)backingEngine).addUser(user, userPassword);
            } else {
                backingEngine.addUser(user.getId(), userPassword);
            }
        }
        catch (IdentityManagerException ex) {
            throw ex;
        }
        catch (UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER", e);
        }
    }

    @Override
    public void addOrganisation(String userId, String orgName) throws IdentityManagerException {
        LOG.info("addOrganisation userId=" + userId + ", orgName=" + orgName);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                ((IdentityManager)backingEngine).addOrganisation(userId, orgName);
            } else {
                backingEngine.addGroup(userId, orgName);
            }
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                try {
                    this.unsupportedIdentityProviderOperationsFallbackHandler.addOrganisation(userId, orgName);
                }
                catch (Exception e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION", e);
                }
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION", e);
        }
    }

    @Override
    public void addRight(String userId, String rightName) throws IdentityManagerException {
        LOG.info("addRight userId=" + userId + ", rightName=" + rightName);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (!(backingEngine instanceof IdentityManager)) {
                throw new UnsupportedOperationException("Add right to user is not supported by this identity provider.");
            }
            ((IdentityManager)backingEngine).addRight(userId, rightName);
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                try {
                    this.unsupportedIdentityProviderOperationsFallbackHandler.addRight(userId, rightName);
                }
                catch (Exception e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER", e);
                }
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER", e);
        }
    }

    @Override
    public void addRole(String userId, String roleName) throws IdentityManagerException {
        LOG.info("addRole userId=" + userId + ", roleName=" + roleName);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                ((IdentityManager)backingEngine).addRole(userId, roleName);
            } else {
                backingEngine.addRole(userId, roleName);
            }
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                try {
                    this.unsupportedIdentityProviderOperationsFallbackHandler.addRole(userId, roleName);
                }
                catch (Exception e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER", e);
                }
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER", e);
        }
    }

    @Override
    public void addOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        LOG.info("addOrganisationRole orgName=" + orgName + ", roleName=" + roleName);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                ((IdentityManager)backingEngine).addOrganisationRole(orgName, roleName);
            } else {
                backingEngine.addGroupRole(orgName, roleName);
            }
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_ORGANISATION_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_ORGANISATION", e);
        }
    }

    @Override
    public void deleteUser(String userId) throws IdentityManagerException {
        LOG.info("deleteUser userId=" + userId);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                ((IdentityManager)backingEngine).deleteUser(userId);
            } else {
                backingEngine.deleteUser(userId);
            }
        }
        catch (IdentityManagerException ex) {
            throw ex;
        }
        catch (UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER", e);
        }
    }

    @Override
    public void deleteOrganisation(String userId, String orgName) throws IdentityManagerException {
        LOG.info("deleteOrganisation userId=" + userId + ", orgName=" + orgName);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                ((IdentityManager)backingEngine).deleteOrganisation(userId, orgName);
            } else {
                backingEngine.deleteGroup(userId, orgName);
            }
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                try {
                    this.unsupportedIdentityProviderOperationsFallbackHandler.deleteOrganisation(userId, orgName);
                }
                catch (Exception e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION", e);
                }
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION", e);
        }
    }

    @Override
    public void deleteRole(String userId, String roleName) throws IdentityManagerException {
        LOG.info("deleteRole userId=" + userId + ", roleName=" + roleName);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                ((IdentityManager)backingEngine).deleteRole(userId, roleName);
            } else {
                backingEngine.deleteRole(userId, roleName);
            }
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                try {
                    this.unsupportedIdentityProviderOperationsFallbackHandler.deleteRole(userId, roleName);
                }
                catch (Exception e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER", e);
                }
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER", e);
        }
    }

    @Override
    public void deleteOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        LOG.info("deleteOrganisationRole orgName=" + orgName + ", roleName=" + roleName);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                ((IdentityManager)backingEngine).deleteOrganisationRole(orgName, roleName);
            } else {
                backingEngine.deleteGroupRole(orgName, roleName);
            }
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_ORGANISATION_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_ORGANISATION", e);
        }
    }

    @Override
    public void deleteRight(String userId, String rightName) throws IdentityManagerException {
        LOG.info("deleteRight userId=" + userId + ", rightName=" + rightName);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (!(backingEngine instanceof IdentityManager)) {
                throw new UnsupportedOperationException("Deleting a user right is not supported by this identity provider.");
            }
            ((IdentityManager)backingEngine).deleteRight(userId, rightName);
        }
        catch (IdentityManagerException | UnsupportedOperationException ex) {
            if (this.unsupportedIdentityProviderOperationsFallbackHandler != null && this.unsupportedIdentityProviderOperationsFallbackHandler.isUnsupportedOperationException(ex)) {
                try {
                    this.unsupportedIdentityProviderOperationsFallbackHandler.deleteRight(userId, rightName);
                }
                catch (Exception e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER", e);
                }
            }
            if (ex instanceof IdentityManagerException) {
                throw ex;
            }
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER", e);
        }
    }

    @Override
    public void updateUser(User user) throws IdentityManagerException {
        LOG.info("updateUser user=" + user);
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (!(backingEngine instanceof IdentityManager)) {
                throw new UnsupportedOperationException("Updating a user is not supported by this identity provider.");
            }
            ((IdentityManager)backingEngine).updateUser(user);
        }
        catch (IdentityManagerException ex) {
            throw ex;
        }
        catch (UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER", e);
        }
    }

    @Override
    public void updateUserPassword(String userId, String userPassword) throws IdentityManagerException {
        block7: {
            LOG.info("updateUserPassword userId=" + userId + ", userPassword=...");
            try {
                BackingEngine backingEngine = this.getBackingEngine();
                if (backingEngine == null) {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
                }
                if (backingEngine instanceof IdentityManager) {
                    ((IdentityManager)backingEngine).updateUserPassword(userId, userPassword);
                    break block7;
                }
                if (backingEngine instanceof PropertiesBackingEngine) {
                    this.updateUserPassword((PropertiesBackingEngine)backingEngine, userId, userPassword);
                    break block7;
                }
                throw new UnsupportedOperationException("Updating a user password is not supported by this identity provider.");
            }
            catch (IdentityManagerException ex) {
                throw ex;
            }
            catch (UnsupportedOperationException ex) {
                throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_UNSUPPORTED");
            }
            catch (Exception e) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD", e);
            }
        }
    }

    private void updateUserPassword(PropertiesBackingEngine propertiesBackingEngine, String userName, String password) {
        LOG.info("updateUserPassword propertiesBackingEngine=..., userName=" + userName + ", password=...");
        propertiesBackingEngine.addUser(userName, password);
    }

    @Override
    public boolean checkUserPassword(String userId, String userPassword) throws IdentityManagerException {
        LOG.info("checkUserPassword userId=" + userId + ", userPassword=...");
        try {
            BackingEngine backingEngine = this.getBackingEngine();
            if (backingEngine == null) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_BACKING_ENGINE_MISSING");
            }
            if (backingEngine instanceof IdentityManager) {
                return ((IdentityManager)backingEngine).checkUserPassword(userId, userPassword);
            }
            if (backingEngine instanceof PropertiesBackingEngine) {
                return this.checkUserPassword((PropertiesBackingEngine)backingEngine, userId, userPassword);
            }
            throw new UnsupportedOperationException("Checking the user password is not supported by this identity provider.");
        }
        catch (IdentityManagerException ex) {
            throw ex;
        }
        catch (UnsupportedOperationException ex) {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_CHECK_USER_PASSWORD_UNSUPPORTED");
        }
        catch (Exception e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_CHECK_USER_PASSWORD", e);
        }
    }

    private boolean checkUserPassword(PropertiesBackingEngine propertiesBackingEngine, String userName, String passwordToCheck) throws NoSuchFieldException, IllegalAccessException {
        LOG.info("checkUserPassword propertiesBackingEngine=..., userName=" + userName + ", password=...");
        Field privateEncryptionSupportField = PropertiesBackingEngine.class.getDeclaredField("encryptionSupport");
        privateEncryptionSupportField.setAccessible(true);
        EncryptionSupport encryptionSupport = (EncryptionSupport)privateEncryptionSupportField.get(propertiesBackingEngine);
        String encPasswordToCheck = encryptionSupport.encrypt(passwordToCheck);
        Field privatePropertiesField = PropertiesBackingEngine.class.getDeclaredField("users");
        privatePropertiesField.setAccessible(true);
        Object usersObject = privatePropertiesField.get(propertiesBackingEngine);
        String userInfos = (String)((Map)usersObject).get(userName);
        if (userInfos != null) {
            String[] infos = userInfos.split(",");
            String encCurrentPassword = infos[0];
            return encPasswordToCheck.equals(encCurrentPassword);
        }
        return false;
    }
}

