/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.jdbc;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.core.auth.UserFactory;
import de.virtimo.bpc.core.auth.jaas.BackingEngineDataConverter;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCQueriesConfiguration;
import de.virtimo.bpc.core.auth.jaas.jdbc.JDBCUtils;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.StringUtil;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.Encryption;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;

public class JDBCBackingEngine
implements BackingEngine,
IdentityManager {
    private static final Logger LOG = Logger.getLogger(JDBCBackingEngine.class.getName());
    private final DataSource dataSource;
    private final EncryptionSupport encryptionSupport;
    private final JDBCQueriesConfiguration queries;

    public JDBCBackingEngine(DataSource dataSource, EncryptionSupport encryptionSupport, JDBCQueriesConfiguration queries) {
        this.dataSource = dataSource;
        this.encryptionSupport = encryptionSupport;
        this.queries = queries;
    }

    @Override
    public void destroy() {
        LOG.log(Level.FINEST, "destroy");
    }

    private User _createUserFromRecord(Map<String, String> record) {
        return UserFactory.getUser(record.get("USERNAME"), record.get("USERNAME"), record.get("FIRSTNAME") + " " + record.get("LASTNAME"), record.get("FIRSTNAME"), record.get("LASTNAME"), record.get("EMAIL"));
    }

    @Override
    public User getUser(String userName) throws IdentityManagerException {
        Iterator<Map<String, String>> iterator;
        block9: {
            LOG.info("getUser userName=" + userName);
            Connection connection = this.dataSource.getConnection();
            try {
                ArrayList<User> users = new ArrayList<User>();
                iterator = JDBCUtils.rawRecordSelect(connection, this.queries.getQuery("query.user"), userName).iterator();
                while (iterator.hasNext()) {
                    Map<String, String> record = iterator.next();
                    users.add(this._createUserFromRecord(record));
                }
                Iterator<Map<String, String>> iterator2 = iterator = users.isEmpty() ? null : (User)users.get(0);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER", e);
                }
            }
            connection.close();
        }
        return iterator;
    }

    @Override
    public List<User> getUsers() throws IdentityManagerException {
        ArrayList<User> arrayList;
        block9: {
            LOG.info("getUsers");
            Connection connection = this.dataSource.getConnection();
            try {
                ArrayList<User> users = new ArrayList<User>();
                for (Map<String, String> record : JDBCUtils.rawRecordSelect(connection, this.queries.getQuery("query.users"), new String[0])) {
                    users.add(this._createUserFromRecord(record));
                }
                arrayList = users;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_GET_USERS", e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    @Override
    public Set<Organisation> getOrganisations() throws IdentityManagerException {
        LOG.info("getOrganisations");
        return BackingEngineDataConverter.getOrganisations(this);
    }

    @Override
    public Set<Role> getRoles() throws IdentityManagerException {
        LOG.info("getRoles");
        return BackingEngineDataConverter.asRoles(this.listRoles());
    }

    @Override
    public Set<Right> getRights() throws IdentityManagerException {
        LOG.info("getRights");
        throw new UnsupportedOperationException("Get rights is not supported by this identity provider.");
    }

    @Override
    public Set<Organisation> getUserOrganisations(String userId) throws IdentityManagerException {
        LOG.info("getUserOrganisations userId=" + userId);
        return BackingEngineDataConverter.getUserOrganisations(this, userId, false);
    }

    @Override
    public Set<Role> getUserRoles(String userId) throws IdentityManagerException {
        LOG.info("getUserRoles userId=" + userId);
        return BackingEngineDataConverter.getUserRoles(this, userId, false);
    }

    @Override
    public Set<Right> getUserRights(String userId) throws IdentityManagerException {
        LOG.info("getUserRights userId=" + userId);
        throw new UnsupportedOperationException("Get user rights is not supported by this identity provider.");
    }

    @Override
    public void addUser(String username, String password) {
        LOG.info("addUser username=" + username + ", password=...");
        try {
            this.addUser(username, password, "", "", "");
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error adding user", ex);
        }
    }

    @Override
    public void addUser(User user, String userPassword) throws IdentityManagerException {
        LOG.info("addUser user=" + user + ", userPassword=...");
        try {
            this.addUser(user.getId(), userPassword, user.getFirstName(), user.getLastName(), user.getEmail());
        }
        catch (SQLException ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_USER", ex);
        }
    }

    private void addUser(String username, String password, String firstName, String lastName, String email) throws SQLException {
        LOG.info("addUser username=" + username + ", password=..., firstName=" + firstName + ", lastName=" + lastName + ", email=" + email);
        String encPassword = this.encrypt(password);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("insert.user"), username, encPassword, firstName, lastName, email);
        }
    }

    @Override
    public void addOrganisation(String userId, String orgName) throws IdentityManagerException {
        LOG.info("addOrganisation userId=" + userId + ", orgName=" + orgName);
        this.addGroup(userId, orgName);
    }

    @Override
    public void addRight(String userId, String rightName) throws IdentityManagerException {
        LOG.info("addRight userId=" + userId + ", rightName=" + rightName);
        throw new UnsupportedOperationException("Adding right to users is not supported by this identity provider.");
    }

    public void updatePassword(String username, String password) {
        LOG.info("updatePassword username=" + username + ", password=...");
        String encPassword = this.encrypt(password);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("update.pwd"), encPassword, username);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error updating password", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkPassword(String username, String password) {
        LOG.info("checkPassword username=" + username + ", password=...");
        try (Connection connection = this.dataSource.getConnection();){
            List<String> passwords = JDBCUtils.rawSelect(connection, this.queries.getQuery("query.pwd"), username);
            if (passwords.isEmpty()) {
                boolean bl2 = false;
                return bl2;
            }
            String passwordFromDatabase = passwords.get(0);
            boolean bl = this.encryptionSupport.checkPassword(password, passwordFromDatabase);
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting user password", e);
        }
    }

    private String encrypt(String password) {
        Encryption encryption;
        String encryptedPassword = this.encryptionSupport.encrypt(password);
        if (!StringUtil.isNullOrEmpty(password) && password.equals(encryptedPassword) && (encryption = this.encryptionSupport.getEncryption()) != null) {
            encryptedPassword = encryption.encryptPassword(password);
        }
        return encryptedPassword;
    }

    @Override
    public void deleteUser(String username) {
        LOG.info("deleteUser username=" + username);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.roles"), username);
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.groups"), username);
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.user"), username);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting user", e);
        }
    }

    @Override
    public void deleteOrganisation(String userId, String orgName) throws IdentityManagerException {
        LOG.info("deleteOrganisation userId=" + userId + ", orgName=" + orgName);
        this.deleteGroup(userId, orgName);
    }

    public List<UserPrincipal> listUsers() {
        ArrayList<UserPrincipal> arrayList;
        block9: {
            LOG.info("listUsers");
            Connection connection = this.dataSource.getConnection();
            try {
                ArrayList<UserPrincipal> users = new ArrayList<UserPrincipal>();
                for (String name : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.users"), new String[0])) {
                    users.add(new UserPrincipal(name));
                }
                arrayList = users;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error listing users", e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserPrincipal lookupUser(String username) {
        LOG.info("lookupUser username=" + username);
        try (Connection connection = this.dataSource.getConnection();){
            List<Map<String, String>> select = JDBCUtils.rawRecordSelect(connection, this.queries.getQuery("query.user"), username);
            if (select.size() == 0) {
                UserPrincipal userPrincipal2 = null;
                return userPrincipal2;
            }
            UserPrincipal userPrincipal = new UserPrincipal(username);
            return userPrincipal;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting user", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RolePrincipal> listRoles(Principal principal) {
        LOG.info("listRoles principal=" + principal);
        try (Connection connection = this.dataSource.getConnection();){
            if (principal instanceof GroupPrincipal) {
                List<RolePrincipal> list2 = this.listRoles(connection, "_g_:" + principal.getName());
                return list2;
            }
            List<RolePrincipal> list = this.listRoles(connection, principal.getName());
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing roles", e);
        }
    }

    private List<RolePrincipal> listRoles(Connection connection, String name) throws SQLException {
        LOG.info("listRoles connection=..., name=" + name);
        ArrayList<RolePrincipal> roles = new ArrayList<RolePrincipal>();
        for (String role : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.roles_of_user_or_group"), name)) {
            if (role.startsWith("_g_:")) {
                roles.addAll(this.listRoles(connection, role));
                continue;
            }
            roles.add(new RolePrincipal(role));
        }
        return roles;
    }

    private List<RolePrincipal> listRoles() {
        LOG.info("listRoles");
        try {
            ArrayList<RolePrincipal> roles = new ArrayList<RolePrincipal>();
            try (Connection connection = this.dataSource.getConnection();){
                for (String name : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.roles"), new String[0])) {
                    roles.add(new RolePrincipal(name));
                }
            }
            return roles;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error listing roles", e);
        }
    }

    @Override
    public void addRole(String username, String role) {
        LOG.info("addRole username=" + username + ", role=" + role);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("insert.role"), username, role);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error adding role to user", e);
        }
    }

    @Override
    public void addOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        LOG.info("addOrganisationRole orgName=" + orgName + ", roleName=" + roleName);
        this.addGroupRole(orgName, roleName);
    }

    @Override
    public void deleteRole(String username, String role) {
        LOG.info("deleteRole username=" + username + ", role=" + role);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.role"), username, role);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error deleting role from user", e);
        }
    }

    @Override
    public void deleteOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        LOG.info("deleteOrganisationRole orgName=" + orgName + ", roleName=" + roleName);
        this.deleteGroupRole(orgName, roleName);
    }

    @Override
    public void deleteRight(String userId, String rightName) throws IdentityManagerException {
        LOG.info("deleteRight userId=" + userId + ", rightName=" + rightName);
        throw new UnsupportedOperationException("Delete user right is not supported by this identity provider.");
    }

    @Override
    public void updateUser(User user) throws IdentityManagerException {
        LOG.info("updateUser user=...");
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("update.user"), user.getFirstName(), user.getLastName(), user.getEmail(), user.getId());
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER", e);
        }
    }

    @Override
    public void updateUserPassword(String userId, String userPassword) throws IdentityManagerException {
        LOG.info("updateUserPassword userId=" + userId + ", userPassword=...");
        this.updatePassword(userId, userPassword);
    }

    @Override
    public boolean checkUserPassword(String userId, String userPassword) throws IdentityManagerException {
        LOG.info("checkUserPassword userId=" + userId + ", userPassword=...");
        return this.checkPassword(userId, userPassword);
    }

    public List<GroupPrincipal> listGroups(UserPrincipal principal) {
        ArrayList<GroupPrincipal> arrayList;
        block9: {
            LOG.info("listGroups principal=" + principal);
            Connection connection = this.dataSource.getConnection();
            try {
                ArrayList<GroupPrincipal> groups = new ArrayList<GroupPrincipal>();
                for (String group : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.groups_of_user"), principal.getName())) {
                    groups.add(new GroupPrincipal(group));
                }
                arrayList = groups;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error listing groups", e);
                }
            }
            connection.close();
        }
        return arrayList;
    }

    public void addGroup(String username, String groupName) {
        LOG.info("addGroup username=" + username + ", groupName=" + groupName);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("insert.group"), username, groupName);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            LOG.log(Level.SEVERE, "Error adding user to group", e);
        }
    }

    public void deleteGroup(String username, String group) {
        LOG.info("deleteGroup username=" + username + ", group=" + group);
        try (Connection connection = this.dataSource.getConnection();){
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.role"), username, "_g_:" + group);
            JDBCUtils.rawUpdate(connection, this.queries.getQuery("delete.group"), username, group);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            LOG.log(Level.SEVERE, "Error deleting user from group", e);
        }
    }

    public void addGroupRole(String group, String role) {
        LOG.info("addGroupRole group=" + group + ", role=" + role);
        this.addRole("_g_:" + group, role);
    }

    public void deleteGroupRole(String group, String role) {
        LOG.info("deleteGroupRole group=" + group + ", role=" + role);
        this.deleteRole("_g_:" + group, role);
    }

    public Map<GroupPrincipal, String> listGroups() {
        HashMap<GroupPrincipal, String> hashMap;
        block9: {
            LOG.info("listGroups");
            Connection connection = this.dataSource.getConnection();
            try {
                HashMap<GroupPrincipal, String> result = new HashMap<GroupPrincipal, String>();
                for (String group : JDBCUtils.rawSelect(connection, this.queries.getQuery("query.groups"), new String[0])) {
                    result.put(new GroupPrincipal(group), StringUtil.implode(",", JDBCUtils.rawSelect(connection, this.queries.getQuery("query.roles_of_user_or_group"), "_g_:" + group)));
                }
                hashMap = result;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Error listing groups", e);
                }
            }
            connection.close();
        }
        return hashMap;
    }

    public void createGroup(String group) {
        LOG.info("createGroup group=" + group);
        throw new UnsupportedOperationException("Create group is not supported by this identity provider.");
    }
}

