/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas.jdbc;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.AbstractBundleBasedConfiguration;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class JDBCQueriesConfiguration
extends AbstractBundleBasedConfiguration {
    private static final Logger LOG = Logger.getLogger(JDBCQueriesConfiguration.class.getName());
    private final Configuration configuration;
    private final Properties defaultProperties;

    public JDBCQueriesConfiguration(BundleContext bundleContext) throws ServiceNotFoundException, IOException {
        try (BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class);){
            this.configuration = configurationAdminTracker.getService().getConfiguration("de.virtimo.bpc.core.auth.jaas.jdbc.queries", null);
            this.defaultProperties = this.loadResourceProperties("jaas_jdbc_queries.properties");
            JDBCQueriesConfiguration.keepKarafPropertiesFileUpToDate(this.configuration, this.defaultProperties);
        }
    }

    private static void keepKarafPropertiesFileUpToDate(Configuration configuration, Properties bundleProperties) throws IOException {
        LOG.info("keepKarafPropertiesFileUpToDate configuration=..., propertiesFromBundle=...");
        Hashtable<String, String> storedProps = configuration.getProperties();
        if (storedProps == null) {
            storedProps = new Hashtable<String, String>();
        }
        boolean configurationMustBeUpdated = false;
        for (String key : bundleProperties.stringPropertyNames()) {
            String value = bundleProperties.getProperty(key);
            if (((Dictionary)storedProps).get(key) != null) continue;
            configurationMustBeUpdated = true;
            ((Dictionary)storedProps).put(key, value);
        }
        if (configurationMustBeUpdated) {
            configuration.update(storedProps);
        }
        LOG.info("JDBCQueriesConfiguration properties: " + storedProps);
    }

    @Override
    protected Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    public String getQuery(String queryName) throws IllegalArgumentException {
        String query;
        LOG.log(Level.FINEST, "getQuery");
        if (queryName != null && (query = this.getSystemPropertyValueAsString(queryName, null)) != null && !"".equals(query.trim())) {
            return query;
        }
        throw new IllegalArgumentException("The JDBC identity provider query '" + queryName + "' is missing.");
    }
}

