/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.api.identityManagement.IdentityManager;
import de.virtimo.bpc.api.identityManagement.IdentityManagerException;
import de.virtimo.bpc.api.identityManagement.IdentityManagerUnsupportedOperationException;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.UserFactory;
import de.virtimo.bpc.core.auth.UserNotFoundException;
import de.virtimo.bpc.core.auth.oidc.KeycloakAdminClient;
import de.virtimo.bpc.core.auth.oidc.KeycloakAdminClientBuilder;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.utils.RestWebServiceClientFactory;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONObject;
import org.osgi.framework.BundleContext;

public class KeycloakIdentityProvider
extends OidcIdentityProvider
implements IdentityManager {
    private static final Logger LOG = Logger.getLogger(KeycloakIdentityProvider.class.getName());
    public static final String CONFIG_KEY = "keycloak";
    private final String realm;
    private final String clientId;
    private final String clientSecret;
    private final KeycloakAdminClient keycloakAdminClient;

    public static void checkKeycloakConfiguration(Map<String, Object> configuration) {
        KeycloakIdentityProvider.checkOidcConfiguration(configuration);
        Map keycloakConfiguration = (Map)configuration.get(CONFIG_KEY);
        if (keycloakConfiguration == null) {
            throw new IllegalArgumentException("Missing configuration 'keycloak'");
        }
        if (!keycloakConfiguration.containsKey("realm")) {
            throw new IllegalArgumentException("Missing configuration 'keycloak.realm'");
        }
        if (!keycloakConfiguration.containsKey("client_id")) {
            throw new IllegalArgumentException("Missing configuration 'keycloak.client_id'");
        }
        if (!keycloakConfiguration.containsKey("adminclient_server_url")) {
            throw new IllegalArgumentException("Missing configuration 'keycloak.adminclient_server_url'");
        }
        if (!keycloakConfiguration.containsKey("adminclient_realm")) {
            throw new IllegalArgumentException("Missing configuration 'keycloak.adminclient_realm'");
        }
        if (!keycloakConfiguration.containsKey("adminclient_client_id")) {
            throw new IllegalArgumentException("Missing configuration 'keycloak.adminclient_client_id'");
        }
        if (!keycloakConfiguration.containsKey("adminclient_username")) {
            throw new IllegalArgumentException("Missing configuration 'keycloak.adminclient_username'");
        }
        if (!keycloakConfiguration.containsKey("adminclient_password")) {
            throw new IllegalArgumentException("Missing configuration 'keycloak.adminclient_password'");
        }
    }

    public KeycloakIdentityProvider(BundleContext bundleContext, String oidcDiscoveryUrl, Map<String, Object> configuration, int sessionExpirationMinutes) throws URISyntaxException, IdentityProviderException, IllegalArgumentException {
        super(bundleContext, oidcDiscoveryUrl, configuration, sessionExpirationMinutes);
        KeycloakIdentityProvider.checkKeycloakConfiguration(configuration);
        Map keycloakConfiguration = (Map)configuration.get(CONFIG_KEY);
        this.realm = keycloakConfiguration.get("realm").toString();
        this.clientId = keycloakConfiguration.get("client_id").toString();
        this.clientSecret = keycloakConfiguration.get("client_secret") != null ? keycloakConfiguration.get("client_secret").toString() : null;
        String adminClientServerUrl = keycloakConfiguration.get("adminclient_server_url").toString();
        String adminClientRealm = keycloakConfiguration.get("adminclient_realm").toString();
        String adminClientClientId = keycloakConfiguration.get("adminclient_client_id").toString();
        String adminClientUsername = keycloakConfiguration.get("adminclient_username").toString();
        String adminClientPassword = keycloakConfiguration.get("adminclient_password").toString();
        this.keycloakAdminClient = KeycloakAdminClientBuilder.builder().serverUrl(adminClientServerUrl).realm(adminClientRealm).clientId(adminClientClientId).username(adminClientUsername).password(adminClientPassword).build();
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
        super.destroy();
        if (this.keycloakAdminClient != null) {
            this.keycloakAdminClient.close();
        }
    }

    @Override
    public void logout(String sessionId) throws IdentityProviderException {
        LOG.info("logout sessionId=" + sessionId);
        try {
            Map<String, Object> error = this.keycloakAdminClient.removeUserSession(this.realm, sessionId);
            if (error != null) {
                LOG.warning("Error from Keycloak logout call: " + error);
            }
        }
        catch (Exception ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_SESSION", ex);
        }
    }

    @Override
    protected Date getSessionExpirationDate() {
        LOG.info("getSessionExpirationDate");
        long sessionTimeoutInSeconds = 0L;
        try {
            Map<String, Object> realmSettings = this.keycloakAdminClient.getRealm(this.realm);
            if (sessionTimeoutInSeconds <= 0L && (sessionTimeoutInSeconds = MapUtil.getValueAsLong(realmSettings, "clientSessionMaxLifespan", 0L)) > 0L) {
                LOG.info("Using the Keycloak 'Client Session Max' session expiration value: " + sessionTimeoutInSeconds + " seconds");
            }
            if (sessionTimeoutInSeconds <= 0L && (sessionTimeoutInSeconds = MapUtil.getValueAsLong(realmSettings, "ssoSessionMaxLifespan", 0L)) > 0L) {
                LOG.info("Using the Keycloak 'SSO Session Max' session expiration value: " + sessionTimeoutInSeconds + " seconds");
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the session timeout settings of the realm '" + this.realm + "'.", ex);
        }
        if (sessionTimeoutInSeconds <= 0L) {
            return this.getSessionExpirationDateFromIdpBackendConnectionSetting();
        }
        return Timestamp.valueOf(LocalDateTime.now().plusSeconds(sessionTimeoutInSeconds));
    }

    @Override
    public User getUser(String userId) throws IdentityManagerException {
        LOG.info("getUser");
        User result = null;
        try {
            Map<String, Object> user = this.keycloakAdminClient.getUserByUserName(this.realm, userId);
            if (user != null) {
                result = this.getUser(user);
            }
        }
        catch (IdentityManagerException ex) {
            LOG.log(Level.SEVERE, "Failed to get the user with the ID '" + userId + "' from the realm '" + this.realm + "'.", ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the user with the ID '" + userId + "' from the realm '" + this.realm + "'.", ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER", ex);
        }
        return result;
    }

    @Override
    public List<User> getUsers() throws IdentityManagerException {
        LOG.info("getUsers");
        ArrayList<User> result = new ArrayList<User>();
        try {
            List<Map<String, Object>> users = this.keycloakAdminClient.getUsers(this.realm);
            if (users != null) {
                for (Map<String, Object> user : users) {
                    result.add(this.getUser(user));
                }
            }
        }
        catch (IdentityManagerException ex) {
            LOG.log(Level.SEVERE, "Failed to get the users from the realm '" + this.realm + "'.", ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the users from the realm '" + this.realm + "'.", ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_USERS", ex);
        }
        return result;
    }

    private void addKeycloakGroupsAsOrganisations(Set<Organisation> result, List<Map<String, Object>> groups, Map<String, Object> parentGroup) {
        if (groups != null) {
            for (Map<String, Object> group : groups) {
                result.add(this.getOrganisation(group, parentGroup));
                List subGroups = (List)group.get("subGroups");
                if (subGroups == null) continue;
                this.addKeycloakGroupsAsOrganisations(result, subGroups, group);
            }
        }
    }

    @Override
    public Set<Organisation> getOrganisations() throws IdentityManagerException {
        LOG.info("getOrganisations");
        HashSet<Organisation> result = new HashSet<Organisation>();
        try {
            List<Map<String, Object>> groups = this.keycloakAdminClient.getGroups(this.realm);
            this.addKeycloakGroupsAsOrganisations(result, groups, null);
        }
        catch (IdentityManagerException ex) {
            LOG.log(Level.SEVERE, "Failed to get the organisations from the realm '" + this.realm + "'.", ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the organisations from the realm '" + this.realm + "'.", ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_ORGANISATIONS", ex);
        }
        return result;
    }

    @Override
    public Set<Role> getRoles() throws IdentityManagerException {
        LOG.info("getRoles");
        try {
            KeycloakRolesCollector rolesCollector = new KeycloakRolesCollector();
            List<Map<String, Object>> realmRoles = this.keycloakAdminClient.getRoles(this.realm);
            rolesCollector.addFromKeycloakResponse(realmRoles);
            Map<String, Object> client = this.keycloakAdminClient.getClient(this.realm, this.clientId);
            if (client != null) {
                List<Map<String, Object>> clientRoles = this.keycloakAdminClient.getRoles(this.realm, (String)client.get("id"));
                rolesCollector.addFromKeycloakResponse(clientRoles);
            }
            return rolesCollector.asSet();
        }
        catch (IdentityManagerException ex) {
            LOG.log(Level.SEVERE, "Failed to get the roles from the realm '" + this.realm + "' or client '" + this.clientId + "'.", ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the roles from the realm '" + this.realm + "' or client '" + this.clientId + "'.", ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_ROLES", ex);
        }
    }

    @Override
    public Set<Right> getRights() throws IdentityManagerException {
        LOG.info("getRights");
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            return this.unsupportedIdentityProviderOperationsFallbackHandler.getRights();
        }
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_RIGHTS_UNSUPPORTED");
    }

    @Override
    public Set<Organisation> getUserOrganisations(String userId) throws IdentityManagerException {
        LOG.info("getUserOrganisations userId=" + userId);
        HashSet<Organisation> result = new HashSet<Organisation>();
        try {
            Map<String, Object> user = this.keycloakAdminClient.getUserByUserName(this.realm, userId);
            if (user == null) {
                throw new UserNotFoundException(userId);
            }
            String keycloakUserId = (String)user.get("id");
            List<Map<String, Object>> userGroups = this.keycloakAdminClient.getUserGroups(this.realm, keycloakUserId);
            this.addKeycloakGroupsAsOrganisations(result, userGroups, null);
        }
        catch (IdentityManagerException ex) {
            LOG.log(Level.SEVERE, "Failed to get the user groups from the realm '" + this.realm + "' and/or user '" + userId + "'.", ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the user groups from the realm '" + this.realm + "' and/or user '" + userId + "'.", ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ORGANISATIONS", MapUtil.mapOf("user", userId), (Throwable)ex);
        }
        return result;
    }

    private Set<Role> getUserRoles(String userName, String keycloakUserId) throws IdentityManagerException {
        LOG.info("getUserRoles userName=" + userName + ", keycloakUserId=" + keycloakUserId);
        try {
            KeycloakRolesCollector rolesCollector = new KeycloakRolesCollector();
            List<Map<String, Object>> userRealmRoles = this.keycloakAdminClient.getUserRealmRoles(this.realm, keycloakUserId);
            rolesCollector.addFromKeycloakResponse(userRealmRoles);
            Map<String, Object> client = this.keycloakAdminClient.getClient(this.realm, this.clientId);
            if (client != null) {
                List<Map<String, Object>> userClientRoles = this.keycloakAdminClient.getUserClientRoles(this.realm, keycloakUserId, (String)client.get("id"));
                rolesCollector.addFromKeycloakResponse(userClientRoles);
            }
            return rolesCollector.asSet();
        }
        catch (Exception ex) {
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ROLES", MapUtil.mapOf("user", userName), (Throwable)ex);
        }
    }

    @Override
    public Set<Role> getUserRoles(String userId) throws IdentityManagerException {
        LOG.info("getUserRoles userId=" + userId);
        try {
            Map<String, Object> user = this.keycloakAdminClient.getUserByUserName(this.realm, userId);
            if (user != null) {
                String keycloakUserId = (String)user.get("id");
                return this.getUserRoles(userId, keycloakUserId);
            }
            throw new UserNotFoundException(userId);
        }
        catch (IdentityManagerException ex) {
            LOG.log(Level.SEVERE, "Failed to get the user roles from the realm '" + this.realm + "' and/or user '" + userId + "'.", ex);
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the user roles from the realm '" + this.realm + "' and/or user '" + userId + "'.", ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_GET_USER_ROLES", MapUtil.mapOf("user", userId), (Throwable)ex);
        }
    }

    @Override
    public Set<Right> getUserRights(String userId) throws IdentityManagerException {
        LOG.info("getUserRights userId=" + userId);
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            return this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRights(userId);
        }
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_GET_RIGHTS_UNSUPPORTED");
    }

    private User getUser(Map<String, Object> user) {
        return UserFactory.getUser((String)user.get("username"), (String)user.get("username"), (String)user.get("username"), (String)user.get("firstName"), (String)user.get("lastName"), (String)user.get("email"));
    }

    private Organisation getOrganisation(Map<String, Object> group, Map<String, Object> parentGroup) {
        return OrganisationFactory.getOrganisation((String)group.get("name"));
    }

    @Override
    public void addUser(String userId, String userPassword) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_UNSUPPORTED");
    }

    @Override
    public void addUser(User user, String userPassword) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_UNSUPPORTED");
    }

    @Override
    public void addOrganisation(String userId, String orgName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_USER_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void addRight(String userId, String rightName) throws IdentityManagerException {
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            try {
                this.unsupportedIdentityProviderOperationsFallbackHandler.addRight(userId, rightName);
            }
            catch (Exception e) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER", e);
            }
        } else {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_RIGHT_TO_USER_UNSUPPORTED");
        }
    }

    @Override
    public void addRole(String userId, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_USER_UNSUPPORTED");
    }

    @Override
    public void addOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_ADD_ROLE_TO_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteUser(String userId) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_UNSUPPORTED");
    }

    @Override
    public void deleteOrganisation(String userId, String orgName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_USER_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteRole(String userId, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_USER_UNSUPPORTED");
    }

    @Override
    public void deleteOrganisationRole(String orgName, String roleName) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_ROLE_FROM_ORGANISATION_UNSUPPORTED");
    }

    @Override
    public void deleteRight(String userId, String rightName) throws IdentityManagerException {
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            try {
                this.unsupportedIdentityProviderOperationsFallbackHandler.deleteRight(userId, rightName);
            }
            catch (Exception e) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IM_EXCEPTION, "CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER", e);
            }
        } else {
            throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_DELETE_RIGHT_FROM_USER_UNSUPPORTED");
        }
    }

    @Override
    public void updateUser(User user) throws IdentityManagerException {
        throw new IdentityManagerUnsupportedOperationException("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_UNSUPPORTED");
    }

    @Override
    public boolean canUpdateUserPasswords() throws IdentityProviderException {
        return true;
    }

    @Override
    public void updateUserPassword(String userName, String oldPassword, String newPassword) throws IdentityProviderException {
        block6: {
            LOG.info("updateUserPassword userName=" + userName + ", oldPassword=..., newPassword=...");
            try {
                Map<String, Object> user = this.keycloakAdminClient.getUserByUserName(this.realm, userName);
                if (user != null) {
                    String keycloakUserId = (String)user.get("id");
                    Map<String, Object> checkUserPasswordResp = this.keycloakAdminClient.checkUserPassword(this.realm, this.clientId, this.clientSecret, userName, oldPassword);
                    if (checkUserPasswordResp == null) {
                        Map<String, Object> updateUserPasswordResp = this.keycloakAdminClient.updateUserPassword(this.realm, keycloakUserId, newPassword);
                        if (updateUserPasswordResp != null) {
                            KeycloakErrorResponseProcessor keycloakErrorResponseProcessor = new KeycloakErrorResponseProcessor("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD", MapUtil.mapOf("user", userName), updateUserPasswordResp);
                            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, keycloakErrorResponseProcessor.getMessage(), keycloakErrorResponseProcessor.getProps());
                        }
                        break block6;
                    }
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD_DOES_NOT_MATCH", MapUtil.mapOf("user", userName));
                }
                throw new UserNotFoundException(userName);
            }
            catch (IdentityProviderException ex) {
                LOG.log(Level.SEVERE, "Failed to change the password of the user '" + userName + "' in the realm '" + this.realm + ".", ex);
                throw ex;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to change the password of the user '" + userName + "' in the realm '" + this.realm + ".", ex);
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD", MapUtil.mapOf("user", userName), (Throwable)ex);
            }
        }
    }

    @Override
    public void updateUserPassword(String userName, String userPassword) throws IdentityManagerException {
        block5: {
            LOG.info("updateUserPassword userName=" + userName + ", userPassword=...");
            try {
                Map<String, Object> user = this.keycloakAdminClient.getUserByUserName(this.realm, userName);
                if (user != null) {
                    String keycloakUserId = (String)user.get("id");
                    Map<String, Object> updateUserPasswordResp = this.keycloakAdminClient.updateUserPassword(this.realm, keycloakUserId, userPassword);
                    if (updateUserPasswordResp != null) {
                        KeycloakErrorResponseProcessor keycloakErrorResponseProcessor = new KeycloakErrorResponseProcessor("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD", MapUtil.mapOf("user", userName), updateUserPasswordResp);
                        throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, keycloakErrorResponseProcessor.getMessage(), keycloakErrorResponseProcessor.getProps());
                    }
                    break block5;
                }
                throw new UserNotFoundException(userName);
            }
            catch (IdentityManagerException ex) {
                LOG.log(Level.SEVERE, "Failed to change the password of user '" + userName + "'.", ex);
                throw ex;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to change the password of user '" + userName + "'.", ex);
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_PASSWORD", MapUtil.mapOf("user", userName), (Throwable)ex);
            }
        }
    }

    @Override
    public boolean checkUserPassword(String userName, String userPassword) throws IdentityManagerException {
        LOG.info("checkUserPassword userName=" + userName + ", userPassword=...");
        try {
            return this.keycloakAdminClient.checkUserPassword(this.realm, this.clientId, this.clientSecret, userName, userPassword) == null;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to check the password of the user '" + userName + "' in the realm '" + this.realm + ".", ex);
            throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_CHECK_USER_PASSWORD", MapUtil.mapOf("user", userName), (Throwable)ex);
        }
    }

    public UserSession impersonateUser(HttpServletRequest req, String currentUserAccessToken, String userName) throws IdentityManagerException {
        LOG.info("impersonateUser req=..., currentUserAccessToken=..., userName=" + userName);
        try (Client client = null;){
            Map<String, Object> user = this.keycloakAdminClient.getUserByUserName(this.realm, userName);
            if (user == null) {
                throw new UserNotFoundException(userName);
            }
            String keycloakUserId = (String)user.get("id");
            Set<Role> userRoles = this.getUserRoles(userName, keycloakUserId);
            if (userRoles.contains(RolesFactory.getBpcAdminRole())) {
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_IMPERSONATE_NOT_ALLOWED, "CORE_ERROR_IDENTITY_PROVIDER_IMPERSONATE_USER_NOT_ALLOWED", MapUtil.mapOf("user", userName));
            }
            OIDCProviderMetadata oidcProviderMetadata = this.providerMetadata.getOIDCProviderMetadataForRequestUrl(req.getRequestURL().toString());
            client = RestWebServiceClientFactory.newClient(false);
            WebTarget target = client.target(oidcProviderMetadata.getTokenEndpointURI());
            Form form = new Form().param("client_id", this.clientId).param("client_secret", this.clientSecret).param("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").param("subject_token", currentUserAccessToken).param("scope", "openid").param("requested_subject", keycloakUserId);
            Future response = target.request(new String[]{"application/x-www-form-urlencoded"}).accept(new String[]{"application/json"}).buildPost(Entity.form((Form)form)).submit(Response.class);
            Response r = (Response)response.get(30L, TimeUnit.SECONDS);
            String respAsString = (String)r.readEntity(String.class);
            Map<String, Object> respMap = JsonUtil.getInstance().jsonStringAsMap(respAsString);
            if (Response.Status.Family.familyOf((int)r.getStatus()).equals((Object)Response.Status.Family.SUCCESSFUL)) {
                OIDCTokenResponse oidcTokenResponse = (OIDCTokenResponse)OIDCTokenResponseParser.parse((JSONObject)new JSONObject(respMap));
                UserSession userSession = this.createUserSession(oidcTokenResponse, oidcProviderMetadata);
                return userSession;
            }
            try {
                if (respMap.containsKey("error_description")) {
                    throw new Exception((String)respMap.get("error_description"));
                }
                throw new Exception((String)respMap.get("error"));
            }
            catch (IdentityManagerException ex) {
                LOG.log(Level.SEVERE, "Failed to impersonate user '" + userName + "'.", ex);
                throw ex;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to impersonate user '" + userName + "'.", ex);
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_IMPERSONATE_USER", MapUtil.mapOf("user", userName, "error", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public void updateUserLanguage(String userName, String language) throws IdentityManagerException {
        block5: {
            LOG.info("updateUserLanguage userName=" + userName + ", language=" + language);
            try {
                Map<String, Object> user = this.keycloakAdminClient.getUserByUserName(this.realm, userName);
                if (user != null) {
                    String idOfUser = (String)user.get("id");
                    Map<String, Object> updateUserLanguageResp = this.keycloakAdminClient.updateUserLanguage(this.realm, idOfUser, language);
                    if (updateUserLanguageResp != null) {
                        KeycloakErrorResponseProcessor keycloakErrorResponseProcessor = new KeycloakErrorResponseProcessor("CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_LANGUAGE", MapUtil.mapOf("user", userName, "language", language), updateUserLanguageResp);
                        throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, keycloakErrorResponseProcessor.getMessage(), keycloakErrorResponseProcessor.getProps());
                    }
                    break block5;
                }
                throw new UserNotFoundException(userName);
            }
            catch (IdentityManagerException ex) {
                throw ex;
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to update the language of user '" + userName + "'.", ex);
                throw new IdentityManagerException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_UPDATE_USER_LANGUAGE", MapUtil.mapOf("user", userName, "language", language, "error", ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private static class KeycloakRolesCollector {
        private final Set<Role> roles = new HashSet<Role>();

        private KeycloakRolesCollector() {
        }

        public void addFromKeycloakResponse(List<Map<String, Object>> keycloakRoles) {
            if (keycloakRoles != null) {
                for (Map<String, Object> keycloakRole : keycloakRoles) {
                    this.roles.add(this.createRole(keycloakRole));
                }
            }
        }

        private Role createRole(Map<String, Object> keycloakRole) {
            return RolesFactory.getRole((String)keycloakRole.get("name"));
        }

        public Set<Role> asSet() {
            return this.roles;
        }
    }

    private static class KeycloakErrorResponseProcessor {
        private String message;
        private Map<String, Object> props;

        public KeycloakErrorResponseProcessor(String defaultMessage, Map<String, Object> defaultMessageProps, Map<String, Object> keycloakErrorResp) {
            LOG.info("KeycloakErrorResponseProcessor defaultMessage=" + defaultMessage + ", defaultMessageProps=" + defaultMessageProps + ", keycloakErrorResp=" + keycloakErrorResp);
            this.message = defaultMessage;
            this.props = defaultMessageProps;
            if (keycloakErrorResp != null) {
                if (keycloakErrorResp.containsKey("error_description")) {
                    this.props.put("error", keycloakErrorResp.get("error_description"));
                } else if (keycloakErrorResp.containsKey("error")) {
                    this.props.put("error", keycloakErrorResp.get("error"));
                } else {
                    LOG.severe("Please inform the BPC developers that the Keycloak error response has been changed. Received error response: " + keycloakErrorResp);
                    this.props.put("error", "Keycloak error can be found in the BPC logs.");
                }
            } else {
                this.props.put("error", null);
            }
            if (keycloakErrorResp != null && keycloakErrorResp.containsKey("error")) {
                String errorKey = (String)keycloakErrorResp.get("error");
                Map<String, Object> knownErrorKeys = MapUtil.mapOf("invalidPasswordMinLengthMessage", 1, "invalidPasswordMinLowerCaseCharsMessage", 1, "invalidPasswordMinDigitsMessage", 1, "invalidPasswordMinUpperCaseCharsMessage", 1, "invalidPasswordMinSpecialCharsMessage", 1, "invalidPasswordNotUsernameMessage", 0, "invalidPasswordNotEmailMessage", 0, "invalidPasswordRegexPatternMessage", 0, "invalidPasswordHistoryMessage", 1, "invalidPasswordBlacklistedMessage", 0, "invalidPasswordGenericMessage", 0);
                if (knownErrorKeys.containsKey(errorKey)) {
                    String errorDescription;
                    String strippedNonDigits;
                    this.message = defaultMessage + ".KEYCLOAK." + errorKey;
                    int numberOfUsedDynamicParams = MapUtil.getValueAsInt(knownErrorKeys, errorKey, -1);
                    if (numberOfUsedDynamicParams == 1 && keycloakErrorResp.containsKey("error_description") && !StringUtil.isNullOrEmpty(strippedNonDigits = (errorDescription = (String)keycloakErrorResp.get("error_description")).replaceAll("\\D+", ""))) {
                        this.props.put("value", strippedNonDigits);
                    }
                }
            }
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, Object> getProps() {
            return this.props;
        }
    }
}

