/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import com.nimbusds.jose.shaded.json.JSONObject;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.LogoutRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.InactiveOrganisation;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.UserFlowIdentityProvider;
import de.virtimo.bpc.api.auth.idp.UserSessionRequest;
import de.virtimo.bpc.api.auth.jaas.BpcCallbackHandler;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.UnsupportedIdentityProviderOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.UserSessionImpl;
import de.virtimo.bpc.core.auth.idp.HttpUserSessionRequest;
import de.virtimo.bpc.core.auth.idp.IdentityProviderWithUnsupportedOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.oidc.ClaimNameSplitter;
import de.virtimo.bpc.core.auth.oidc.OidcProviderMetadata;
import de.virtimo.bpc.core.auth.oidc.OidcProviderMetadataMode;
import de.virtimo.bpc.core.auth.oidc.OidcUri;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.UUIDGenerator;
import de.virtimo.bpc.util.UriQueryUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import net.minidev.json.JSONArray;
import org.apache.http.client.utils.URIBuilder;
import org.osgi.framework.BundleContext;

public class OidcIdentityProvider
implements UserFlowIdentityProvider,
IdentityProviderWithUnsupportedOperationsFallbackHandler {
    private static final Logger LOG = Logger.getLogger(OidcIdentityProvider.class.getName());
    public static final String CONFIG_KEY = "oidc";
    public static final String USER_INFO_JWT_KEY = "oidcUserInfoJWT";
    public static final String USER_ID_JWT_KEY = "oidcUserIdJWT";
    public static final String OIDC_ACCESS_TOKEN = "oidc.accessToken";
    public static final String OIDC_TOKENS_REQUESTED_TIMESTAMP = "oidc.tokensRequestedTimestamp";
    public static final String OIDC_ID_TOKEN = "oidc.idToken";
    public static final String OIDC_ACCESS_TOKEN_EXPIRES_IN_SEC = "oidc.accessTokenExpiresInSec";
    public static final String OIDC_REFRESH_TOKEN = "oidc.refreshToken";
    public static final String OIDC_REFRESH_TOKEN_EXPIRES_IN_SEC = "oidc.refreshTokenExpiresInSec";
    private static State authState = new State();
    protected BundleContext bundleContext;
    private final OidcUri postAuthenticationRedirectUri;
    private final OidcUri postLogoutRedirectUri;
    protected final OidcProviderMetadata providerMetadata;
    private final ClientID clientID;
    private final Secret clientSecret;
    private final String scope;
    private final String claimNameRoles;
    private final String claimNameOrganisations;
    private final String claimNameRights;
    private final int sessionExpirationMinutes;
    protected UnsupportedIdentityProviderOperationsFallbackHandler unsupportedIdentityProviderOperationsFallbackHandler;

    public static void checkOidcConfiguration(Map<String, Object> configuration) throws IllegalArgumentException {
        if (!configuration.containsKey("post_authentication_redirect_uri")) {
            throw new IllegalArgumentException("Missing configuration 'post_authentication_redirect_uri'");
        }
        if (!configuration.containsKey("post_logout_redirect_uri")) {
            throw new IllegalArgumentException("Missing configuration 'post_logout_redirect_uri'");
        }
        if (!configuration.containsKey("client_id")) {
            throw new IllegalArgumentException("Missing configuration 'client_id'");
        }
        if (!configuration.containsKey("client_secret")) {
            throw new IllegalArgumentException("Missing configuration 'client_secret'");
        }
        if (!configuration.containsKey("scope")) {
            throw new IllegalArgumentException("Missing configuration 'scope'");
        }
        if (!configuration.containsKey("claim_name_roles")) {
            throw new IllegalArgumentException("Missing configuration 'claim_name_roles'");
        }
    }

    public OidcIdentityProvider(BundleContext bundleContext, String oidcDiscoveryUrl, Map<String, Object> configuration, int sessionExpirationMinutes) throws URISyntaxException, IdentityProviderException, IllegalArgumentException {
        LOG.info("OidcIdentityProvider bundleContext=..., oidcDiscoveryUrl=" + oidcDiscoveryUrl + ", configuration=" + configuration + ", sessionExpirationMinutes=" + sessionExpirationMinutes);
        this.bundleContext = bundleContext;
        OidcIdentityProvider.checkOidcConfiguration(configuration);
        this.sessionExpirationMinutes = sessionExpirationMinutes;
        this.postAuthenticationRedirectUri = new OidcUri(configuration.get("post_authentication_redirect_uri"));
        this.postLogoutRedirectUri = new OidcUri(configuration.get("post_logout_redirect_uri"));
        this.providerMetadata = configuration.get("metadata_discovery_uri") != null ? new OidcProviderMetadata(null, configuration.get("metadata_discovery_uri"), OidcProviderMetadataMode.MetadataDiscoveryUriConfig) : new OidcProviderMetadata(oidcDiscoveryUrl, null, OidcProviderMetadataMode.SingleDiscoveryUri);
        this.clientID = new ClientID(configuration.get("client_id").toString().trim());
        this.clientSecret = new Secret(configuration.get("client_secret").toString().trim());
        this.scope = configuration.get("scope").toString().trim();
        this.claimNameRoles = configuration.get("claim_name_roles").toString().trim();
        this.claimNameOrganisations = configuration.get("claim_name_organisations") != null ? configuration.get("claim_name_organisations").toString().trim() : null;
        this.claimNameRights = configuration.get("claim_name_rights") != null ? configuration.get("claim_name_rights").toString().trim() : null;
    }

    @Override
    public void destroy() {
        LOG.info("destroy");
    }

    @Override
    public void setUnsupportedIdentityProviderOperationsFallbackHandler(UnsupportedIdentityProviderOperationsFallbackHandler unsupportedIdentityProviderOperationsFallbackHandler) {
        this.unsupportedIdentityProviderOperationsFallbackHandler = unsupportedIdentityProviderOperationsFallbackHandler;
    }

    @Override
    public UnsupportedIdentityProviderOperationsFallbackHandler getUnsupportedIdentityProviderOperationsFallbackHandler() {
        return this.unsupportedIdentityProviderOperationsFallbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOwner(UserSession userSession) {
        if (userSession != null) {
            Map<String, Object> sensitiveCustomData;
            Map<String, Object> map = sensitiveCustomData = userSession.getSensitiveCustomData();
            synchronized (map) {
                return sensitiveCustomData.containsKey("oidc.providerMetadata");
            }
        }
        return false;
    }

    @Override
    public UserSession checkSession(UserSession userSession, long sessionCheckIntervalInSeconds) throws IdentityProviderException {
        LOG.log(Level.FINEST, "checkSession userSession=..., sessionCheckIntervalInSeconds=" + sessionCheckIntervalInSeconds);
        this.refreshTokensWithFocusOnExpiredRefreshToken(userSession, sessionCheckIntervalInSeconds);
        return userSession;
    }

    @Override
    public UserSession login(String tenant, String username, String password) throws IdentityProviderException {
        return null;
    }

    @Override
    public UserSession login(BpcCallbackHandler bpcCallbackHandler) throws IdentityProviderException {
        return null;
    }

    @Override
    public UserSession updateSession(UserSession oldSession, String newTenant) throws IdentityProviderException {
        return null;
    }

    @Override
    public void logout(String sessionId) throws IdentityProviderException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI createLogoutURI(UserSession userSession, HttpServletRequest request) throws IdentityProviderException {
        LOG.info("createLogoutURI userSession=" + userSession + ", request=" + request);
        String requestUrl = request.getRequestURL().toString();
        OIDCProviderMetadata oidcProviderMetadata = this.providerMetadata.getOIDCProviderMetadataForRequestUrl(requestUrl);
        URI endSessionEndpoint = oidcProviderMetadata.getEndSessionEndpointURI();
        JWT idToken = null;
        if (userSession != null) {
            Map<String, Object> sensitiveCustomData;
            Map<String, Object> map = sensitiveCustomData = userSession.getSensitiveCustomData();
            synchronized (map) {
                idToken = (JWT)sensitiveCustomData.get(OIDC_ID_TOKEN);
            }
        }
        URI postRedirectUri = this.postLogoutRedirectUri.getURIforRequestUrl(requestUrl);
        String bpcLanguageFromHeader = request.getHeader("X-BPC-Language");
        if (!StringUtil.isNullOrEmpty(bpcLanguageFromHeader)) {
            postRedirectUri = UriBuilder.fromUri((URI)postRedirectUri).queryParam("language", new Object[]{bpcLanguageFromHeader}).build(new Object[0]);
        }
        LogoutRequest logoutRequest = new LogoutRequest(endSessionEndpoint, idToken, postRedirectUri, null);
        return logoutRequest.toURI();
    }

    @Override
    public boolean canUpdateUserPasswords() throws IdentityProviderException {
        return false;
    }

    @Override
    public void updateUserPassword(String userName, String oldPassword, String newPassword) throws IdentityProviderException {
    }

    @Override
    public UserSession requestUserSession(UserSessionRequest userSessionRequest) throws IdentityProviderException {
        UserSession userSession;
        block3: {
            LOG.finest("requestUserSession userSessionRequest=...");
            if (!(userSessionRequest instanceof HttpUserSessionRequest)) {
                throw new IllegalArgumentException("only support HttpUserSessionRequest");
            }
            HttpUserSessionRequest httpUserSessionRequest = (HttpUserSessionRequest)userSessionRequest;
            userSession = null;
            try {
                userSession = this.checkAuthenticationResponse(httpUserSessionRequest.getUri());
            }
            catch (IdentityProviderException | URISyntaxException e) {
                LOG.log(Level.INFO, "failed to check oidp redirected uri", e);
                if (!(e instanceof IdentityProviderException)) break block3;
                IdentityProviderException ie = (IdentityProviderException)e;
                if (!ie.isErrorCode(CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR)) break block3;
                throw ie;
            }
        }
        return userSession;
    }

    @Override
    public URI createAuthenticationRequestURI(String requestUrl) throws IdentityProviderException {
        LOG.info("createAuthenticationRequestURI requestUrl=" + requestUrl);
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(this.providerMetadata.getOIDCProviderMetadataForRequestUrl(requestUrl).getAuthorizationEndpointURI(), new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), Scope.parse((String)this.scope), this.clientID, this.postAuthenticationRedirectUri.getURIforRequestUrl(requestUrl), authState, new Nonce());
        return authenticationRequest.toURI();
    }

    @Override
    public UserSession checkAuthenticationResponse(URI responseURI) throws IdentityProviderException {
        LOG.info("checkAuthenticationResponse responseURI=" + responseURI);
        OIDCProviderMetadata oidcProviderMetadata = this.providerMetadata.getOIDCProviderMetadataForRequestUrl(responseURI.toString());
        AuthorizationCode authCode = this.extractAuthCode(responseURI);
        OIDCTokenResponse accessTokenResponse = this.fetchAccessTokenByUsingAuthorizationCode(authCode, responseURI, oidcProviderMetadata);
        return this.createUserSession(accessTokenResponse, oidcProviderMetadata);
    }

    private AuthorizationCode extractAuthCode(URI responseURI) throws IdentityProviderException {
        LOG.info("extractAuthCode responseURI=" + responseURI);
        try {
            AuthenticationResponse authResp = AuthenticationResponseParser.parse((URI)responseURI);
            if (authResp instanceof AuthenticationErrorResponse) {
                LOG.warning("Found AuthenticationErrorResponse");
                ErrorObject error = ((AuthenticationErrorResponse)authResp).getErrorObject();
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Auth response error: " + error.getCode() + " - " + error.getDescription());
            }
            AuthenticationSuccessResponse authSuccessResponse = (AuthenticationSuccessResponse)authResp;
            if (authSuccessResponse.getState() == null || !authSuccessResponse.getState().equals((Object)authState)) {
                LOG.warning("Found auth state mismatch. Expected state: " + authState + " - received state: " + authSuccessResponse.getState());
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_AUTH_FLOW_ERROR, "State not valid");
            }
            return authSuccessResponse.getAuthorizationCode();
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_RESPONSE_INVALID, "Failed to parse the authentication response.", e);
        }
    }

    private OIDCTokenResponse fetchAccessTokenByUsingAuthorizationCode(AuthorizationCode authCode, URI responseURI, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOG.info("fetchAccessTokenByUsingAuthorizationCode authCode=" + authCode + ", responseURI=" + responseURI + ", oidcProviderMetadata=...");
        URI redirectUriToCheck = this.postAuthenticationRedirectUri.getURIforRequestUrl(responseURI.toString());
        try {
            String themeName = UriQueryUtil.getQueryParams(responseURI).get("theme");
            if (!StringUtil.isNullOrEmpty(themeName)) {
                redirectUriToCheck = new URIBuilder(redirectUriToCheck).setParameter("theme", themeName).build();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to perform the BPC-5215 theme hack. Should not happen, but I must catch the exceptions.", ex);
        }
        try {
            String language = UriQueryUtil.getQueryParams(responseURI).get("language");
            if (!StringUtil.isNullOrEmpty(language)) {
                redirectUriToCheck = new URIBuilder(redirectUriToCheck).setParameter("language", language).build();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to perform the BPC-5656 language hack. Should not happen, but I must catch the exceptions.", ex);
        }
        return this._fetchAccessToken((AuthorizationGrant)new AuthorizationCodeGrant(authCode, redirectUriToCheck), oidcProviderMetadata);
    }

    private OIDCTokenResponse fetchAccessTokenByUsingRefreshToken(RefreshToken refreshToken, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOG.info("fetchAccessTokenByUsingRefreshToken refreshToken=" + refreshToken + ", oidcProviderMetadata=...");
        return this._fetchAccessToken((AuthorizationGrant)new RefreshTokenGrant(refreshToken), oidcProviderMetadata);
    }

    private OIDCTokenResponse _fetchAccessToken(AuthorizationGrant tokenGrant, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOG.info("_fetchAccessToken tokenGrant=" + tokenGrant + ", oidcProviderMetadata=...");
        try {
            TokenRequest tokenReq = new TokenRequest(oidcProviderMetadata.getTokenEndpointURI(), (ClientAuthentication)new ClientSecretBasic(this.clientID, this.clientSecret), tokenGrant);
            HTTPRequest tokenHttpRequest = tokenReq.toHTTPRequest();
            try {
                BpcTrustStore.getInstance().setTo(tokenHttpRequest);
            }
            catch (Exception ex) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_VIRTIMO_TRUSTSTORE_ERROR, "Failed to use the BPC trust store.", ex);
            }
            HTTPResponse tokenHTTPResp = tokenHttpRequest.send();
            LOG.info("Token response: " + tokenHTTPResp.getContent());
            TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)tokenHTTPResp);
            if (tokenResponse instanceof TokenErrorResponse) {
                LOG.info("Found TokenErrorResponse");
                ErrorObject error = ((TokenErrorResponse)tokenResponse).getErrorObject();
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR, "Token response error: " + error.getCode() + " - " + error.getDescription());
            }
            return (OIDCTokenResponse)tokenResponse;
        }
        catch (SerializeException | IOException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR, "Failed to perform token request.", e);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR, "Failed to parse the token response.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTokensWithFocusOnExpiredAccessToken(UserSession userSession) throws IdentityProviderException {
        Map<String, Object> sensitiveCustomData;
        LOG.info("refreshTokensWithFocusOnExpiredAccessToken userSession=...");
        Map<String, Object> map = sensitiveCustomData = userSession.getSensitiveCustomData();
        synchronized (map) {
            long tokenRequestedTimestamp = (Long)sensitiveCustomData.get(OIDC_TOKENS_REQUESTED_TIMESTAMP);
            Number accessTokenExpiresInSec = (Number)sensitiveCustomData.get(OIDC_ACCESS_TOKEN_EXPIRES_IN_SEC);
            if (this.willTokenExpireSoon(tokenRequestedTimestamp, accessTokenExpiresInSec, 15L)) {
                this.refreshAccessToken(userSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTokensWithFocusOnExpiredRefreshToken(UserSession userSession, long sessionCheckIntervallInSeconds) throws IdentityProviderException {
        Map<String, Object> sensitiveCustomData;
        LOG.info("refreshTokensWithFocusOnExpiredRefreshToken userSession=..., sessionCheckIntervallInSeconds=" + sessionCheckIntervallInSeconds);
        Map<String, Object> map = sensitiveCustomData = userSession.getSensitiveCustomData();
        synchronized (map) {
            long tokenRequestedTimestamp = (Long)sensitiveCustomData.get(OIDC_TOKENS_REQUESTED_TIMESTAMP);
            Number refreshTokenExpiresInSec = (Number)sensitiveCustomData.get(OIDC_REFRESH_TOKEN_EXPIRES_IN_SEC);
            if (this.willTokenExpireSoon(tokenRequestedTimestamp, refreshTokenExpiresInSec, 15L + sessionCheckIntervallInSeconds)) {
                this.refreshAccessToken(userSession);
            }
        }
    }

    private boolean willTokenExpireSoon(long tokenRequestedTimestamp, Number tokenExpiresInSeconds, long bufferInSeconds) {
        return System.currentTimeMillis() + bufferInSeconds * 1000L >= tokenRequestedTimestamp + tokenExpiresInSeconds.longValue() * 1000L;
    }

    private void refreshAccessToken(UserSession userSession) throws IdentityProviderException {
        LOG.info("refreshAccessToken userSession=...");
        Map<String, Object> sensitiveCustomData = userSession.getSensitiveCustomData();
        OIDCProviderMetadata oidcProviderMetadata = (OIDCProviderMetadata)sensitiveCustomData.get("oidc.providerMetadata");
        RefreshToken refreshToken = (RefreshToken)sensitiveCustomData.get(OIDC_REFRESH_TOKEN);
        OIDCTokenResponse tokenResponse = this.fetchAccessTokenByUsingRefreshToken(refreshToken, oidcProviderMetadata);
        this.keepTokenResponseInUserSession(userSession, tokenResponse);
    }

    protected UserSession createUserSession(OIDCTokenResponse accessTokenResponse, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOG.info("createUserSession accessTokenResponse=..., oidcProviderMetadata=...");
        AccessToken accessToken = accessTokenResponse.getTokens().getAccessToken();
        String sessionId = accessTokenResponse.toJSONObject().getAsString("session_state");
        return this.createUserSession(accessToken, sessionId, accessTokenResponse, oidcProviderMetadata);
    }

    protected UserSession createUserSession(AccessToken accessToken, String sessionId, OIDCTokenResponse accessTokenResponse, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOG.info("createUserSession accessToken=..., sessionId=..., accessTokenResponse=..., oidcProviderMetadata=...");
        sessionId = StringUtil.isNullOrEmpty(sessionId) ? UUIDGenerator.randomUUID() : sessionId;
        Date expirationDate = this.getSessionExpirationDate();
        UserInfoSuccessResponse userInfoResponse = this.fetchUserInfo(accessToken, oidcProviderMetadata);
        UserInfo userInfo = this.extractUserInfo(userInfoResponse);
        JWT idToken = null;
        if (accessTokenResponse != null) {
            idToken = accessTokenResponse.getTokens().toOIDCTokens().getIDToken();
        }
        HashSet<JWTClaimsSet> claimsSets = new HashSet<JWTClaimsSet>();
        try {
            if (accessToken != null) {
                claimsSets.add(JWTParser.parse((String)accessToken.getValue()).getJWTClaimsSet());
            }
            if (idToken != null) {
                claimsSets.add(idToken.getJWTClaimsSet());
            }
        }
        catch (ParseException e) {
            LOG.log(Level.INFO, "failed to parse  token claims", e);
        }
        LOG.info("Create UserSession");
        Set<Role> roles = this.extractRoles(this.claimNameRoles, userInfo, claimsSets);
        Set<Organisation> organisations = this.extractOrganisations(this.claimNameOrganisations, userInfo, claimsSets);
        HashSet<InactiveOrganisation> inactiveOrganisations = new HashSet<InactiveOrganisation>();
        Set<Right> rights = this.extractRights(this.claimNameRights, userInfo, claimsSets);
        HashMap<String, List<String>> principals = new HashMap<String, List<String>>();
        String loginName = this.getUsername(userInfo);
        UserSessionImpl userSession = UserSessionImpl.UserSessionImplBuilder.newInstance().withSessionId(sessionId).withFirstName(userInfo.getGivenName()).withLastName(userInfo.getFamilyName()).withLoginName(loginName).withEmail(userInfo.getEmailAddress()).withExpirationDate(expirationDate).withOrganisations(organisations).withInactiveOrganisations(inactiveOrganisations).withRoles(roles).withRights(rights).withPrincipals(principals).build();
        userSession.getSensitiveCustomData().put("oidc.providerMetadata", oidcProviderMetadata);
        userSession.getCustomData().put("locale", userInfo.getLocale());
        if (accessTokenResponse != null) {
            this.keepTokenResponseInUserSession(userSession, accessTokenResponse);
        }
        this.keepUserInfoAsJWTInUserSession(userSession, userInfo, userInfoResponse);
        return userSession;
    }

    private UserInfoSuccessResponse fetchUserInfo(AccessToken accessToken, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOG.info("fetchUserInfo accessToken=" + accessToken + ", oidcProviderMetadata=...");
        try {
            UserInfoRequest userInfoReq = new UserInfoRequest(oidcProviderMetadata.getUserInfoEndpointURI(), accessToken);
            HTTPRequest userInfoHttpRequest = userInfoReq.toHTTPRequest();
            try {
                BpcTrustStore.getInstance().setTo(userInfoHttpRequest);
            }
            catch (Exception ex) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_VIRTIMO_TRUSTSTORE_ERROR, "Failed to use the Virtimo trust store.", ex);
            }
            HTTPResponse userInfoHTTPResp = userInfoHttpRequest.send();
            LOG.info("User info response: " + userInfoHTTPResp.getContent());
            UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)userInfoHTTPResp);
            if (userInfoResponse instanceof UserInfoErrorResponse) {
                LOG.info("Found UserInfoErrorResponse");
                ErrorObject error = ((UserInfoErrorResponse)userInfoResponse).getErrorObject();
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "User info response error: " + error.getCode() + " - " + error.getDescription());
            }
            return (UserInfoSuccessResponse)userInfoResponse;
        }
        catch (com.nimbusds.oauth2.sdk.ParseException ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_RESPONSE_INVALID, "Failed to parse the user info response.", ex);
        }
        catch (SerializeException | IOException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_AUTH_FLOW_ERROR, "Failed to perform the user info request.", e);
        }
    }

    private UserInfo extractUserInfo(UserInfoSuccessResponse userInfoSuccessResponse) throws IdentityProviderException {
        LOG.info("extractUserInfo userInfoSuccessResponse=...");
        try {
            UserInfo userInfo = userInfoSuccessResponse.getUserInfo();
            if (userInfo == null && userInfoSuccessResponse.getUserInfoJWT() != null) {
                userInfo = new UserInfo(userInfoSuccessResponse.getUserInfoJWT().getJWTClaimsSet());
            }
            return userInfo;
        }
        catch (ParseException ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_RESPONSE_INVALID, "Failed to parse the user info success response.", ex);
        }
    }

    private void keepTokenResponseInUserSession(UserSession userSession, OIDCTokenResponse accessTokenResponse) {
        LOG.info("keepTokenResponseInUserSession userSession=" + userSession + ", accessTokenResponse=" + accessTokenResponse);
        long tokensRequestedTimestamp = System.currentTimeMillis();
        JWT idToken = accessTokenResponse.getOIDCTokens().getIDToken();
        AccessToken accessToken = accessTokenResponse.getTokens().getAccessToken();
        Number accessTokenExpiresInSeconds = accessTokenResponse.toJSONObject().getAsNumber("expires_in");
        RefreshToken refreshToken = accessTokenResponse.getTokens().getRefreshToken();
        Number refreshTokenExpiresInSeconds = accessTokenResponse.toJSONObject().getAsNumber("refresh_expires_in");
        Map<String, Object> sensitiveCustomData = userSession.getSensitiveCustomData();
        sensitiveCustomData.put(OIDC_ID_TOKEN, idToken);
        sensitiveCustomData.put(OIDC_TOKENS_REQUESTED_TIMESTAMP, tokensRequestedTimestamp);
        sensitiveCustomData.put(OIDC_ACCESS_TOKEN, accessToken);
        sensitiveCustomData.put(OIDC_ACCESS_TOKEN_EXPIRES_IN_SEC, accessTokenExpiresInSeconds);
        sensitiveCustomData.put(OIDC_REFRESH_TOKEN, refreshToken);
        sensitiveCustomData.put(OIDC_REFRESH_TOKEN_EXPIRES_IN_SEC, refreshTokenExpiresInSeconds);
        try {
            Object impersonatorClaimObject = SignedJWT.parse((String)accessToken.getValue()).getJWTClaimsSet().getClaim("impersonator");
            if (impersonatorClaimObject instanceof HashMap) {
                userSession.getCustomData().put("impersonator", new HashMap((HashMap)impersonatorClaimObject));
            } else if (impersonatorClaimObject != null) {
                LOG.severe("When you see this log message, then please inform the BPC developers that the 'impersonatorClaimObject' type has been changed and must be adjusted.");
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to set the impersonator ... " + e.getMessage(), e);
        }
    }

    private void keepUserInfoAsJWTInUserSession(UserSession userSession, UserInfo userInfo, UserInfoSuccessResponse userInfoSuccessResponse) {
        if (userInfoSuccessResponse.getUserInfoJWT() != null) {
            userSession.getCustomData().put(USER_INFO_JWT_KEY, userInfoSuccessResponse.getUserInfoJWT().serialize());
        } else {
            try {
                userSession.getCustomData().put(USER_INFO_JWT_KEY, new PlainJWT(userInfo.toJWTClaimsSet()).serialize());
            }
            catch (com.nimbusds.oauth2.sdk.ParseException e) {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private Set<Role> extractRoles(String claimNameRolesToExtract, UserInfo userInfo, Set<JWTClaimsSet> claimsSets) {
        LOG.info("extractRoles claimNameRolesToExtract=" + claimNameRolesToExtract + ", userInfo=...");
        HashSet<Role> roles = new HashSet<Role>();
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            roles.addAll(this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRoles(this.getUsername(userInfo)));
        }
        for (String roleName : OidcIdentityProvider.extractFromClaim(claimNameRolesToExtract, userInfo, claimsSets)) {
            roles.add(RolesFactory.getRole(roleName));
        }
        return roles;
    }

    private Set<Organisation> extractOrganisations(String claimNameOrganisationsToExtract, UserInfo userInfo, Set<JWTClaimsSet> claimsSets) {
        LOG.info("extractOrganisations claimNameOrganisationsToExtract=" + claimNameOrganisationsToExtract + ", userInfo=...");
        HashSet<Organisation> organisations = new HashSet<Organisation>();
        organisations.add(OrganisationFactory.getDefaultOrganisation());
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            organisations.addAll(this.unsupportedIdentityProviderOperationsFallbackHandler.getUserOrganisations(this.getUsername(userInfo)));
        }
        for (String orgName : OidcIdentityProvider.extractFromClaim(claimNameOrganisationsToExtract, userInfo, claimsSets)) {
            organisations.add(OrganisationFactory.getOrganisation(orgName));
        }
        return organisations;
    }

    private Set<Right> extractRights(String claimNameRightsToExtract, UserInfo userInfo, Set<JWTClaimsSet> claimsSets) {
        LOG.info("extractRights claimNameRightsToExtract=" + claimNameRightsToExtract + ", userInfo=...");
        HashSet<Right> rights = new HashSet<Right>();
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            rights.addAll(this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRights(this.getUsername(userInfo)));
        }
        for (String rightName : OidcIdentityProvider.extractFromClaim(claimNameRightsToExtract, userInfo, claimsSets)) {
            rights.add(RightFactory.getRight(rightName));
        }
        return rights;
    }

    protected static Set<String> extractFromClaim(String claimNameToExtract, UserInfo userInfo, Set<JWTClaimsSet> claimsSets) {
        LOG.info("extractFromClaim claimNameToExtract=" + claimNameToExtract + ", userInfo=...");
        HashSet<String> values = new HashSet<String>();
        List<String> claimNames = StringUtil.explode(claimNameToExtract, ",");
        if (claimNames != null) {
            for (String claimName : claimNames) {
                List<String> splittedClaimNames = ClaimNameSplitter.splitClaimNameWithDots(claimName);
                Object current = null;
                for (String splittedClaimName : splittedClaimNames) {
                    if (current == null) {
                        current = userInfo.getClaim(splittedClaimName);
                    } else if (current instanceof net.minidev.json.JSONObject) {
                        net.minidev.json.JSONObject jsonObject = (net.minidev.json.JSONObject)current;
                        current = jsonObject.get((Object)splittedClaimName);
                    }
                    if (!(current instanceof JSONArray)) continue;
                    List claimValues = JSONArrayUtils.toStringList((JSONArray)((JSONArray)current));
                    values.addAll(claimValues);
                }
                if (claimsSets == null) continue;
                current = null;
                for (JWTClaimsSet claimSet : claimsSets) {
                    for (String splittedClaimName : splittedClaimNames) {
                        if (current == null) {
                            current = claimSet.getClaim(splittedClaimName);
                        } else if (current instanceof JSONObject) {
                            JSONObject jsonObject = (JSONObject)current;
                            current = jsonObject.get((Object)splittedClaimName);
                        }
                        if (!(current instanceof com.nimbusds.jose.shaded.json.JSONArray)) continue;
                        for (Object roleName : (com.nimbusds.jose.shaded.json.JSONArray)current) {
                            values.add(roleName.toString());
                        }
                    }
                }
            }
        }
        return values;
    }

    @Override
    public URI getPostAuthenticationRedirectUri(String requestUrl) {
        LOG.info("getPostAuthenticationRedirectUri requestUrl=" + requestUrl);
        return this.postAuthenticationRedirectUri.getURIforRequestUrl(requestUrl);
    }

    protected Date getSessionExpirationDate() {
        LOG.info("getSessionExpirationDate");
        return this.getSessionExpirationDateFromIdpBackendConnectionSetting();
    }

    protected Date getSessionExpirationDateFromIdpBackendConnectionSetting() {
        LOG.info("Using the idp backend connection session expiration value: " + this.sessionExpirationMinutes + " minutes");
        return Timestamp.valueOf(LocalDateTime.now().plusMinutes(this.sessionExpirationMinutes));
    }

    private String getUsername(UserInfo userInfo) {
        String loginName = userInfo.getPreferredUsername();
        if (loginName == null) {
            if (userInfo.getEmailAddress() != null) {
                LOG.warning("Didn't got a preferred_username from IdP - Using email address");
                loginName = userInfo.getEmailAddress();
            } else if (userInfo.getStringClaim("sub") != null && userInfo.getStringClaim("sub").length() > 0) {
                LOG.warning("Didn't got a preferred_username or email from IdP - Using sub");
                loginName = userInfo.getStringClaim("sub");
            } else {
                LOG.severe("Didn't got a any id for the user from IdP - this should never happen!");
                loginName = Integer.toString(userInfo.hashCode());
            }
        }
        return loginName;
    }

    public UserSession getUserInfo(HttpServletRequest req, String accessTokenType, String accessToken) throws IdentityProviderException {
        LOG.info("getUserInfo req=..., accessTokenType=" + accessTokenType + ", accessToken=...");
        Object token = AccessTokenType.BEARER.getValue().equalsIgnoreCase(accessTokenType) ? new BearerAccessToken(accessToken) : (AccessTokenType.DPOP.getValue().equalsIgnoreCase(accessTokenType) ? new DPoPAccessToken(accessToken) : new TypelessAccessToken(accessToken));
        OIDCProviderMetadata oidcProviderMetadata = this.providerMetadata.getOIDCProviderMetadataForRequestUrl(req.getRequestURL().toString());
        return this.createUserSession((AccessToken)token, null, null, oidcProviderMetadata);
    }

    public void performConnectionTest() throws ConnectionTestException {
        LOG.info("performConnectionTest");
    }
}

