/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.core.auth.oidc.OidcProviderMetadataMode;
import de.virtimo.bpc.core.auth.oidc.OidcUri;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.MapUtil;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;

public class OidcProviderMetadata {
    private static final Logger LOG = Logger.getLogger(OidcProviderMetadata.class.getName());
    private final OidcProviderMetadataMode mode;
    private final OidcUri discoveryUri;
    private final Map<URI, String> providerMetadatas;

    public OidcProviderMetadata(String discoveryUriValue, Object config, OidcProviderMetadataMode mode) throws URISyntaxException, IdentityProviderException {
        this.mode = mode;
        this.discoveryUri = mode == OidcProviderMetadataMode.SingleDiscoveryUri ? new OidcUri(discoveryUriValue) : new OidcUri(config);
        this.providerMetadatas = new HashMap<URI, String>();
        for (URI discoveryURI : this.discoveryUri.getURIs()) {
            this.providerMetadatas.put(discoveryURI, this.fetchOIDCProviderMetadata(discoveryURI));
        }
    }

    public OIDCProviderMetadata getOIDCProviderMetadataForRequestUrl(String url) throws IdentityProviderException {
        LOG.info("getOIDCProviderMetadataForRequestUrl url=" + url);
        URI discoveryURI = this.discoveryUri.getURIforRequestUrl(url);
        if (discoveryURI == null) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_OIDC_DISCOVERY_URL", MapUtil.mapOf("url", url));
        }
        if (!this.providerMetadatas.containsKey(discoveryURI)) {
            this.providerMetadatas.put(discoveryURI, this.fetchOIDCProviderMetadata(discoveryURI));
        }
        try {
            String providerMetadataString = this.providerMetadatas.get(discoveryURI);
            OIDCProviderMetadata providerMetadata = OIDCProviderMetadata.parse((String)providerMetadataString);
            LOG.info("Provider metadata: " + providerMetadata);
            return providerMetadata;
        }
        catch (Exception e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_OIDC_DISCOVER_METADATA", e);
        }
    }

    protected String fetchOIDCProviderMetadata(URI oidcDiscoveryURI) throws IdentityProviderException {
        String string;
        block14: {
            LOG.info("fetchOIDCProviderMetadata oidcDiscoveryURI=" + oidcDiscoveryURI);
            URLConnection conn = oidcDiscoveryURI.toURL().openConnection();
            BpcTrustStore.getInstance().setTo(conn);
            InputStream stream = conn.getInputStream();
            try {
                String providerMetadata;
                try (Scanner s = new Scanner(stream);){
                    providerMetadata = s.useDelimiter("\\A").hasNext() ? s.next() : "";
                }
                string = providerMetadata;
                if (stream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_CONFIG, "CORE_ERROR_IDENTITY_PROVIDER_OIDC_DISCOVER_METADATA", e);
                }
            }
            stream.close();
        }
        return string;
    }
}

