/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.backup.Snapshotter;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.SetUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class BackupJobImpl
implements BackupJob {
    private static final Logger LOG = Logger.getLogger(BackupJobImpl.class.getName());
    private final BundleContext bundleContext;
    private final String backupJobIdentifier;
    private final BackupSetting backupSetting;
    private long timestampOfLatestBackup;

    public BackupJobImpl(BundleContext bundleContext, String backupJobIdentifier, BackupSetting backupSetting) {
        this.bundleContext = bundleContext;
        this.backupJobIdentifier = backupJobIdentifier;
        this.backupSetting = backupSetting;
        this.timestampOfLatestBackup = -1L;
    }

    @Override
    public String getBackupJobIdentifier() {
        return this.backupJobIdentifier;
    }

    @Override
    public BackupSetting getBackupSetting() {
        return this.backupSetting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupJobImpl backupJob = (BackupJobImpl)o;
        return this.backupJobIdentifier.equals(backupJob.backupJobIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.backupJobIdentifier);
    }

    public String toString() {
        return "BackupJob{bundleContext=" + this.bundleContext + ", backupJobIdentifier='" + this.backupJobIdentifier + "', backupSetting=" + this.backupSetting + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            LOG.info(this.backupJobIdentifier + ": BackupJob start");
            long startTime = System.currentTimeMillis();
            try (BpcServicesTracker<ModuleManager> moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);){
                CoreModule coreModule = moduleManagerTracker.getService().getModuleByClass(CoreModule.class);
                if (coreModule.isMaintenanceModeEnabled()) {
                    LOG.info(this.backupJobIdentifier + ": Skipping backup job execution due to enabled maintenance mode");
                    break block25;
                }
                BpcServicesTracker<OpenSearchService> openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
                BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
                try (BpcServicesTracker<OpenSearchService> bpcServicesTracker = openSearchServiceTracker;
                     BpcServicesTracker<ClientSessionManager> bpcServicesTracker2 = clientSessionManagerTracker;){
                    this.createSnapshotBackup(openSearchServiceTracker.getService(), clientSessionManagerTracker.getService());
                }
            }
            catch (ServiceNotFoundException ex) {
                LOG.log(Level.SEVERE, this.backupJobIdentifier + ": Failed to perform the backup job without the required services.", ex);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, this.backupJobIdentifier + ": Failed to perform the backup job.", ex);
            }
            finally {
                LOG.info(this.backupJobIdentifier + ": BackupJob finished in " + (System.currentTimeMillis() - startTime) + " ms");
            }
        }
    }

    @Override
    public String getNewSnapshotName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        return this.getSnapshotNamePrefix() + dateFormat.format(new Date());
    }

    @Override
    public String getSnapshotNamePrefix() {
        return "snapshot-" + this.backupSetting.getIndicesToBackupNamesAsKey() + "-";
    }

    private void createSnapshotBackup(OpenSearchService oss, ClientSessionManager clientSessionManager) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOG.info(this.backupJobIdentifier + ": createSnapshotBackup");
        Snapshotter snapshotter = new Snapshotter(oss);
        try {
            if (!snapshotter.existsBackupRepository("bpc_backup")) {
                snapshotter.createBackupRepository("bpc_backup", "bpc_backup");
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, this.backupJobIdentifier + ": No backup possible, the backup repository could not be created. " + ex.getMessage());
            return;
        }
        List<BackupSnapshotInfo> snapshots = snapshotter.getAllSnapshotsWithPrefix("bpc_backup", this.getSnapshotNamePrefix());
        boolean timeToCreateASnapshot = false;
        if (snapshots == null || snapshots.isEmpty()) {
            LOG.info(this.backupJobIdentifier + ": No snapshots exist");
            this.timestampOfLatestBackup = 0L;
            timeToCreateASnapshot = true;
        } else {
            this.timestampOfLatestBackup = snapshotter.getTimestampOfLatestSnapshot(snapshots);
            LOG.info(this.backupJobIdentifier + ": Snapshots exist; date of latest:" + new Date(this.timestampOfLatestBackup));
            if (this.timestampOfLatestBackup < System.currentTimeMillis() - this.backupSetting.getIntervalInSeconds() * 1000L) {
                timeToCreateASnapshot = true;
            }
        }
        if (this.backupSetting.isEnabled()) {
            if (timeToCreateASnapshot) {
                LOG.info(this.backupJobIdentifier + ": Snapshot must be created");
                BackupSnapshotInfo snapshotInfo = snapshotter.createSnapshot("bpc_backup", this.getNewSnapshotName(), this.backupSetting.getIndicesToBackup());
                if (snapshotInfo != null) {
                    this.timestampOfLatestBackup = snapshotInfo.getStartTimeInMillis();
                    SystemAuditLog.info("BackupCreated", "Backup with the snapshot name '" + snapshotInfo.getName() + "' created");
                    clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), "de/virtimo/bpc/core/backup/backupCreated", JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
                }
            } else {
                LOG.info(this.backupJobIdentifier + ": Creating a snapshot is not necessary at the moment");
            }
            List<BackupSnapshotInfo> deletedSnapshots = snapshotter.deleteOldSnapshots("bpc_backup", snapshots, this.backupSetting.getKeepBackupsDurationInSeconds());
            if (!deletedSnapshots.isEmpty()) {
                ArrayList<Map<String, Object>> websocketMessageContent = new ArrayList<Map<String, Object>>();
                for (BackupSnapshotInfo deletedSnapshot : deletedSnapshots) {
                    SystemAuditLog.info("BackupDeleted", "Backup with the snapshot name '" + deletedSnapshot.getName() + "' deleted");
                    websocketMessageContent.add(JsonUtil.getInstance().convertPojoToMap(deletedSnapshot));
                }
                clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), "de/virtimo/bpc/core/backup/backupDeleted", websocketMessageContent);
            }
        } else {
            LOG.info(this.backupJobIdentifier + ": Skipping backup job execution ... job is disabled.");
        }
    }

    @Override
    public long getTimestampOfLastestBackup() {
        return this.timestampOfLatestBackup;
    }

    @Override
    public void setTimestampOfLatestBackup(long timestampOfLatestBackup) {
        this.timestampOfLatestBackup = timestampOfLatestBackup;
    }

    @Override
    public long getTimestampOfNextBackup() {
        return this.timestampOfLatestBackup <= 0L ? -1L : this.getTimestampOfLastestBackup() + this.backupSetting.getIntervalInSeconds() * 1000L;
    }
}

