/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BackupJobInfo;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.BackupSupport;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.backup.BackupJobImpl;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;

public class BackupJobs {
    private static final Logger LOG = Logger.getLogger(BackupJobs.class.getName());
    private final BundleContext bundleContext;
    private CoreModule coreModule;
    private boolean initialized;
    private final Set<BackupJob> backupJobs;
    private final Set<BackupJob> queuedBackupJobs;
    private ScheduledExecutorService executorService;
    private final HashMap<String, ScheduledFuture<?>> backupJobHandles;
    private final EventRegistration eventRegistration;
    private static final Object MODEL_LOCK = new Object();

    public BackupJobs(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.initialized = false;
        this.backupJobs = new HashSet<BackupJob>();
        this.queuedBackupJobs = new HashSet<BackupJob>();
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-backups"));
        this.backupJobHandles = new HashMap();
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("_core", new CoreModuleLoadedEventHandler());
        this.eventRegistration.forModuleUpdatedEvents("_core", "backupJobs", new BackupJobsSettingUpdatedEventHandler());
        this.eventRegistration.forAnyBackendModuleLoadedEvents(new BackendModuleLoadedEventHandler());
        this.eventRegistration.forAnyBackendModuleReloadedEvents(new BackendModuleReloadedEventHandler());
    }

    public void destroy() {
        LOG.info("destroy");
        this.eventRegistration.unregisterAllEventHandler();
        this.stopAllBackupJobs();
        if (this.executorService != null) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
                this.executorService = null;
            }
            catch (InterruptedException | RuntimeException ex) {
                LOG.log(Level.SEVERE, "Failed to shutdown the backup jobs thread pool.");
            }
        }
        this.coreModule = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = MODEL_LOCK;
        synchronized (object) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupJobInfo> getBackupJobs() {
        ArrayList<BackupJobInfo> result = new ArrayList<BackupJobInfo>();
        Object object = MODEL_LOCK;
        synchronized (object) {
            Iterator<BackupJob> iterator = this.backupJobs.iterator();
            while (iterator.hasNext()) {
                BackupJob backupJob;
                ScheduledFuture<?> scheduledBackupJob = this.backupJobHandles.get((backupJob = iterator.next()).getBackupJobIdentifier());
                result.add(new BackupJobInfo(backupJob, false, scheduledBackupJob != null, scheduledBackupJob == null ? -1L : scheduledBackupJob.getDelay(TimeUnit.SECONDS)));
            }
            for (BackupJob queuedBackupJob : this.queuedBackupJobs) {
                result.add(new BackupJobInfo(queuedBackupJob, true, false, -1L));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFromBackupJobsSetting(Setting backupJobsSetting) {
        LOG.info("initializeFromBackupJobsSetting backupJobsSetting=" + backupJobsSetting);
        Object object = MODEL_LOCK;
        synchronized (object) {
            this.initialized = true;
            Set<BackupJob> backupJobsFromSetting = this.getBackupJobsFromSetting(backupJobsSetting);
            if (!backupJobsFromSetting.equals(this.backupJobs)) {
                HashSet<BackupJob> backupJobsToStart = new HashSet<BackupJob>(backupJobsFromSetting);
                backupJobsToStart.addAll(this.getQueuedBackupJobs(backupJobsToStart));
                backupJobsToStart.addAll(this.getMandatoryBackupJobsFromResourceFile(backupJobsToStart));
                this.stopAllBackupJobs();
                for (BackupJob backupJobToStart : backupJobsToStart) {
                    this.backupJobs.add(backupJobToStart);
                    this.scheduleBackupJob(backupJobToStart);
                }
                if (!backupJobsFromSetting.equals(backupJobsToStart)) {
                    this.saveBackupJobsBackToSetting();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupJob getBackupJob(String backupJobIdentifier) {
        LOG.info("getBackupJob backupJobIdentifier=" + backupJobIdentifier);
        Object object = MODEL_LOCK;
        synchronized (object) {
            return this.getBackupJob(backupJobIdentifier, this.backupJobs);
        }
    }

    private BackupJob getBackupJob(String backupJobIdentifier, Set<BackupJob> fromBackupJobs) {
        LOG.info("getBackupJob backupJobIdentifier=" + backupJobIdentifier + ", fromBackupJobs=...");
        if (!StringUtil.isNullOrEmpty(backupJobIdentifier) && fromBackupJobs != null) {
            for (BackupJob backupJob : fromBackupJobs) {
                if (!backupJobIdentifier.equalsIgnoreCase(backupJob.getBackupJobIdentifier())) continue;
                return backupJob;
            }
        }
        return null;
    }

    private void saveBackupJobsBackToSetting() {
        LOG.info("saveBackupJobsBackToSetting");
        if (this.coreModule != null) {
            try {
                Map<String, Object> backupJobsForSettingValue = this.getBackupJobsAsSettingValue(this.backupJobs);
                Setting backupJobsSetting = this.coreModule.getConfiguration().getSetting("backupJobs");
                SimpleSettingImpl updatedBackupJobsSetting = new SimpleSettingImpl(backupJobsSetting, backupJobsForSettingValue);
                this.coreModule.getConfiguration().updateSetting(updatedBackupJobsSetting);
            }
            catch (SettingException ex) {
                LOG.log(Level.SEVERE, "Failed to save the updated backup jobs back to the core module setting 'backupJobs'.", ex);
            }
        }
    }

    private Set<BackupJob> getBackupJobsFromSetting(Setting backupJobsSetting) {
        LOG.info("getBackupJobsFromSetting backupJobsSetting=" + backupJobsSetting);
        HashSet<BackupJob> result = new HashSet<BackupJob>();
        if (backupJobsSetting != null) {
            Map backupJobs = backupJobsSetting.getSettingValue().asMap(new HashMap());
            result.addAll(this.getBackupJobsFromSettingValue(backupJobs));
        }
        return result;
    }

    private Set<BackupJob> getBackupJobsFromSettingValue(Map backupJobs) {
        LOG.info("getBackupJobsFromSettingValue backupJobs=" + backupJobs);
        HashSet<BackupJob> result = new HashSet<BackupJob>();
        if (backupJobs != null) {
            for (Object backupJobIdentifierObject : backupJobs.keySet()) {
                String backupJobIdentifier = String.valueOf(backupJobIdentifierObject);
                Map backupJob = (Map)backupJobs.get(backupJobIdentifierObject);
                BackupSetting backupJobSetting = BackupSettingFactory.createFrom(backupJob.get("settings"), (Collection)backupJob.get("indices"));
                result.add(new BackupJobImpl(this.bundleContext, backupJobIdentifier, backupJobSetting));
            }
        }
        return result;
    }

    private Map<String, Object> getBackupJobsAsSettingValue(Set<BackupJob> backupJobs) {
        LOG.info("getBackupJobsAsSettingValue backupJobs=...");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (backupJobs != null) {
            for (BackupJob backupJob : backupJobs) {
                result.put(backupJob.getBackupJobIdentifier(), BackupSettingFactory.asBackupJobSettingValue(backupJob.getBackupSetting()));
            }
        }
        return result;
    }

    private Set<BackupJob> getQueuedBackupJobs(Set<BackupJob> backupJobsToStart) {
        LOG.info("getQueuedBackupJobs backupJobsToStart=...");
        HashSet<BackupJob> result = new HashSet<BackupJob>();
        Set<String> backupJobIdentifiersOfJobsToStart = this.getBackupJobIdentifiers(backupJobsToStart);
        for (BackupJob queuedBackupJob : this.queuedBackupJobs) {
            String backupJobIdentifier = queuedBackupJob.getBackupJobIdentifier();
            if (!backupJobIdentifiersOfJobsToStart.contains(backupJobIdentifier)) {
                result.add(queuedBackupJob);
                continue;
            }
            BackupJob existingBackupJob = this.getBackupJob(backupJobIdentifier, backupJobsToStart);
            BackupSetting updatedBackupSetting = BackupSetting.copyOf(existingBackupJob.getBackupSetting()).withIndicesToBackup(queuedBackupJob.getBackupSetting().getIndicesToBackup()).build();
            result.add(new BackupJobImpl(this.bundleContext, backupJobIdentifier, updatedBackupSetting));
        }
        this.queuedBackupJobs.clear();
        return result;
    }

    private Set<BackupJob> getMandatoryBackupJobsFromResourceFile(Set<BackupJob> backupJobsToStart) {
        LOG.info("getMandatoryBackupJobsFromResourceFile backupJobsToStart=...");
        HashSet<BackupJob> result = new HashSet<BackupJob>();
        Set<String> backupJobIdentifiersOfJobsToStart = this.getBackupJobIdentifiers(backupJobsToStart);
        Map<String, Object> backupJobsResourceFile = JsonDefaultsUtil.loadJsonFileAsMap("defaults/core/backup_jobs.json");
        Set<BackupJob> backupJobsFromResourceFile = this.getBackupJobsFromSettingValue(backupJobsResourceFile);
        for (BackupJob backupJobFromResourceFile : backupJobsFromResourceFile) {
            String backupJobIdentifier = backupJobFromResourceFile.getBackupJobIdentifier();
            if (!backupJobIdentifiersOfJobsToStart.contains(backupJobIdentifier)) {
                result.add(backupJobFromResourceFile);
                continue;
            }
            BackupJob existingBackupJob = this.getBackupJob(backupJobIdentifier, backupJobsToStart);
            BackupSetting updatedBackupSetting = BackupSetting.copyOf(existingBackupJob.getBackupSetting()).withIndicesToBackup(backupJobFromResourceFile.getBackupSetting().getIndicesToBackup()).build();
            result.add(new BackupJobImpl(this.bundleContext, backupJobIdentifier, updatedBackupSetting));
        }
        return result;
    }

    private Set<String> getBackupJobIdentifiers(Set<BackupJob> backupJobs) {
        LOG.fine("getBackupJobIdentifiers backupJobs=...");
        HashSet<String> result = new HashSet<String>();
        if (backupJobs != null) {
            for (BackupJob backupJob : backupJobs) {
                result.add(backupJob.getBackupJobIdentifier());
            }
        }
        return result;
    }

    public int getNumberOfScheduledBackupJobs() {
        return this.backupJobHandles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIdentifiersOfBackupJobs() {
        HashSet<String> result = new HashSet<String>();
        Object object = MODEL_LOCK;
        synchronized (object) {
            result.addAll(this.getBackupJobIdentifiers(this.backupJobs));
        }
        return result;
    }

    public Set<String> getIdentifiersOfScheduledBackupJobs() {
        return new HashSet<String>(this.backupJobHandles.keySet());
    }

    private void scheduleBackupJob(BackupJob backupJob) {
        LOG.info("scheduleBackupJob backupJob=" + backupJob);
        this.stopBackupJob(backupJob.getBackupJobIdentifier());
        ScheduledFuture<?> newBackupJobHandle = this.executorService.scheduleWithFixedDelay(backupJob, 120L, 60L, TimeUnit.SECONDS);
        this.backupJobHandles.put(backupJob.getBackupJobIdentifier(), newBackupJobHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleBackupJobWithSettings(String backupJobIdentifier, BackupSetting backupJobSetting) {
        LOG.info("scheduleBackupJobWithSettings backupJobIdentifier=" + backupJobIdentifier + ", backupJobSetting=" + backupJobSetting);
        if (StringUtil.isNullOrEmpty(backupJobIdentifier)) {
            throw new IllegalArgumentException("backupJobIdentifier cannot be null or empty");
        }
        if (backupJobSetting == null) {
            throw new IllegalArgumentException("backupJobSetting cannot be null");
        }
        Object object = MODEL_LOCK;
        synchronized (object) {
            if (this.initialized) {
                BackupJobImpl backupJobToSchedule = null;
                BackupJob existingBackupJob = this.getBackupJob(backupJobIdentifier, this.backupJobs);
                if (existingBackupJob != null) {
                    if (!existingBackupJob.getBackupSetting().getIndicesToBackup().equals(backupJobSetting.getIndicesToBackup())) {
                        BackupSetting updatedBackupSetting = BackupSetting.copyOf(existingBackupJob.getBackupSetting()).withIndicesToBackup(backupJobSetting.getIndicesToBackup()).build();
                        backupJobToSchedule = new BackupJobImpl(this.bundleContext, backupJobIdentifier, updatedBackupSetting);
                    }
                } else {
                    backupJobToSchedule = new BackupJobImpl(this.bundleContext, backupJobIdentifier, backupJobSetting);
                }
                if (backupJobToSchedule != null) {
                    this.scheduleBackupJob(backupJobToSchedule);
                    this.backupJobs.add(backupJobToSchedule);
                    this.saveBackupJobsBackToSetting();
                }
            } else {
                BackupJobImpl newBackupJob = new BackupJobImpl(this.bundleContext, backupJobIdentifier, backupJobSetting);
                this.queuedBackupJobs.add(newBackupJob);
            }
        }
    }

    public void stopAllBackupJobs() {
        LOG.info("stopAllBackupJobs");
        for (String backupJobIdentifier : new ArrayList<String>(this.backupJobHandles.keySet())) {
            this.stopBackupJob(backupJobIdentifier);
        }
    }

    public void stopBackupJob(String backupJobIdentifier) {
        LOG.info("stopBackupJob backupJobIdentifier=" + backupJobIdentifier);
        if (!StringUtil.isNullOrEmpty(backupJobIdentifier)) {
            ScheduledFuture<?> existingBackupJobHandle = this.backupJobHandles.remove(backupJobIdentifier);
            if (existingBackupJobHandle != null) {
                if (existingBackupJobHandle.cancel(true)) {
                    LOG.info(backupJobIdentifier + ": Running BackupJob cancelled");
                } else {
                    LOG.warning(backupJobIdentifier + ": Could not cancel the running BackupJob");
                }
            } else {
                LOG.info(backupJobIdentifier + ": There is no existing BackupJob to cancel");
            }
        }
    }

    public void stopBackupJobsWithPrefix(String backupJobIdentifierPrefix) {
        LOG.info("stopBackupJobsWithPrefix backupJobIdentifierPrefix=" + backupJobIdentifierPrefix);
        for (String backupJobIdentifier : new ArrayList<String>(this.backupJobHandles.keySet())) {
            if (!backupJobIdentifier.startsWith(backupJobIdentifierPrefix)) continue;
            this.stopBackupJob(backupJobIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBackupJob(String backupJobIdentifier) {
        LOG.info("stopBackupJob backupJobIdentifier=" + backupJobIdentifier);
        if (!StringUtil.isNullOrEmpty(backupJobIdentifier)) {
            this.stopBackupJob(backupJobIdentifier);
            Object object = MODEL_LOCK;
            synchronized (object) {
                BackupJob backupJobToDelete = this.getBackupJob(backupJobIdentifier, this.backupJobs);
                if (backupJobToDelete != null) {
                    this.backupJobs.remove(backupJobToDelete);
                    this.saveBackupJobsBackToSetting();
                }
            }
        }
    }

    private class CoreModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private CoreModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            BackupJobs.this.coreModule = (CoreModule)module;
            Setting backupJobsSetting = BackupJobs.this.coreModule.getConfiguration().getSetting("backupJobs");
            BackupJobs.this.initializeFromBackupJobsSetting(backupJobsSetting);
        }
    }

    private class BackupJobsSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private BackupJobsSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting backupJobTemplatesSetting) {
            LOG.info(this.getClass().getSimpleName() + ".processSetting backupJobTemplatesSetting=...");
            BackupJobs.this.initializeFromBackupJobsSetting(backupJobTemplatesSetting);
        }
    }

    private class BackendModuleLoadedEventHandler
    extends AbstractEventHandler {
        private BackendModuleLoadedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Module module = (Module)event.getProperty("module");
            if (module != null) {
                if (module instanceof BackupSupport) {
                    BackupJobs.this.scheduleBackupJobWithSettings(module.getModuleId(), ((BackupSupport)((Object)module)).getBackupSetting());
                }
            } else {
                LOG.severe("Failed to process module provided backup jobs. Hey BPC-devs, someone changed the properties of the \"de/virtimo/bpc/core/backendModuleLoaded\" event. Please correct this ASAP!");
            }
        }
    }

    private class BackendModuleReloadedEventHandler
    extends AbstractEventHandler {
        private BackendModuleReloadedEventHandler() {
        }

        @Override
        public void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            Module module = (Module)event.getProperty("module");
            if (module != null) {
                if (module instanceof BackupSupport) {
                    BackupJobs.this.scheduleBackupJobWithSettings(module.getModuleId(), ((BackupSupport)((Object)module)).getBackupSetting());
                }
            } else {
                LOG.severe("Failed to process module provided backup jobs. Hey BPC-devs, someone changed the properties of the \"de/virtimo/bpc/core/backendModuleReloaded\" event. Please correct this ASAP!");
            }
        }
    }
}

