/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.BackupJobInfo;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.api.backup.BackupRestoredInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.exception.BackupConflictException;
import de.virtimo.bpc.api.backup.exception.BackupException;
import de.virtimo.bpc.api.backup.exception.BackupJobNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexInfo;
import de.virtimo.bpc.api.response.GlobalConfig;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.backup.BackupActivatedInfoImpl;
import de.virtimo.bpc.core.backup.BackupJobs;
import de.virtimo.bpc.core.backup.BackupRestoredInfoImpl;
import de.virtimo.bpc.core.backup.Snapshotter;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationPersistenceHandler;
import de.virtimo.bpc.core.opensearch.migration.BpcIndicesMigrator;
import de.virtimo.bpc.core.resource.response.SettingsBasedConfigImpl;
import de.virtimo.bpc.core.service.EventManagerImpl;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;

public class BackupManagerImpl
implements BackupManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(BackupManagerImpl.class.getName());
    public static final String BACKUP_EVENT_TOPIC_CREATED = "de/virtimo/bpc/core/backup/backupCreated";
    public static final String BACKUP_EVENT_TOPIC_DELETED = "de/virtimo/bpc/core/backup/backupDeleted";
    public static final String BACKUP_EVENT_TOPIC_ACTIVATED = "de/virtimo/bpc/core/backup/backupActivated";
    public static final String BACKUP_EVENT_TOPIC_RESTORED = "de/virtimo/bpc/core/backup/backupRestored";
    public static final String SNAPSHOTS_REPOSITORY_NAME = "bpc_backup";
    public static final String SNAPSHOTS_FILESYSTEM_FOLDER_NAME = "bpc_backup";
    private final BackupJobs backupJobs;
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<ClientSessionManager> clientSessionManagerTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;

    public BackupManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.backupJobs = new BackupJobs(bundleContext);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.clientSessionManagerTracker = new BpcServicesTracker<ClientSessionManager>(bundleContext, ClientSessionManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        this.backupJobs.destroy();
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public List<BackupJobInfo> getBackupJobs() {
        return this.backupJobs.getBackupJobs();
    }

    @Override
    public int getNumberOfScheduledBackupJobs() {
        return this.backupJobs.getNumberOfScheduledBackupJobs();
    }

    @Override
    public Set<String> getIdentifiersOfScheduledBackupJobs() {
        return this.backupJobs.getIdentifiersOfScheduledBackupJobs();
    }

    @Override
    public Set<String> getIdentifiersOfBackupJobs() {
        return this.backupJobs.getIdentifiersOfBackupJobs();
    }

    @Override
    public void scheduleBackupJobWithSettings(String backupJobIdentifier, BackupSetting backupSetting) {
        LOG.info("scheduleBackupJobWithSettings backupJobIdentifier=" + backupJobIdentifier + ", backupJobSetting=" + backupSetting);
        this.backupJobs.scheduleBackupJobWithSettings(backupJobIdentifier, backupSetting);
    }

    @Override
    public void stopBackupJob(String backupJobIdentifier) {
        LOG.info("stopBackupJob backupJobIdentifier=" + backupJobIdentifier);
        this.backupJobs.stopBackupJob(backupJobIdentifier);
    }

    @Override
    public void stopBackupJobsWithPrefix(String backupJobIdentifierPrefix) {
        LOG.info("stopBackupJobsWithPrefix backupJobIdentifierPrefix=" + backupJobIdentifierPrefix);
        this.backupJobs.stopBackupJobsWithPrefix(backupJobIdentifierPrefix);
    }

    @Override
    public void deleteBackupJob(String backupJobIdentifier) {
        LOG.info("deleteBackupJob backupJobIdentifier=" + backupJobIdentifier);
        this.backupJobs.deleteBackupJob(backupJobIdentifier);
    }

    @Override
    public List<BackupSnapshotInfo> getAllBackups() throws ServiceNotFoundException, BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOG.info("getAllBackups");
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        return snapshotter.getAllSnapshots("bpc_backup");
    }

    @Override
    public BackupSnapshotInfo getBackupInfo(String snapshotName) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("getBackupInfo snapshotName=" + snapshotName);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot("bpc_backup", snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException("bpc_backup", snapshotName);
        }
        return snapshotInfo;
    }

    @Override
    public BackupSnapshotInfo createBackupUsingBackupJob(String backupJobIdentifier) throws BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("createBackupUsingBackupJob backupJobIdentifier=" + backupJobIdentifier);
        BackupJob backupJob = this.backupJobs.getBackupJob(backupJobIdentifier);
        if (backupJob == null) {
            throw new BackupJobNotFoundException(backupJobIdentifier);
        }
        BackupSnapshotInfo backupInfo = this.createBackup(backupJob.getNewSnapshotName(), backupJob.getBackupSetting().getIndicesToBackup());
        backupJob.setTimestampOfLatestBackup(backupInfo.getStartTimeInMillis());
        return backupInfo;
    }

    @Override
    public BackupSnapshotInfo createBackup(String snapshotName, Set<String> indicesToBackup) throws BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("createBackup snapshotName=" + snapshotName + ", indicesToBackup=" + indicesToBackup);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        try {
            if (!snapshotter.existsBackupRepository("bpc_backup")) {
                snapshotter.createBackupRepository("bpc_backup", "bpc_backup");
            }
        }
        catch (Exception ex) {
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_REPOSITORY_FAILURE, "CORE_ERROR_BACKUP_REPOSITORY_CREATION_FAILED", MapUtil.mapOf("repositoryName", "bpc_backup", "folderName", "bpc_backup"), (Throwable)ex);
        }
        BackupSnapshotInfo snapshotInfo = snapshotter.createSnapshot("bpc_backup", snapshotName, indicesToBackup);
        if (snapshotInfo == null) {
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_CREATION_FAILED, "CORE_ERROR_BACKUP_SNAPSHOT_CREATION_FAILED", MapUtil.mapOf("snapshotName", snapshotName));
        }
        clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_CREATED, JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
        return snapshotInfo;
    }

    @Override
    public BackupSnapshotInfo deleteBackup(String snapshotName) throws BackupRepositoryNotFoundException, BackupNotFoundException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("deleteBackup snapshotName=" + snapshotName);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot("bpc_backup", snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException("bpc_backup", snapshotName);
        }
        snapshotter.deleteSnapshot("bpc_backup", snapshotName);
        clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_DELETED, JsonUtil.getInstance().convertPojoToMap(snapshotInfo));
        return snapshotInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackupActivatedInfo activateBackup(String snapshotName) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        boolean bl;
        LOG.info("activateBackup snapshotName=" + snapshotName);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot("bpc_backup", snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException("bpc_backup", snapshotName);
        }
        List<String> backupIndexNames = snapshotInfo.getIndices();
        for (String string : backupIndexNames) {
            Set<String> existingIndexNames;
            String aliasOfIndex = oss.aliasFromBpcIndexName(string);
            if (aliasOfIndex == null || (existingIndexNames = oss.getIndexNamesWithAlias(aliasOfIndex)).size() <= 1) continue;
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_ACTIVATION_FAILED, "Backup activation failed due to inconsistency. There are ${numberOfIndicesWithAlias} indices with the alias '${alias}': ${indexNames}", MapUtil.mapOf("numberOfIndicesWithAlias", existingIndexNames.size(), "alias", aliasOfIndex, "indexNames", "" + Arrays.asList(existingIndexNames.toArray(new String[0])), "snapshot", snapshotName));
        }
        ArrayList<String> aliasesOfBackupIndices = new ArrayList<String>();
        for (String backupIndexName : backupIndexNames) {
            String aliasOfBackupIndexName = oss.aliasFromBpcIndexName(backupIndexName);
            if (aliasOfBackupIndexName != null) {
                aliasesOfBackupIndices.add(aliasOfBackupIndexName);
                continue;
            }
            aliasesOfBackupIndices.add(backupIndexName);
        }
        boolean bl2 = false;
        ArrayList<Map<String, Object>> summary = new ArrayList<Map<String, Object>>();
        boolean startEventSent = this.sendBackupRestoreStartEvent(snapshotName, aliasesOfBackupIndices, backupIndexNames);
        try {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String backupIndexName : backupIndexNames) {
                HashMap<String, String> summaryEntry = new HashMap<String, String>();
                summaryEntry.put("backupIndexName", backupIndexName);
                String aliasOfIndex = oss.aliasFromBpcIndexName(backupIndexName);
                if (aliasOfIndex != null) {
                    BpcIndicesMigrator indicesMigrator;
                    summaryEntry.put("alias", aliasOfIndex);
                    Set<String> existingIndexNames = oss.getIndexNamesWithAlias(aliasOfIndex);
                    if (existingIndexNames.size() > 1) {
                        throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_ACTIVATION_FAILED, "Backup activation failed due to inconsistency. There are ${numberOfIndicesWithAlias} indices with the alias '${alias}': ${indexNames}", MapUtil.mapOf("numberOfIndicesWithAlias", existingIndexNames.size(), "alias", "bpc-configuration", "indexNames", "" + Arrays.asList(existingIndexNames.toArray(new String[0])), "snapshot", snapshotName));
                    }
                    String newIndexName = oss.existsIndex(backupIndexName) ? oss.newIndexNameForAlias(aliasOfIndex) : backupIndexName;
                    LOG.info("Activating backup index '" + backupIndexName + "' to new index '" + newIndexName + "'");
                    snapshotter.restoreSingleSnapshotIndex("bpc_backup", snapshotName, backupIndexName, newIndexName, false);
                    summaryEntry.put("restoredToIndexName", newIndexName);
                    if (existingIndexNames.size() == 1) {
                        String currentIndexName = existingIndexNames.iterator().next();
                        oss.moveAlias(currentIndexName, newIndexName);
                        oss.closeIndex(currentIndexName);
                    } else if (existingIndexNames.size() == 0) {
                        oss.addAliasToIndex(aliasOfIndex, newIndexName);
                    }
                    if ("bpc-configuration".equalsIgnoreCase(aliasOfIndex)) {
                        bl = true;
                        try {
                            indicesMigrator = new BpcIndicesMigrator(oss);
                            indicesMigrator.migrateBpcConfigurationIndex();
                        }
                        catch (IndexMigrationException ex) {
                            LOG.log(Level.SEVERE, "Could not migrate the '" + aliasOfIndex + "' index", ex);
                        }
                        try {
                            this.moduleManagerTracker.getService().reloadAllModules();
                        }
                        catch (SettingException ex) {
                            LOG.log(Level.SEVERE, "Could not reload all modules due to a setting problem.", ex);
                        }
                    } else if ("bpc-notification".equalsIgnoreCase(aliasOfIndex)) {
                        try {
                            indicesMigrator = new BpcIndicesMigrator(oss);
                            indicesMigrator.migrateBpcNotificationIndex();
                        }
                        catch (IndexMigrationException ex) {
                            LOG.log(Level.SEVERE, "Could not migrate the '" + aliasOfIndex + "' index", ex);
                        }
                    }
                } else {
                    if (oss.existsIndex(backupIndexName)) {
                        oss.deleteIndex(backupIndexName);
                    }
                    LOG.info("Activating backup index '" + backupIndexName);
                    snapshotter.restoreSingleSnapshotIndex("bpc_backup", snapshotName, backupIndexName, backupIndexName, false);
                    summaryEntry.put("restoredToIndexName", backupIndexName);
                }
                summary.add(summaryEntry);
            }
        }
        finally {
            if (startEventSent) {
                this.sendBackupRestoreDoneEvent(snapshotName, aliasesOfBackupIndices, summary);
            }
        }
        BackupActivatedInfoImpl backupActivatedInfo = new BackupActivatedInfoImpl(snapshotName, bl ? Boolean.TRUE : Boolean.FALSE);
        clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_ACTIVATED, MapUtil.mapOf("BackupName", backupActivatedInfo.getBackupName(), "BpcConfigurationIndex", backupActivatedInfo.isBpcConfigurationIndex()));
        if (bl) {
            EventManager eventManager = this.eventManagerTracker.getService();
            BroadcastWebsocketMessage broadcastWebsocketMessage = new BroadcastWebsocketMessage(((EventManagerImpl)eventManager).getServerUUID(), LocalDateTime.now(), "BpcConfigurationIndexRestored", null);
            eventManager.fireEvent("de/virtimo/os-bpc-plugin-send-broadcast-message-to-all", "msg", broadcastWebsocketMessage);
        }
        return backupActivatedInfo;
    }

    private boolean sendBackupRestoreStartEvent(String snapshotName, List<String> aliasesOfBackupIndices, List<String> backupIndexNames) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backup/restore/start", DictionaryUtil.dictionaryOf("snapshot", snapshotName, "aliases", aliasesOfBackupIndices, "indices", backupIndexNames));
            return true;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to send the backup restore start event.", ex);
            return false;
        }
    }

    private boolean sendBackupRestoreDoneEvent(String snapshotName, List<String> aliasesOfBackupIndices, List<Map<String, Object>> summary) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backup/restore/done", DictionaryUtil.dictionaryOf("snapshot", snapshotName, "aliases", aliasesOfBackupIndices, "summary", summary));
            return true;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to send the backup restore done event.", ex);
            return false;
        }
    }

    @Override
    public BackupRestoredInfo restoreBackup(String snapshotName, String givenIndexName) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("restoreBackup snapshotName=" + snapshotName + ", givenIndexName=" + givenIndexName);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        ClientSessionManager clientSessionManager = this.clientSessionManagerTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot("bpc_backup", snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException("bpc_backup", snapshotName);
        }
        List<String> indices = snapshotInfo.getIndices();
        if (indices.size() == 1) {
            String restoreToIndexName;
            String backupIndexName = indices.get(0);
            String string = restoreToIndexName = StringUtil.isNullOrEmpty(givenIndexName) ? backupIndexName : givenIndexName;
            if (oss.existsIndex(restoreToIndexName)) {
                throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_RESTORE_FAILED, "Restore not possible. There is already an index with the name '${index}'.", MapUtil.mapOf("index", restoreToIndexName));
            }
            LOG.info("Restoring backup index: " + backupIndexName + " to new index " + restoreToIndexName);
            snapshotter.restoreSingleSnapshotIndex("bpc_backup", snapshotName, backupIndexName, restoreToIndexName, false);
            BackupRestoredInfoImpl backupRestoredInfo = new BackupRestoredInfoImpl(snapshotName, backupIndexName, restoreToIndexName);
            clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_RESTORED, MapUtil.mapOf("BackupName", backupRestoredInfo.getBackupName(), "RestoredFromIndex", backupRestoredInfo.getRestoredFromIndex(), "RestoredToIndex", backupRestoredInfo.getRestoredToIndex()));
            return backupRestoredInfo;
        }
        for (String index : indices) {
            if (!oss.existsIndex(index)) continue;
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_RESTORE_FAILED, "Restore not possible. There is already an index with the name '${index}'.", MapUtil.mapOf("index", index));
        }
        try {
            snapshotter.restoreAllSnapshotIndices("bpc_backup", snapshotName, false);
            BackupRestoredInfoImpl backupRestoredInfo = new BackupRestoredInfoImpl(snapshotName);
            clientSessionManager.sendToUserRolesByWebsocketAsync(SetUtil.setOf("bpcadmin"), BACKUP_EVENT_TOPIC_RESTORED, MapUtil.mapOf("BackupName", backupRestoredInfo.getBackupName()));
            return backupRestoredInfo;
        }
        catch (OpenSearchRelatedException ex) {
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_RESTORE_FAILED, "Could not restore the indices of the snapshot '${snapshotName}'.", MapUtil.mapOf("snapshotName", snapshotName), (Throwable)ex);
        }
    }

    @Override
    public StreamingOutput downloadSnapshotContent(String snapshotName) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("downloadSnapshotContent snapshotName=" + snapshotName);
        final OpenSearchService oss = this.openSearchServiceTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot("bpc_backup", snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException("bpc_backup", snapshotName);
        }
        List<String> indices = snapshotInfo.getIndices();
        final TemporaryIndices temporaryIndices = new TemporaryIndices(oss, indices);
        if (temporaryIndices.existsAtLeastOneOfThem()) {
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Download not possible. There is already an index with the temporary name '${index}'.", MapUtil.mapOf("index", temporaryIndices.getNameOfExistingTmpIndex()));
        }
        LOG.info("Temporary restoring backup indices ...");
        try {
            snapshotter.restoreSnapshotIndices("bpc_backup", snapshotName, "(.+)", temporaryIndices.getPrefix() + "$1", false);
        }
        catch (Exception ex) {
            temporaryIndices.deleteAll();
            throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Download not possible. Could not restore the content to temporary indices.", ex);
        }
        return new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
                BufferedWriter bw = null;
                int i = 0;
                try {
                    RestHighLevelClient osClient = oss.getClient();
                    bw = new BufferedWriter(new OutputStreamWriter(outputStream));
                    bw.write("[");
                    bw.newLine();
                    for (String tmpIndexName : temporaryIndices) {
                        String indexName = temporaryIndices.getIndexName(tmpIndexName);
                        SearchRequest searchReq = new SearchRequest().indices(tmpIndexName).scroll(new TimeValue(60000L)).source(new SearchSourceBuilder().size(500).query(QueryBuilders.matchAllQuery()));
                        SearchResponse searchResponse = osClient.search(searchReq, RequestOptions.DEFAULT);
                        long totalCount = searchResponse.getHits().getTotalHits().value;
                        bw.write("  {");
                        bw.newLine();
                        bw.write("    \"index\": \"" + indexName + "\"");
                        bw.write(",");
                        bw.newLine();
                        bw.write("    \"totalCount\": " + totalCount);
                        bw.write(",");
                        bw.newLine();
                        bw.write("    \"data\": ");
                        bw.write("[");
                        bw.newLine();
                        int rowIdx = 0;
                        do {
                            for (SearchHit hit : searchResponse.getHits().getHits()) {
                                Map<String, Object> sourceValues = hit.getSourceAsMap();
                                bw.write("      ");
                                bw.write(mapper.writeValueAsString(sourceValues));
                                if ((long)(++rowIdx) < totalCount) {
                                    bw.write(",");
                                    bw.newLine();
                                }
                                if (rowIdx % 5000 != 0) continue;
                                bw.flush();
                            }
                        } while ((searchResponse = osClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT)).getHits().getHits().length != 0);
                        oss.releaseScrollId(searchResponse);
                        bw.newLine();
                        bw.write("    ]");
                        bw.newLine();
                        bw.write("  }");
                        if (++i >= temporaryIndices.size()) continue;
                        bw.write(",");
                        bw.newLine();
                    }
                    bw.newLine();
                    bw.write("]");
                }
                catch (IOException | OpenSearchException ex) {
                    LOG.log(Level.SEVERE, "Failed to read the index content.", ex);
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Could not write the index content to the download stream.", ex);
                }
                finally {
                    if (mapper != null) {
                        ObjectMapperPool.getInstance().restore((Object)mapper);
                    }
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (Exception ex) {}
                    }
                    temporaryIndices.deleteAll();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalConfig exportBpcConfiguration(String snapshotName) throws BackupException, BackupConflictException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("exportBpcConfiguration snapshotName=" + snapshotName);
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Snapshotter snapshotter = new Snapshotter(oss);
        BackupSnapshotInfo snapshotInfo = snapshotter.getSnapshot("bpc_backup", snapshotName);
        if (snapshotInfo == null) {
            throw new BackupNotFoundException("bpc_backup", snapshotName);
        }
        List<String> indices = snapshotInfo.getIndices();
        if (indices.size() != 1 || !indices.get(0).startsWith("bpc-configuration")) {
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Export not possible. Only snapshots of the bpc-configuration index can be exported.");
        }
        String bpcConfigurationIndexName = indices.get(0);
        TemporaryIndices temporaryIndices = new TemporaryIndices(oss, indices);
        if (temporaryIndices.existsAtLeastOneOfThem()) {
            throw new BackupConflictException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Export not possible. There is already an index with the temporary name '${index}'.", MapUtil.mapOf("index", temporaryIndices.getNameOfExistingTmpIndex()));
        }
        String restoredBpcConfigurationIndexName = temporaryIndices.getTmpIndexName(bpcConfigurationIndexName);
        try {
            LOG.info("Temporary restoring backup indices ...");
            try {
                snapshotter.restoreSnapshotIndices("bpc_backup", snapshotName, "(.+)", temporaryIndices.getPrefix() + "$1", false);
            }
            catch (OpenSearchRelatedException ex) {
                throw new BackupException((ErrorCode)CoreErrorCode.BACKUP_DOWNLOAD_FAILED, "Download not possible. Could not restore the content to temporary indices.", ex);
            }
            int modelVersion = oss.getModelVersion(restoredBpcConfigurationIndexName);
            BpcIndexInfo restoredBpcIndexInfo = oss.getBpcIndexInfoUsingIndexName(restoredBpcConfigurationIndexName);
            List<Setting> allSettings = ModuleConfigurationPersistenceHandler.readAllSettingsFromBpcConfigurationIndex(oss, restoredBpcConfigurationIndexName);
            SettingsBasedConfigImpl settingsBasedConfigImpl = new SettingsBasedConfigImpl(this.moduleManagerTracker.getService(), restoredBpcIndexInfo, modelVersion, allSettings);
            return settingsBasedConfigImpl;
        }
        catch (BackupException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to read the settings from the temporarily restored bpc-configuration index: " + restoredBpcConfigurationIndexName, ex);
        }
        finally {
            temporaryIndices.deleteAll();
        }
        return null;
    }

    private static class TemporaryIndices
    implements Iterable<String> {
        private final OpenSearchService oss;
        private final Map<String, String> tmpIndexNames;
        private final String prefix;
        private static long prefixCounter = 0L;
        private String existingIndexName;

        TemporaryIndices(OpenSearchService oss, List<String> indices) {
            this.oss = oss;
            this.prefix = "tmp_backup_restore_index_" + TemporaryIndices.getNextPrefixCounter() + "_";
            this.tmpIndexNames = this.createTmpIndexNames(indices);
        }

        private static synchronized long getNextPrefixCounter() {
            if (prefixCounter == Long.MAX_VALUE) {
                prefixCounter = 0L;
            }
            return ++prefixCounter;
        }

        String getPrefix() {
            return this.prefix;
        }

        private String createTmpIndexName(String indexName) {
            return this.prefix + indexName;
        }

        private Map<String, String> createTmpIndexNames(List<String> indices) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (indices != null) {
                for (String index : indices) {
                    result.put(index, this.createTmpIndexName(index));
                }
            }
            return result;
        }

        @Override
        @NotNull
        public Iterator<String> iterator() {
            return this.tmpIndexNames.values().iterator();
        }

        int size() {
            return this.tmpIndexNames.size();
        }

        String getTmpIndexName(String indexName) {
            return this.tmpIndexNames.get(indexName);
        }

        String getIndexName(String temporaryIndexName) {
            for (Map.Entry<String, String> indexAndTmpIndexNames : this.tmpIndexNames.entrySet()) {
                String indexName = indexAndTmpIndexNames.getKey();
                String tmpIndexName = indexAndTmpIndexNames.getValue();
                if (!tmpIndexName.equals(temporaryIndexName)) continue;
                return indexName;
            }
            return null;
        }

        boolean existsAtLeastOneOfThem() throws OpenSearchRelatedException {
            LOG.info("existsAtLeastOneOfThem");
            for (String tmpIndexName : this.tmpIndexNames.values()) {
                if (!this.oss.existsIndex(tmpIndexName)) continue;
                this.existingIndexName = tmpIndexName;
                return true;
            }
            return false;
        }

        String getNameOfExistingTmpIndex() {
            return this.existingIndexName;
        }

        void deleteAll() {
            LOG.info("deleteAll");
            for (String tmpIndexName : this.tmpIndexNames.values()) {
                try {
                    this.oss.deleteIndex(tmpIndexName);
                }
                catch (Throwable ex) {
                    LOG.log(Level.SEVERE, "Failed to delete the temporary index: " + tmpIndexName, ex);
                }
            }
        }
    }
}

