/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotState;

public class BackupSnapshotInfoImpl
implements BackupSnapshotInfo {
    private final String name;
    private final String startTime;
    private final long startTimeInMillis;
    private final String endTime;
    private final long endTimeInMillis;
    private final SnapshotState state;
    private final List<String> indices;
    private final boolean bpcConfigurationIndex;

    public BackupSnapshotInfoImpl(SnapshotInfo snapshotInfo) {
        this.name = snapshotInfo.snapshotId().getName();
        this.startTime = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(snapshotInfo.startTime()));
        this.startTimeInMillis = snapshotInfo.startTime();
        this.endTime = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(snapshotInfo.endTime()));
        this.endTimeInMillis = snapshotInfo.endTime();
        this.state = snapshotInfo.state();
        this.indices = snapshotInfo.indices();
        this.bpcConfigurationIndex = snapshotInfo.indices() != null && snapshotInfo.indices().size() == 1 && snapshotInfo.indices().get(0).startsWith("bpc-configuration");
    }

    public BackupSnapshotInfoImpl(String name, String startTime, long startTimeInMillis, String endTime, long endTimeInMillis, SnapshotState state, List<String> indices, boolean bpcConfigurationIndex) {
        this.name = name;
        this.startTime = startTime;
        this.startTimeInMillis = startTimeInMillis;
        this.endTime = endTime;
        this.endTimeInMillis = endTimeInMillis;
        this.state = state;
        this.indices = indices;
        this.bpcConfigurationIndex = bpcConfigurationIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStartTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Override
    public String getEndTime() {
        return this.endTime;
    }

    @Override
    public long getEndTimeInMillis() {
        return this.endTimeInMillis;
    }

    @Override
    public SnapshotState getState() {
        return this.state;
    }

    @Override
    public List<String> getIndices() {
        return this.indices;
    }

    @Override
    public boolean isBpcConfigurationIndex() {
        return this.bpcConfigurationIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupSnapshotInfoImpl that = (BackupSnapshotInfoImpl)o;
        return this.startTimeInMillis == that.startTimeInMillis && this.endTimeInMillis == that.endTimeInMillis && this.bpcConfigurationIndex == that.bpcConfigurationIndex && this.name.equals(that.name) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && this.state == that.state && Objects.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.startTime, this.startTimeInMillis, this.endTime, this.endTimeInMillis, this.state, this.indices, this.bpcConfigurationIndex});
    }
}

