/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.exception.BackupIndexNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.backup.exception.BackupRepositoryNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.backup.BackupSnapshotInfoImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.opensearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.opensearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.rest.RestStatus;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotMissingException;

public class Snapshotter {
    private static final Logger LOG = Logger.getLogger(Snapshotter.class.getName());
    private final OpenSearchService oss;

    public Snapshotter(OpenSearchService oss) {
        this.oss = oss;
    }

    private void throwConvertedOpenSearchException(OpenSearchException ex, String repositoryName) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        if (ex instanceof OpenSearchStatusException) {
            if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("repository_missing_exception")) {
                Throwable cause = ex.getCause();
                if (cause instanceof OpenSearchException) {
                    throw new BackupRepositoryNotFoundException(repositoryName, (OpenSearchException)cause);
                }
                throw new BackupRepositoryNotFoundException(repositoryName, ex);
            }
            throw new OpenSearchRelatedException(ex);
        }
        throw new OpenSearchRelatedException(ex);
    }

    public boolean existsBackupRepository(String repositoryName) throws OpenSearchRelatedException {
        LOG.info("existsBackupRepository: repositoryName=" + repositoryName);
        try {
            GetRepositoriesRequest req = new GetRepositoriesRequest();
            GetRepositoriesResponse resp = this.oss.getClient().snapshot().getRepository(req, RequestOptions.DEFAULT);
            for (RepositoryMetadata repository : resp.repositories()) {
                if (!repository.name().equalsIgnoreCase(repositoryName)) continue;
                LOG.info("existsBackupRepository: YES");
                return true;
            }
            LOG.info("existsBackupRepository: NO");
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        return false;
    }

    public void createBackupRepository(String repositoryName, String backupFolderName) throws OpenSearchRelatedException {
        LOG.info("createBackupRepository: repositoryName=" + repositoryName + ", backupFolderName=" + backupFolderName);
        try {
            Settings settings = Settings.builder().put("location", backupFolderName).put("compress", true).build();
            PutRepositoryRequest req = new PutRepositoryRequest(repositoryName).type("fs").settings(settings);
            this.oss.getClient().snapshot().createRepository(req, RequestOptions.DEFAULT);
        }
        catch (OpenSearchStatusException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof OpenSearchException) {
                throw new OpenSearchRelatedException((OpenSearchException)cause);
            }
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public List<BackupSnapshotInfo> getAllSnapshots(String repositoryName) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOG.info("getAllSnapshots repositoryName=" + repositoryName);
        try {
            GetSnapshotsRequest req = new GetSnapshotsRequest(repositoryName);
            GetSnapshotsResponse resp = this.oss.getClient().snapshot().get(req, RequestOptions.DEFAULT);
            List<SnapshotInfo> snapshotInfos = resp.getSnapshots();
            if (snapshotInfos != null) {
                ArrayList<BackupSnapshotInfo> result = new ArrayList<BackupSnapshotInfo>();
                for (SnapshotInfo snapshotInfo : snapshotInfos) {
                    result.add(new BackupSnapshotInfoImpl(snapshotInfo));
                }
                return result;
            }
        }
        catch (OpenSearchException ex) {
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        return null;
    }

    public List<BackupSnapshotInfo> getAllSnapshotsWithPrefix(String repositoryName, String snapshotNamePrefix) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOG.info("getAllSnapshotsWithPrefix repositoryName=" + repositoryName + ", snapshotNamePrefix=" + snapshotNamePrefix);
        List<BackupSnapshotInfo> allSnapshots = this.getAllSnapshots(repositoryName);
        ArrayList<BackupSnapshotInfo> result = new ArrayList<BackupSnapshotInfo>();
        for (BackupSnapshotInfo snapshot : allSnapshots) {
            if (!snapshot.getName().startsWith(snapshotNamePrefix)) continue;
            result.add(snapshot);
        }
        return result;
    }

    public BackupSnapshotInfo getSnapshot(String repositoryName, String snapshot) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        BackupSnapshotInfoImpl result;
        block5: {
            LOG.info("getSnapshot repositoryName=" + repositoryName + ", snapshot:" + snapshot);
            result = null;
            try {
                GetSnapshotsRequest req = new GetSnapshotsRequest(repositoryName).snapshots(new String[]{snapshot});
                GetSnapshotsResponse resp = this.oss.getClient().snapshot().get(req, RequestOptions.DEFAULT);
                List<SnapshotInfo> snapshotInfos = resp.getSnapshots();
                if (snapshotInfos != null && snapshotInfos.size() == 1) {
                    result = new BackupSnapshotInfoImpl(snapshotInfos.get(0));
                }
            }
            catch (IOException ex) {
                throw new OpenSearchRelatedException(ex);
            }
            catch (SnapshotMissingException ex) {
            }
            catch (OpenSearchException ex) {
                if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot_missing_exception")) break block5;
                this.throwConvertedOpenSearchException(ex, repositoryName);
            }
        }
        return result;
    }

    public long getTimestampOfLatestSnapshot(List<BackupSnapshotInfo> snapshots) {
        LOG.info("getTimestampOfLatestSnapshot snapshots=...");
        long result = 0L;
        for (BackupSnapshotInfo snapshot : snapshots) {
            if (snapshot.getStartTimeInMillis() <= result) continue;
            result = snapshot.getStartTimeInMillis();
        }
        return result;
    }

    @NotNull
    public List<BackupSnapshotInfo> deleteOldSnapshots(@NotNull String repositoryName, List<BackupSnapshotInfo> snapshots, long keepBackupsDurationInSeconds) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOG.info("deleteOldSnapshots repositoryName=" + repositoryName + ", snapshots=..., keepBackupsDurationInSeconds=" + keepBackupsDurationInSeconds);
        ArrayList<BackupSnapshotInfo> result = new ArrayList<BackupSnapshotInfo>();
        if (snapshots != null) {
            for (BackupSnapshotInfo snapshot : snapshots) {
                if (snapshot.getStartTimeInMillis() >= System.currentTimeMillis() - keepBackupsDurationInSeconds * 1000L) continue;
                try {
                    this.deleteSnapshot(repositoryName, snapshot.getName());
                    result.add(snapshot);
                }
                catch (BackupNotFoundException backupNotFoundException) {}
            }
        }
        return result;
    }

    public void deleteSnapshot(@NotNull String repositoryName, String snapshotName) throws BackupRepositoryNotFoundException, BackupNotFoundException, OpenSearchRelatedException {
        LOG.info("deleteSnapshot: repositoryName=" + repositoryName + ", snapshotName=" + snapshotName);
        try {
            DeleteSnapshotRequest req = new DeleteSnapshotRequest(repositoryName, snapshotName);
            this.oss.getClient().snapshot().delete(req, RequestOptions.DEFAULT);
        }
        catch (OpenSearchException ex) {
            if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot_missing_exception")) {
                throw new BackupNotFoundException(repositoryName, snapshotName);
            }
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public BackupSnapshotInfo createSnapshot(String repositoryName, String snapshotName, Set<String> indices) throws BackupRepositoryNotFoundException, OpenSearchRelatedException {
        LOG.info("createSnapshot: repositoryName=" + repositoryName + ", snapshotName=" + snapshotName + ", indices=" + indices);
        try {
            HashSet<String> existingIndices = new HashSet<String>();
            for (String index : indices) {
                if (this.oss.existsIndex(index)) {
                    existingIndices.add(index);
                    continue;
                }
                LOG.log(Level.WARNING, "The index '" + index + "' to backup does not exist. It will not be in the OpenSearch snapshot '" + snapshotName + "'.");
            }
            if (!existingIndices.isEmpty()) {
                CreateSnapshotRequest req = new CreateSnapshotRequest(repositoryName, snapshotName).waitForCompletion(true).indices(existingIndices.toArray(new String[0]));
                CreateSnapshotResponse resp = this.oss.getClient().snapshot().create(req, RequestOptions.DEFAULT);
                LOG.info("Snapshot created: " + resp.status());
                SnapshotInfo snapshotInfo = resp.getSnapshotInfo();
                return snapshotInfo == null ? null : new BackupSnapshotInfoImpl(snapshotInfo);
            }
            LOG.log(Level.WARNING, "Failed to create the snapshot '" + snapshotName + "'. None of the indices to backup exists: " + indices);
        }
        catch (OpenSearchException ex) {
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        return null;
    }

    public void restoreSnapshotIndices(String repositoryName, String snapshotName, String renamePattern, String renameReplacement, boolean includeAlias) throws BackupRepositoryNotFoundException, BackupNotFoundException, OpenSearchRelatedException {
        LOG.info("restoreSnapshotIndices repositoryName=" + repositoryName + ", snapshotName=" + snapshotName + ", renamePattern=" + renamePattern + ", renameReplacement=" + renameReplacement + ", includeAlias=" + includeAlias);
        try {
            RestoreSnapshotRequest req = new RestoreSnapshotRequest(repositoryName, snapshotName).renamePattern(renamePattern).renameReplacement(renameReplacement).includeAliases(includeAlias).waitForCompletion(true);
            RestoreSnapshotResponse resp = this.oss.getClient().snapshot().restore(req, RequestOptions.DEFAULT);
            LOG.info("Snapshot restored: " + resp.status());
        }
        catch (OpenSearchException ex) {
            if (RestStatus.INTERNAL_SERVER_ERROR.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot does not exist")) {
                throw new BackupNotFoundException(repositoryName, snapshotName);
            }
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public void restoreSingleSnapshotIndex(String repositoryName, String snapshotName, String snapshotIndexName, String newIndexName, boolean includeAlias) throws BackupRepositoryNotFoundException, BackupNotFoundException, BackupIndexNotFoundException, OpenSearchRelatedException {
        LOG.info("restoreSingleSnapshotIndex repositoryName=" + repositoryName + ", snapshotName=" + snapshotName + ", snapshotIndexName=" + snapshotIndexName + ", newIndexName=" + newIndexName + ", includeAlias=" + includeAlias);
        try {
            RestoreSnapshotRequest req = new RestoreSnapshotRequest(repositoryName, snapshotName).indices(snapshotIndexName).renamePattern(snapshotIndexName).renameReplacement(newIndexName).includeAliases(includeAlias).waitForCompletion(true);
            RestoreSnapshotResponse resp = this.oss.getClient().snapshot().restore(req, RequestOptions.DEFAULT);
            LOG.info("Snapshot restored: " + resp.status());
        }
        catch (OpenSearchException ex) {
            if (RestStatus.INTERNAL_SERVER_ERROR.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot does not exist")) {
                throw new BackupNotFoundException(repositoryName, snapshotName);
            }
            if (RestStatus.NOT_FOUND.getStatus() == ex.status().getStatus() && ex.getMessage().contains("index_not_found_exception")) {
                throw new BackupIndexNotFoundException(repositoryName, snapshotName, snapshotIndexName);
            }
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public void restoreAllSnapshotIndices(String repositoryName, String snapshotName, boolean includeAlias) throws BackupRepositoryNotFoundException, BackupNotFoundException, OpenSearchRelatedException {
        LOG.info("restoreAllSnapshotIndices repositoryName=" + repositoryName + ", snapshotName=" + snapshotName + ", includeAlias=" + includeAlias);
        try {
            RestoreSnapshotRequest req = new RestoreSnapshotRequest(repositoryName, snapshotName).includeAliases(includeAlias).waitForCompletion(true);
            RestoreSnapshotResponse resp = this.oss.getClient().snapshot().restore(req, RequestOptions.DEFAULT);
            LOG.info("Snapshot restored: " + resp.status());
        }
        catch (OpenSearchException ex) {
            if (RestStatus.INTERNAL_SERVER_ERROR.getStatus() == ex.status().getStatus() && ex.getMessage().contains("snapshot does not exist")) {
                throw new BackupNotFoundException(repositoryName, snapshotName);
            }
            this.throwConvertedOpenSearchException(ex, repositoryName);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }
}

