/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.bom;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.BomCollectorService;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;

@Path(value="bom")
public class BomEndpoints {
    private static final Logger LOG = Logger.getLogger(BomEndpoints.class.getName());
    private final BundleContext bundleContext;
    private BpcServicesTracker<BomCollectorService> bomCollectorServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public BomEndpoints(BundleContext bundleContext) {
        LOG.info("BomEndpoints bundleContext=...");
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.bomCollectorServiceTracker = new BpcServicesTracker<BomCollectorService>(this.bundleContext, BomCollectorService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @DELETE
    @Path(value="/")
    @BpcRoleOrRightRequired(role="BOMS_ADMIN", right="BOMS_RELOAD", message="You are not allowed to force a BOMs re-load.")
    public Response forceBomsReload(@Context HttpHeaders hh) {
        LOG.info("forceBomsReload");
        try {
            this.bomCollectorServiceTracker.getService().forceReload();
            return Response.ok().build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    public Response getAll(@Context HttpHeaders hh) {
        LOG.info("getAll");
        try {
            return Response.ok(this.bomCollectorServiceTracker.getService().getAllBoms(), (String)"application/json").build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bundles")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    public Response getSymbolicNamesOfBundlesWithBoms(@Context HttpHeaders hh) {
        LOG.info("getSymbolicNamesOfBundlesWithBoms");
        try {
            return Response.ok(this.bomCollectorServiceTracker.getService().getSymbolicNamesOfBundles()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bundle/{symbolicNameOfBundle}")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    public Response getBom(@PathParam(value="symbolicNameOfBundle") String symbolicNameOfBundle, @Context HttpHeaders hh) {
        LOG.info("getBom symbolicNameOfBundle=" + symbolicNameOfBundle);
        try {
            return Response.ok(this.bomCollectorServiceTracker.getService().getBom(symbolicNameOfBundle)).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

