/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.datalock;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.datalock.DataLockService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.BundleContext;

public class DataLockServiceImpl
implements DataLockService,
BpcService {
    private static final Logger LOG = Logger.getLogger(DataLockServiceImpl.class.getName());
    private static final String INDEX_NAME = "bpc-datalock";
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;

    public DataLockServiceImpl(BundleContext bundleContext) {
        LOG.info("DataLockServiceImpl bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public SearchResponse getAllItems(Integer start, Integer limit) throws ServiceNotFoundException, OpenSearchRelatedException, SystemException {
        SearchResponse searchResponse;
        LOG.info("getAllItems start=" + start + ", limit=" + limit);
        try {
            RestHighLevelClient osClient = this.openSearchServiceTracker.getService().getClient();
            SearchRequest searchRequest = new SearchRequest().indices(INDEX_NAME).source(new SearchSourceBuilder().from(start).size(limit));
            searchResponse = osClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in getAllItems(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new OpenSearchRelatedException(ex);
        }
        return searchResponse;
    }

    @Override
    public GetResponse getItem(String itemId) throws ServiceNotFoundException, OpenSearchRelatedException, SystemException {
        GetResponse response;
        LOG.info("getItem itemId=" + itemId);
        try {
            RestHighLevelClient osClient = this.openSearchServiceTracker.getService().getClient();
            GetRequest getRequest = ((GetRequest)new GetRequest().index(INDEX_NAME)).id(itemId);
            response = osClient.get(getRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in getItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new OpenSearchRelatedException(ex);
        }
        if (response.isExists()) {
            return response;
        }
        throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_ITEM_NOT_FOUND, "Did not find the data lock item '${itemId}' in the index '${indexName}'.", MapUtil.mapOf("itemId", itemId, "indexName", INDEX_NAME));
    }

    @Override
    public void createItem(String itemId, String jsonData) throws ServiceNotFoundException, OpenSearchRelatedException, SystemException {
        LOG.info("createItem itemId=" + itemId + ", jsonData=" + jsonData);
        try {
            RestHighLevelClient osClient = this.openSearchServiceTracker.getService().getClient();
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(INDEX_NAME)).id(itemId).source(jsonData, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            osClient.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in createItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public void updateItem(String itemId, String jsonData) throws ServiceNotFoundException, OpenSearchRelatedException, SystemException {
        LOG.info("updateItem itemId=" + itemId + ", jsonData=" + jsonData);
        try {
            RestHighLevelClient osClient = this.openSearchServiceTracker.getService().getClient();
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(INDEX_NAME)).id(itemId).source(jsonData, XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            osClient.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (MapperParsingException ex) {
            LOG.warning("bpc-datalock: OpenSearch mapping mismatch while indexing the data lock value: " + jsonData);
            throw ex;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in updateItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public void deleteItem(String itemId) throws ServiceNotFoundException, OpenSearchRelatedException, SystemException {
        DeleteResponse deleteResponse;
        LOG.info("deleteItem itemId=" + itemId);
        try {
            RestHighLevelClient osClient = this.openSearchServiceTracker.getService().getClient();
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(INDEX_NAME)).id(itemId);
            deleteResponse = osClient.delete(deleteRequest, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_INDEX_NOT_FOUND, "Did not find the data lock index '${indexName}'.", MapUtil.mapOf("indexName", INDEX_NAME));
            }
            LOG.log(Level.SEVERE, "Unhandled exception in deleteItem(). Please report the occurred RestStatus '" + ex.status() + "' to the BPC developers.", ex);
            throw new OpenSearchRelatedException(ex);
        }
        if (deleteResponse.status() == RestStatus.NOT_FOUND) {
            throw new SystemException((ErrorCode)CoreErrorCode.DATA_LOCK_ITEM_NOT_FOUND, "Did not find the data lock item '${itemId}' in the index '${indexName}'.", MapUtil.mapOf("itemId", itemId, "indexName", INDEX_NAME));
        }
    }
}

