/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DeploymentConstraintsEnricher {
    private static final Logger LOG = Logger.getLogger(DeploymentConstraintsEnricher.class.getName());
    private final Map deploymentSetting;

    public DeploymentConstraintsEnricher(List<Map> deploymentSettingsOfModules) throws IOException {
        Map mergedDeploymentSetting = null;
        if (deploymentSettingsOfModules != null && !deploymentSettingsOfModules.isEmpty()) {
            for (Map deploymentSettingOfModule : deploymentSettingsOfModules) {
                Map deploymentConstraintsOfModule;
                if (mergedDeploymentSetting == null) {
                    mergedDeploymentSetting = MapUtil.deepCopy(deploymentSettingOfModule);
                    continue;
                }
                Map mergedDeploymentConstraints = (Map)mergedDeploymentSetting.get("deploymentConstraints");
                List mergedWarnings = (List)mergedDeploymentConstraints.get("warning");
                if (!deploymentSettingOfModule.containsKey("deploymentConstraints") || !(deploymentConstraintsOfModule = (Map)deploymentSettingOfModule.get("deploymentConstraints")).containsKey("warning")) continue;
                List warningsOfModule = (List)deploymentConstraintsOfModule.get("warning");
                mergedWarnings.addAll(warningsOfModule);
            }
        }
        this.deploymentSetting = mergedDeploymentSetting;
    }

    public void enrich(Map<String, Object> modulesConfig) {
        Map deploymentConstraints;
        if (this.deploymentSetting != null && this.deploymentSetting.containsKey("deploymentConstraints") && (deploymentConstraints = (Map)this.deploymentSetting.get("deploymentConstraints")).containsKey("warning")) {
            List warnings = (List)deploymentConstraints.get("warning");
            for (Map warning : warnings) {
                if (!warning.containsKey("module")) continue;
                String module = (String)warning.get("module");
                String instanceType = (String)warning.get("instanceType");
                List settings = (List)warning.get("settings");
                this.enrichModulesConfig(modulesConfig, module, instanceType, settings);
            }
        }
    }

    private void enrichModulesConfig(Map<String, Object> modulesConfig, String moduleId, String instanceType, List<String> namesOfCriticalSettings) {
        LOG.info("enrichModulesConfig modulesConfig=..., moduleId=" + moduleId + ", instanceType=" + instanceType + ", namesOfCriticalSettings=" + namesOfCriticalSettings);
        if (modulesConfig != null && modulesConfig.containsKey("modules")) {
            List modules = (List)modulesConfig.get("modules");
            for (Map module : modules) {
                if (!moduleId.equals(module.get("moduleId"))) continue;
                if (namesOfCriticalSettings == null) {
                    this.enrichModule(module);
                    continue;
                }
                if (instanceType == null) {
                    this.enrichModuleSettings(module, namesOfCriticalSettings);
                    continue;
                }
                this.enrichModuleInstanceSettings(module, instanceType, namesOfCriticalSettings);
            }
        }
    }

    private void enrichModule(Map<String, Object> module) {
        LOG.info("enrichModules module=...");
        if (module != null) {
            module.put("_deploymentConstraint", "warning");
        }
    }

    private void enrichModuleSettings(Map<String, Object> module, List<String> namesOfCriticalSettings) {
        LOG.info("enrichModuleSettings module=..., namesOfCriticalSettings=" + namesOfCriticalSettings);
        if (module != null) {
            module.put("_deploymentConstraint", "warning");
            if (module.containsKey("settings")) {
                List moduleSettings = (List)module.get("settings");
                for (Map moduleSetting : moduleSettings) {
                    if (!namesOfCriticalSettings.contains(moduleSetting.get("name"))) continue;
                    moduleSetting.put("_deploymentConstraint", "warning");
                }
            }
        }
    }

    private void enrichModuleInstanceSettings(Map<String, Object> module, String instanceType, List<String> namesOfCriticalSettings) {
        LOG.info("enrichModuleInstanceSettings module=..., instanceType=" + instanceType + ", namesOfCriticalSettings=" + namesOfCriticalSettings);
        if (module != null && module.containsKey("instances")) {
            List instances = (List)module.get("instances");
            for (Map instance : instances) {
                if (!instance.containsKey("instanceType") || !instanceType.equals(instance.get("instanceType"))) continue;
                instance.put("_deploymentConstraint", "warning");
                if (!instance.containsKey("settings")) continue;
                List moduleInstanceSettings = (List)instance.get("settings");
                for (Map moduleInstanceSetting : moduleInstanceSettings) {
                    if (!namesOfCriticalSettings.contains(moduleInstanceSetting.get("name"))) continue;
                    moduleInstanceSetting.put("_deploymentConstraint", "warning");
                }
            }
        }
    }
}

