/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Checker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.deployment.DeploymentManager;
import de.virtimo.bpc.api.deployment.exception.DeploymentException;
import de.virtimo.bpc.api.deployment.resource.DeleteSettingOperation;
import de.virtimo.bpc.api.deployment.resource.DeploymentData;
import de.virtimo.bpc.api.exception.ModuleInstanceCreateException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotInstantiableException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.deployment.DeploymentImporterSession;
import de.virtimo.bpc.core.deployment.DeploymentInitiatorImpl;
import de.virtimo.bpc.core.deployment.resource.DeploymentDataImpl;
import de.virtimo.bpc.core.utils.FelixFileinstallUtil;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class DeploymentImporter
implements Checker {
    private static final Logger LOG = Logger.getLogger(DeploymentImporter.class.getName());
    private static final int DEPLOYMENT_FOLDER_CHECK_RUNS_EVERY_SECONDS = 3;
    private static final String DEPLOYMENT_FILE_EXTENSION = ".bpc-deployment-export";
    private static final String DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_INVALID = ".invalid_json";
    private static final String DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_EMPTY = ".empty";
    private static final String DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_ERROR = ".error";
    private static final String DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_ERROR_ON_IMPORT = ".error_on_import";
    private static final String DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_PROCESSED = ".processed";
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> checkerHandle;
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<DeploymentManager> deploymentManagerTracker;
    private BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private boolean importIsAlreadyRunning = false;

    public DeploymentImporter(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void startChecker() {
        LOG.info("startChecker");
        if (this.checkerHandle != null) {
            LOG.warning("Deployment importer is already running");
            return;
        }
        BpcServicesTracker.stopAll(this);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.deploymentManagerTracker = new BpcServicesTracker<DeploymentManager>(this.bundleContext, DeploymentManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(this.bundleContext, CoreBundleConfiguration.class);
        try {
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-deployment-importer"));
            this.checkerHandle = this.executorService.scheduleWithFixedDelay(this.createCheckerRunnable(), 0L, 3L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to start the deployment importer.", ex);
        }
    }

    @Override
    public void stopChecker() {
        LOG.info("stopChecker");
        if (this.checkerHandle != null) {
            if (this.checkerHandle.cancel(true)) {
                LOG.info("Running deployment importer cancelled");
            } else {
                LOG.warning("Could not cancel the running deployment importer");
            }
            this.checkerHandle = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        BpcServicesTracker.stopAll(this);
    }

    private Runnable createCheckerRunnable() {
        LOG.info("createCheckerRunnable");
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (!DeploymentImporter.this.importIsAlreadyRunning) {
                    DeploymentImporter.this.importIsAlreadyRunning = true;
                    try {
                        File[] deploymentExportFiles = DeploymentImporter.this.getDeploymentExportFilesFromKarafDeployFolder();
                        if (deploymentExportFiles == null) return;
                        for (File deploymentExportFile : deploymentExportFiles) {
                            if (!DeploymentImporter.this.canImportFile(deploymentExportFile)) continue;
                            try {
                                DeploymentImporter.this.importFile(deploymentExportFile);
                                DeploymentImporter.this.renameFile(deploymentExportFile, DeploymentImporter.DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_PROCESSED);
                            }
                            catch (Exception ex) {
                                LOG.log(Level.SEVERE, "Deployment import of file '" + deploymentExportFile + "' failed.", ex);
                                DeploymentImporter.this.renameFile(deploymentExportFile, DeploymentImporter.DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_ERROR_ON_IMPORT);
                            }
                        }
                        return;
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Failed to perform the deployment importer.", t);
                        return;
                    }
                    finally {
                        DeploymentImporter.this.importIsAlreadyRunning = false;
                    }
                } else {
                    LOG.info("Skipping ... a deployment importer is already running.");
                }
            }
        };
    }

    private File[] getDeploymentExportFilesFromKarafDeployFolder() throws ServiceNotFoundException, InvalidSyntaxException, IOException {
        LOG.info("getDeploymentExportFilesFromKarafDeployFolder");
        File deployFolder = FelixFileinstallUtil.getDeployFolder(this.bundleContext);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return name.endsWith(DeploymentImporter.DEPLOYMENT_FILE_EXTENSION);
            }
        };
        return deployFolder.listFiles(filter);
    }

    private boolean renameFile(File deploymentExportFile, String fileExtensionPostfix) {
        LOG.info("renameFile deploymentExportFile=" + deploymentExportFile + ", fileExtensionPostfix=" + fileExtensionPostfix);
        File processedDeploymentExportFile = new File(deploymentExportFile.getAbsolutePath() + fileExtensionPostfix);
        return deploymentExportFile.renameTo(processedDeploymentExportFile);
    }

    private boolean canImportFile(File deploymentExportFile) {
        DeploymentData deploymentData;
        LOG.info("canImportFile deploymentExportFile=" + deploymentExportFile);
        try {
            deploymentData = JsonUtil.getInstance().convertJsonFileToPojo(deploymentExportFile, DeploymentDataImpl.class);
            if (!deploymentData.hasSettingsToDeploy()) {
                LOG.info("The given deployment file '" + deploymentExportFile + "' does not contain any settings related data. Renaming the file so that it does not get processed again.");
                this.renameFile(deploymentExportFile, DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_EMPTY);
                return false;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to check if the file '" + deploymentExportFile + "' can be used for deployment importer. Renaming the file so that it does not get processed again.", ex);
            this.renameFile(deploymentExportFile, DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_INVALID);
            return false;
        }
        try {
            ModuleManager moduleManager = this.moduleManagerTracker.getService();
            Set<String> relatedModuleIDs = this.getRelatedModuleIDs(deploymentData);
            for (String relatedModuleID : relatedModuleIDs) {
                LOG.info("Checking if the module '" + relatedModuleID + "' has been loaded by the module manager.");
                try {
                    moduleManager.getModuleById(relatedModuleID);
                }
                catch (ModuleNotFoundException ex) {
                    LOG.warning("Deployment importer cannot run with missing (not yet loaded) module '" + relatedModuleID + "'. Will try again later ...");
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to check if the file '" + deploymentExportFile + "' can be used for deployment importer.", ex);
            this.renameFile(deploymentExportFile, DEPLOYMENT_FILE_EXTENSION_POSTFIX_WHEN_ERROR);
            return false;
        }
    }

    private Set<String> getRelatedModuleIDs(DeploymentData deploymentData) {
        LOG.info("getRelatedModuleIDs deploymentData=...");
        HashSet<String> result = new HashSet<String>();
        if (deploymentData != null && deploymentData.hasSettingsToDeploy()) {
            if (deploymentData.getSettings().hasDeleteSettingOperations()) {
                for (DeleteSettingOperation deleteOperation : deploymentData.getSettings().getDeleteSettingOperations()) {
                    result.add(deleteOperation.getModuleId());
                }
            }
            if (deploymentData.getSettings().hasSettingsToUpdateOrCreate()) {
                for (Setting setting : deploymentData.getSettings().getSettingsToUpdateOrCreate()) {
                    result.add(setting.getModuleId());
                }
            }
        }
        return result;
    }

    private void importFile(File deploymentExportFile) throws ServiceNotFoundException, IOException, LicenseException, ModuleNotFoundException, ValidationException, SettingException, ModuleNotInstantiableException, ModuleInstanceCreateException, DeploymentException {
        LOG.info("importFile deploymentExportFile=" + deploymentExportFile);
        DeploymentManager deploymentManager = this.deploymentManagerTracker.getService();
        CoreBundleConfiguration coreBundleConfiguration = this.coreBundleConfigurationTracker.getService();
        DeploymentImporterSession userSession = new DeploymentImporterSession();
        DeploymentInitiatorImpl deploymentInitiator = new DeploymentInitiatorImpl("from-deploy-folder", coreBundleConfiguration.getBpcName(), coreBundleConfiguration.getServerUUID());
        DeploymentData deploymentData = JsonUtil.getInstance().convertJsonFileToPojo(deploymentExportFile, DeploymentDataImpl.class);
        deploymentManager.importDeployment(userSession, deploymentInitiator, deploymentData, false, true);
    }
}

