/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.BackupManager;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.backup.BackupActivatedInfo;
import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.exception.BackupConflictException;
import de.virtimo.bpc.api.backup.exception.BackupException;
import de.virtimo.bpc.api.backup.exception.BackupNotFoundException;
import de.virtimo.bpc.api.deployment.DeploymentInitiator;
import de.virtimo.bpc.api.deployment.DeploymentManager;
import de.virtimo.bpc.api.deployment.DeploymentSide;
import de.virtimo.bpc.api.deployment.MimeMultipartData;
import de.virtimo.bpc.api.deployment.exception.DeploymentException;
import de.virtimo.bpc.api.deployment.exception.DeploymentSystemException;
import de.virtimo.bpc.api.deployment.resource.DeleteSettingOperation;
import de.virtimo.bpc.api.deployment.resource.DeploymentData;
import de.virtimo.bpc.api.deployment.resource.DeploymentSystemInfo;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.IndexMigrationException;
import de.virtimo.bpc.api.exception.ModuleInstanceCreateException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotInstantiableException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.IndexInfo;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.deployment.DeploymentConstraintsEnricher;
import de.virtimo.bpc.core.deployment.DeploymentInitiatorImpl;
import de.virtimo.bpc.core.deployment.DeploymentSystem;
import de.virtimo.bpc.core.deployment.MimeMultipartDataImpl;
import de.virtimo.bpc.core.deployment.resource.DeploymentEndpoint;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexData;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexInfo;
import de.virtimo.bpc.core.deployment.resource.DeploymentSystemInfoImpl;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.BroadcastCollector;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationImpl;
import de.virtimo.bpc.core.opensearch.ModuleManagerImpl;
import de.virtimo.bpc.core.opensearch.migration.GlobalConfigMigrator;
import de.virtimo.bpc.core.resource.ConfigurationEndpoint;
import de.virtimo.bpc.core.resource.response.MaskPasswords;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.core.utils.FelixFileinstallUtil;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;

public class DeploymentManagerImpl
implements DeploymentManager,
BpcService {
    private static final Logger LOG = Logger.getLogger(DeploymentManagerImpl.class.getName());
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<BackupManager> backupManagerTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final BpcServicesTracker<CoreBundleConfiguration> coreBundleConfigurationTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;

    public DeploymentManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.backupManagerTracker = new BpcServicesTracker<BackupManager>(bundleContext, BackupManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.coreBundleConfigurationTracker = new BpcServicesTracker<CoreBundleConfiguration>(bundleContext, CoreBundleConfiguration.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    private String appendDeploymentInitiatorInfoToLogMessage(DeploymentInitiator deploymentInitiator, String message) {
        if (message != null && !((String)message).endsWith(".")) {
            message = (String)message + ".";
        }
        return (String)message + " Initiated by '" + deploymentInitiator.getUserName() + "' from server '" + deploymentInitiator.getServerName() + "' (" + deploymentInitiator.getServerUUID() + ")";
    }

    @Override
    public List<DeploymentSystemInfo> getDeploymentSystemsInfo() throws ServiceNotFoundException, ModuleNotFoundException {
        LOG.info("getDeploymentSystemsInfo");
        ArrayList<DeploymentSystemInfo> result = new ArrayList<DeploymentSystemInfo>();
        BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        for (ModuleInstance moduleInstance : backendConnectionsModule.getModuleInstancesByInstanceType("deployment_system")) {
            result.add(new DeploymentSystemInfoImpl(moduleInstance.getModuleId(), ConfigurationEndpoint.getModuleInstanceName(moduleInstance), moduleInstance.getConfiguration().getSettingValue("sortPriority").asInt(1000)));
        }
        result.add(new DeploymentSystemInfoImpl(DeploymentEndpoint.JSON_TARGET_ID, "[JSON]", Integer.MAX_VALUE));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, IndexInfo> getOpenSearchIndexInfos(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide) throws ModuleNotFoundException, ModuleInstanceNotFoundException, ServiceNotFoundException, DeploymentSystemException, JsonProcessingException {
        LOG.info("getOpenSearchIndexInfos userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide);
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            Map<String, IndexInfo> map = deploymentSystem.getIndexInfos();
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyIndex(UserSession userSession, String indexName, String sourceDeploymentSystemId, String targetDeploymentSystemId, int blockSize, boolean deleteIndexOnTarget) throws ModuleNotFoundException, ModuleInstanceNotFoundException, ServiceNotFoundException, DeploymentSystemException, JsonProcessingException, DeploymentException {
        LOG.info("copyIndex userSession=..., indexName=" + indexName + ", sourceDeploymentSystemId=" + sourceDeploymentSystemId + ", targetDeploymentSystemId=" + targetDeploymentSystemId + ", blockSize=" + blockSize + ", deleteIndexOnTarget=" + deleteIndexOnTarget);
        ModuleConfiguration sourceConnectionConfig = this.getBackendConnectionConfiguration(sourceDeploymentSystemId);
        ModuleConfiguration targetConnectionConfig = this.getBackendConnectionConfiguration(targetDeploymentSystemId);
        String sourceSystemUrl = sourceConnectionConfig.getSettingValue("url").asString();
        String targetSystemUrl = targetConnectionConfig.getSettingValue("url").asString();
        if (sourceDeploymentSystemId.equalsIgnoreCase(targetDeploymentSystemId) || sourceSystemUrl.equalsIgnoreCase(targetSystemUrl)) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_INDEX_COPY_TO_SAME_SYSTEM_ERROR, "CORE_ERROR_DEPLOYMENT_COPY_INDEX_TO_SAME_SYSTEM", MapUtil.mapOf("index", indexName, "sourceId", sourceDeploymentSystemId, "sourceUrl", sourceSystemUrl, "targetId", targetDeploymentSystemId, "targetUrl", targetSystemUrl));
        }
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem source = null;
        DeploymentSystem target = null;
        try {
            source = new DeploymentSystem(DeploymentSide.Source, sourceConnectionConfig);
            source.setAdditionalHttpHeaders(additionalHttpHeaders);
            target = new DeploymentSystem(DeploymentSide.Target, targetConnectionConfig);
            target.setAdditionalHttpHeaders(additionalHttpHeaders);
            this.copyIndex(indexName, source, target, blockSize, deleteIndexOnTarget);
        }
        finally {
            if (source != null) {
                source.destroy();
            }
            if (target != null) {
                target.destroy();
            }
        }
    }

    private void copyIndex(String indexName, DeploymentSystem source, DeploymentSystem target, int blockSize, boolean deleteIndexOnTarget) throws DeploymentException, DeploymentSystemException, JsonProcessingException {
        LOG.info("copyIndex indexName=" + indexName + ", source=" + source + ", target=" + target + ", blockSize=" + blockSize + ", deleteIndexOnTarget=" + deleteIndexOnTarget);
        DeploymentIndexInfo indexInfo = source.getDeploymentIndexInfo(indexName);
        if (!indexInfo.hasExactlyOneAliasSet()) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_INDEX_ALIAS_ERROR, "CORE_ERROR_DEPLOYMENT_COPY_INDEX_WITH_ONE_ALIAS_ONLY", MapUtil.mapOf("index", indexName));
        }
        String alias = indexInfo.getTheOneAndOnlyAlias();
        target.prepareIndex(alias, indexInfo, deleteIndexOnTarget);
        DeploymentIndexData blockOfIndexData = source.downloadFirstIndexBlock(indexName, blockSize);
        if (blockOfIndexData.hasData()) {
            String scrollId = blockOfIndexData.getScrollId();
            do {
                target.uploadIndexData(alias, blockOfIndexData);
            } while ((blockOfIndexData = source.downloadSubsequentIndexBlock(indexName, scrollId)) != null && blockOfIndexData.hasData());
            source.releaseScrollId(indexName, scrollId);
        }
    }

    private ModuleConfiguration getBackendConnectionConfiguration(String deploymentSystemId) throws ServiceNotFoundException, ModuleNotFoundException, ModuleInstanceNotFoundException {
        LOG.info("getBackendConnectionConfiguration deploymentSystemId=" + deploymentSystemId);
        BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)this.moduleManagerTracker.getService().getModuleById("backendconnection");
        ModuleConfiguration deploymentConnectionConfig = backendConnectionsModule.getInstanceConfiguration(deploymentSystemId);
        if (deploymentConnectionConfig == null) {
            throw new ModuleInstanceNotFoundException("backendconnection", deploymentSystemId);
        }
        return deploymentConnectionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getModuleConfigurationsOfDeploymentSystem(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, IOException, ServiceNotFoundException {
        LOG.info("getModuleConfigurationsOfDeploymentSystem userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide);
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            Map<String, Object> map = deploymentSystem.getModuleConfigurations();
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getModuleConfigurationsOfDeploymentSystemFromBackup(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, String snapshotName) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, IOException, ServiceNotFoundException {
        LOG.info("getModuleConfigurationsOfDeploymentSystemFromBackup userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide + ", snapshotName=" + snapshotName);
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            Map<String, Object> map = deploymentSystem.getModuleConfigurationsFromBackup(snapshotName);
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    @Override
    public void enrichModuleConfigurationsWithDeploymentConstraints(Map<String, Object> modulesConfig) throws ServiceNotFoundException, ModuleNotFoundException, IOException {
        LOG.info("enrichModuleConfigurationsWithDeploymentConstraints modulesConfig=...");
        ModuleManager moduleManager = this.moduleManagerTracker.getService();
        ArrayList<Map> deploymentSettingsOfLoadedModules = new ArrayList<Map>();
        CoreModule coreModule = moduleManager.getModuleByClass(CoreModule.class);
        Map coreModuleDeploymentSettingsMap = coreModule.getConfiguration().getSettingValue("deployment").asMap(null);
        if (coreModuleDeploymentSettingsMap != null) {
            deploymentSettingsOfLoadedModules.add(coreModuleDeploymentSettingsMap);
        }
        for (Module module : moduleManager.getLoadedModules().values()) {
            Map moduleSpecificDeploymentSettingsMap;
            if (module.getModuleId().equals("_core") || (moduleSpecificDeploymentSettingsMap = module.getConfiguration().getSettingValue("deployment").asMap(null)) == null) continue;
            deploymentSettingsOfLoadedModules.add(moduleSpecificDeploymentSettingsMap);
        }
        new DeploymentConstraintsEnricher(deploymentSettingsOfLoadedModules).enrich(modulesConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getStatusOfDeploymentSystem(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, IOException, ServiceNotFoundException {
        LOG.info("getStatusOfDeploymentSystem userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide);
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            Map<String, Object> map = deploymentSystem.getStatus();
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    @Override
    public Map<String, Object> deploy(UserSession userSession, String sourceDeploymentSystemId, String targetDeploymentSystemId, DeploymentData deploymentData, boolean enableMaintenanceMode, boolean validate) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentException, DeploymentSystemException, IOException, ServiceNotFoundException {
        LOG.info("deploy userSession=..., sourceDeploymentSystemId=" + sourceDeploymentSystemId + ", targetDeploymentSystemId=" + targetDeploymentSystemId + ", deploymentData=" + deploymentData + ", enableMaintenanceMode=" + enableMaintenanceMode + ", validate=" + validate);
        if (deploymentData == null) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "CORE_ERROR_DEPLOYMENT_NO_DATA_GIVEN");
        }
        ModuleConfiguration sourceConnectionConfig = sourceDeploymentSystemId.equals(DeploymentEndpoint.JSON_TARGET_ID) ? null : this.getBackendConnectionConfiguration(sourceDeploymentSystemId);
        ModuleConfiguration targetConnectionConfig = targetDeploymentSystemId.equals(DeploymentEndpoint.JSON_TARGET_ID) ? null : this.getBackendConnectionConfiguration(targetDeploymentSystemId);
        DeploymentSystem source = null;
        DeploymentSystem target = null;
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        try {
            UserAuditLog.info(userSession, "Deployment", "Deployment to target '" + ConfigurationEndpoint.getModuleInstanceName(targetConnectionConfig) + "' (" + targetDeploymentSystemId + ") started");
            if (sourceConnectionConfig != null) {
                source = new DeploymentSystem(DeploymentSide.Source, sourceConnectionConfig);
                source.setAdditionalHttpHeaders(additionalHttpHeaders);
            }
            if (targetConnectionConfig != null) {
                target = new DeploymentSystem(DeploymentSide.Target, targetConnectionConfig);
                target.setAdditionalHttpHeaders(additionalHttpHeaders);
            }
            HashMap<String, Map<String, Object>> resp = new HashMap<String, Map<String, Object>>();
            if (deploymentData.hasSettingsToDeploy()) {
                String modulesDeploymentResp = target.uploadDeploymentData(deploymentData, enableMaintenanceMode, validate);
                resp.put("modulesDeployment", JsonUtil.getInstance().jsonStringAsMap(modulesDeploymentResp));
            }
            if (source != null && target != null) {
                if (deploymentData.hasBundlesToDeploy()) {
                    MimeMultipartData sourceBundlesAsMultipartData = source.downloadBundles(deploymentData.getBundleIDs());
                    String bundlesDeploymentResp = target.uploadBundles(sourceBundlesAsMultipartData);
                    resp.put("bundlesDeployment", JsonUtil.getInstance().jsonStringAsMap(bundlesDeploymentResp));
                }
                if (deploymentData.hasIndicesToDeploy()) {
                    for (String indexName : deploymentData.getIndices()) {
                        this.copyIndex(indexName, source, target, deploymentData.getCopyIndexBlockSize(), true);
                    }
                }
            }
            UserAuditLog.info(userSession, "Deployment", "Deployment to target '" + ConfigurationEndpoint.getModuleInstanceName(targetConnectionConfig) + "' (" + targetDeploymentSystemId + ") done");
            HashMap<String, Map<String, Object>> hashMap = resp;
            return hashMap;
        }
        catch (Exception ex) {
            UserAuditLog.error(userSession, "Deployment", "Deployment to target '" + ConfigurationEndpoint.getModuleInstanceName(targetConnectionConfig) + "' (" + targetDeploymentSystemId + ") failed: " + ex.getLocalizedMessage());
            throw ex;
        }
        finally {
            if (source != null) {
                source.destroy();
            }
            if (target != null) {
                target.destroy();
            }
        }
    }

    private void restoreBpcConfigurationSnapshot(UserSession userSession, DeploymentInitiator deploymentInitiator, BackupSnapshotInfo snapshotInfo) throws BackupNotFoundException, BackupConflictException, BackupException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("restoreBpcConfigurationSnapshot userSession=..., deploymentInitiator=" + deploymentInitiator + ", snapshotInfo=" + snapshotInfo);
        BackupActivatedInfo backupActivatedInfo = this.backupManagerTracker.getService().activateBackup(snapshotInfo.getName());
        UserAuditLog.info(userSession, "BackupRestored", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Backup with the snapshot name '" + snapshotInfo.getName() + "' restored"));
    }

    @Override
    public void importDeployment(UserSession userSession, DeploymentInitiator deploymentInitiator, DeploymentData deploymentData, boolean enableMaintenanceMode, boolean validate) throws ModuleNotFoundException, DeploymentException, SettingException, ModuleInstanceCreateException, LicenseException, ModuleNotInstantiableException, ServiceNotFoundException, ValidationException {
        LOG.info("importDeployment userSession=..., deploymentInitiator=" + deploymentInitiator + ", deploymentData=" + deploymentData + ", enableMaintenanceMode=" + enableMaintenanceMode + ", validate=" + validate);
        if (deploymentData == null) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "CORE_ERROR_DEPLOYMENT_NO_DATA_GIVEN");
        }
        if (!deploymentData.hasSettingsToDeploy()) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "CORE_ERROR_DEPLOYMENT_NO_DATA_GIVEN");
        }
        ModuleManager moduleManager = this.moduleManagerTracker.getService();
        BackupManager backupManager = this.backupManagerTracker.getService();
        EventManager eventManager = this.eventManagerTracker.getService();
        CoreModule coreModule = (CoreModule)moduleManager.getModuleById("_core");
        boolean maintenanceModeWasEnabled = coreModule.isMaintenanceModeEnabled();
        BackupSnapshotInfo snapshotInfo = null;
        try {
            UserAuditLog.info(userSession, "Deployment", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployment import start"));
            if (enableMaintenanceMode && !maintenanceModeWasEnabled) {
                if (!coreModule.isMaintenanceModeEnabled()) {
                    UserAuditLog.info(userSession, "MaintenanceModeEnabled", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Requested while performing a deployment"));
                }
                coreModule.enableMaintenanceMode(true);
            }
            try {
                snapshotInfo = this.backupManagerTracker.getService().createBackupUsingBackupJob("core:bpc-configuration");
                UserAuditLog.info(userSession, "BackupCreated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Backup with the snapshot name '" + snapshotInfo.getName() + "' created"));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to create the 'bpc-configuration' index snapshot/backup.", ex);
                UserAuditLog.warning(userSession, "BackupFailed", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Backup of the 'bpc-configuration' index failed. Please be sure that 'path.repo' is set in the OpenSearch configuration."));
            }
            BroadcastCollector broadcastCollector = new BroadcastCollector(eventManager);
            if (deploymentData.getSettings().hasDeleteSettingOperations()) {
                this.processDeleteOperations(moduleManager, userSession, deploymentInitiator, deploymentData.getSettings().getDeleteSettingOperations(), broadcastCollector);
            }
            if (deploymentData.getSettings().hasSettingsToUpdateOrCreate()) {
                this.processUpdateOrCreateSettings(moduleManager, userSession, deploymentInitiator, deploymentData.getSettings().getSettingsToUpdateOrCreate(), broadcastCollector, validate);
            }
            try {
                ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryWithNamePrefix("bpc-core-deployment"));
                for (Runnable broadcastEntry : broadcastCollector.getEntries()) {
                    executorService.execute(broadcastEntry);
                }
                executorService.shutdown();
            }
            catch (Throwable ex) {
                LOG.log(Level.SEVERE, "Could not inform the other Karaf installations about the deployment import.", ex);
            }
            UserAuditLog.info(userSession, "Deployment", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployment import done"));
            eventManager.fireEvent("de/virtimo/bpc/core/Configuration/modulesImported", new Hashtable());
        }
        catch (Exception ex) {
            UserAuditLog.error(userSession, "Deployment", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployment import failed: " + ex.getLocalizedMessage()));
            if (backupManager != null) {
                try {
                    if (snapshotInfo != null) {
                        this.restoreBpcConfigurationSnapshot(userSession, deploymentInitiator, snapshotInfo);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Not good. Exception while restoring the previously done snapshot (" + snapshotInfo + ").", e);
                }
            }
            if (enableMaintenanceMode && !maintenanceModeWasEnabled) {
                coreModule.disableMaintenanceMode(true);
            }
            throw ex;
        }
    }

    private void processDeleteOperations(ModuleManager moduleManager, UserSession userSession, DeploymentInitiator deploymentInitiator, List<DeleteSettingOperation> deleteOperations, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("processDeleteOperations moduleManager=..., userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperations=..., broadcastCollector=...");
        if (deleteOperations == null || deleteOperations.isEmpty()) {
            LOG.info("Bye, bye ... no delete operations given");
            return;
        }
        for (DeleteSettingOperation deleteOperation : deleteOperations) {
            this.processDeleteOperation(moduleManager, userSession, deploymentInitiator, deleteOperation, broadcastCollector);
        }
    }

    private void processDeleteOperation(ModuleManager moduleManager, UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("processDeleteOperation moduleManager=..., userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", broadcastCollector=...");
        if (StringUtil.isNullOrEmpty(deleteOperation.getModuleId())) {
            throw new DeploymentException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_MISSING_FIELD", MapUtil.mapOf("field", "moduleId"));
        }
        Module module = moduleManager.getModule(deleteOperation.getModuleId());
        if (module == null) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_MODULE_NOT_FOUND, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_MODULE_NOT_FOUND", MapUtil.mapOf("moduleId", deleteOperation.getModuleId()));
        }
        ModuleInstance moduleInstance = null;
        if (!ModuleConfiguration.isNoModuleInstanceId(deleteOperation.getInstanceId())) {
            if (module instanceof InstantiableModule) {
                moduleInstance = ((InstantiableModule)module).getModuleInstance(deleteOperation.getInstanceId());
                if (moduleInstance == null) {
                    throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_MODULE_INSTANCE_NOT_FOUND, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_MODULE_INSTANCE_NOT_FOUND", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "instanceId", deleteOperation.getInstanceId()));
                }
            } else {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_MODULE_NOT_INSTANTIABLE, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_ON_NON_INSTANTIABLE_MODULE", MapUtil.mapOf("moduleId", deleteOperation.getModuleId()));
            }
        }
        if (!StringUtil.isNullOrEmpty(deleteOperation.getSettingName())) {
            if (moduleInstance != null) {
                this.deleteSingleModuleInstanceSetting(userSession, deploymentInitiator, deleteOperation, module, moduleInstance, broadcastCollector);
            } else {
                this.deleteSingleModuleSetting(userSession, deploymentInitiator, deleteOperation, module, broadcastCollector);
            }
        } else {
            this.deleteModuleInstance(userSession, deploymentInitiator, deleteOperation, module, moduleInstance, broadcastCollector);
        }
    }

    private void deleteModuleInstance(UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, Module module, ModuleInstance moduleInstance, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("deleteModuleInstance userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", module=..., moduleInstance=..., broadcastCollector=...");
        if (moduleInstance == null) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DELETE_MODULE_SETTING_FAILED, "CORE_ERROR_DEPLOYMENT_DELETE_OPERATION_MODULE_SETTINGS", MapUtil.mapOf("moduleId", deleteOperation.getModuleId()));
        }
        moduleInstance.deleteInstance();
        UserAuditLog.info(userSession, "ModuleInstanceDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + deleteOperation.getInstanceId() + ") of module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") deleted"));
        moduleInstance.getParentModule().moduleInstanceDeleted(moduleInstance);
        broadcastCollector.moduleInstanceDeleted(deleteOperation.getModuleId(), deleteOperation.getInstanceId());
    }

    private void deleteSingleModuleSetting(UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, Module module, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("deleteSingleModuleSetting userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", module=..., broadcastCollector=...");
        try {
            Setting targetSetting = module.getConfiguration().getSetting(deleteOperation.getSettingName());
            if (targetSetting != null) {
                if (userSession == null || !userSession.hasWriteAccessToSetting(module, targetSetting)) {
                    throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_SETTING_NOT_ALLOWED", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "settingName", deleteOperation.getSettingName()));
                }
                module.getConfiguration().removeSetting(targetSetting);
                UserAuditLog.info(userSession, "ModuleSettingDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Setting of module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") deleted: " + deleteOperation.getSettingName()), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(Collections.singletonList(targetSetting)), null), null);
                broadcastCollector.moduleSettingDeleted(deleteOperation.getModuleId(), deleteOperation.getSettingName());
            } else {
                UserAuditLog.info(userSession, "ModuleSettingDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Setting of module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") to delete does not exist: " + deleteOperation.getSettingName()), null, null);
            }
        }
        catch (SettingException ex) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DELETE_MODULE_SETTING_FAILED, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_SETTING", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "settingName", deleteOperation.getSettingName(), "error", ex.getMessage()), (Throwable)ex);
        }
    }

    private void deleteSingleModuleInstanceSetting(UserSession userSession, DeploymentInitiator deploymentInitiator, DeleteSettingOperation deleteOperation, Module module, ModuleInstance moduleInstance, BroadcastCollector broadcastCollector) throws DeploymentException {
        LOG.info("deleteSingleModuleInstanceSetting userSession=..., deploymentInitiator=" + deploymentInitiator + ", deleteOperation=" + deleteOperation + ", module=..., moduleInstance=..., broadcastCollector=...");
        try {
            Setting targetSetting = moduleInstance.getConfiguration().getSetting(deleteOperation.getSettingName());
            if (targetSetting != null) {
                if (userSession == null || !userSession.hasWriteAccessToSetting(module, targetSetting)) {
                    throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_INSTANCE_SETTING_NOT_ALLOWED", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "moduleInstanceId", deleteOperation.getInstanceId(), "settingName", deleteOperation.getSettingName()));
                }
                moduleInstance.getConfiguration().removeSetting(targetSetting);
                UserAuditLog.info(userSession, "ModuleInstanceSettingDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Setting of module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + deleteOperation.getInstanceId() + ") and module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") deleted: " + deleteOperation.getSettingName()), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(Collections.singletonList(targetSetting)), null), null);
                moduleInstance.getParentModule().moduleInstanceUpdated(moduleInstance);
                broadcastCollector.moduleInstanceSettingDeleted(deleteOperation.getModuleId(), deleteOperation.getInstanceId(), deleteOperation.getInstanceType(), deleteOperation.getSettingName());
            } else {
                UserAuditLog.info(userSession, "ModuleInstanceSettingDeleted", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Setting of module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + deleteOperation.getInstanceId() + ") and module '" + module.getModuleName() + "' (" + deleteOperation.getModuleId() + ") to delete does not exist: " + deleteOperation.getSettingName()), null, null);
            }
        }
        catch (SettingException ex) {
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DELETE_MODULE_INSTANCE_SETTING_FAILED, "CORE_ERROR_DEPLOYMENT_DELETE_MODULE_INSTANCE_SETTING", MapUtil.mapOf("moduleId", deleteOperation.getModuleId(), "instanceId", deleteOperation.getInstanceId(), "settingName", deleteOperation.getSettingName()), (Throwable)ex);
        }
    }

    private Set<String> extractModuleIDsFromSettings(List<Setting> settings) {
        LOG.info("extractModuleIDsFromSettings settings=....");
        HashSet<String> result = new HashSet<String>();
        for (Setting setting : settings) {
            String moduleId = setting.getModuleId();
            if (moduleId == null) continue;
            result.add(moduleId);
        }
        return result;
    }

    private Set<String> extractInstanceIDsFromSettings(String moduleId, List<Setting> settings) {
        LOG.info("extractInstanceIDsFromSettings moduleId=" + moduleId + ", settings=....");
        HashSet<String> result = new HashSet<String>();
        for (Setting setting : settings) {
            String instanceId;
            if (moduleId == null || !moduleId.equals(setting.getModuleId()) || (instanceId = setting.getInstanceId()) == null) continue;
            result.add(instanceId);
        }
        return result;
    }

    private List<Setting> filterSettingsByModuleId(String moduleId, List<Setting> settings) {
        LOG.info("filterSettingsByModuleId moduleId=" + moduleId + ", settings=...");
        ArrayList<Setting> result = new ArrayList<Setting>();
        for (Setting setting : settings) {
            if (!moduleId.equals(setting.getModuleId())) continue;
            result.add(setting);
        }
        return result;
    }

    private List<Setting> filterSettingsByModuleIdAndInstanceId(String moduleId, String instanceId, List<Setting> settings) {
        LOG.info("filterSettingsByModuleIdAndInstanceId moduleId=" + moduleId + ", instanceId=" + instanceId + ", settings=...");
        ArrayList<Setting> result = new ArrayList<Setting>();
        for (Setting setting : settings) {
            if (!moduleId.equals(setting.getModuleId()) || !instanceId.equals(setting.getInstanceId())) continue;
            result.add(setting);
        }
        return result;
    }

    private String extractInstanceType(List<Setting> instanceSettings) {
        LOG.fine("extractInstanceType instanceSettings=....");
        for (Setting setting : instanceSettings) {
            String instanceType = setting.getInstanceType();
            if (instanceType == null || instanceType.equals("none")) continue;
            return instanceType;
        }
        return "none";
    }

    private Map<String, Setting> convertSettingsListToMap(List<Setting> settings) {
        LOG.fine("convertSettingsListToMap settings=...");
        HashMap<String, Setting> result = new HashMap<String, Setting>();
        for (Setting setting : settings) {
            result.put(setting.getName(), setting);
        }
        return result;
    }

    private void processUpdateOrCreateSettings(ModuleManager moduleManager, UserSession userSession, DeploymentInitiator deploymentInitiator, List<Setting> settings, BroadcastCollector broadcastCollector, boolean validate) throws DeploymentException, SettingException, ModuleInstanceCreateException, LicenseException, ModuleNotInstantiableException, ValidationException {
        LOG.info("processUpdateOrCreateSettings moduleManager=..., userSession=..., deploymentInitiator=" + deploymentInitiator + ", settings=..., broadcastCollector=..., validate=" + validate);
        Set<String> moduleIDs = this.extractModuleIDsFromSettings(settings);
        for (String moduleId : moduleIDs) {
            Module module = moduleManager.getModule(moduleId);
            if (module == null) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_MODULE_NOT_FOUND, "CORE_ERROR_DEPLOYMENT_UPDATE_OR_CREATE_OPERATION_MODULE_NOT_FOUND", MapUtil.mapOf("moduleId", moduleId));
            }
            List<Setting> settingsOfModule = this.filterSettingsByModuleId(moduleId, settings);
            this.updateModule(moduleManager, userSession, deploymentInitiator, module, settingsOfModule, broadcastCollector, validate);
        }
    }

    private void updateModule(ModuleManager moduleManager, UserSession userSession, DeploymentInitiator deploymentInitiator, Module module, List<Setting> settingsOfModule, BroadcastCollector broadcastCollector, boolean validate) throws SettingException, ModuleInstanceCreateException, LicenseException, ModuleNotInstantiableException, ValidationException {
        LOG.info("updateModule moduleManager=..., userSession=..., deploymentInitiator=" + deploymentInitiator + ", module=" + module + ", settingsOfModule=..., broadcastCollector=..., validate=" + validate);
        String moduleId = module.getModuleId();
        Set<String> instanceIDs = this.extractInstanceIDsFromSettings(moduleId, settingsOfModule);
        if (instanceIDs.contains("noinstance")) {
            LOG.info(moduleId + ": Processing the global module settings");
            ModuleConfiguration currentModuleConfiguration = module.getConfiguration();
            List<Setting> noInstanceSettings = this.filterSettingsByModuleIdAndInstanceId(moduleId, "noinstance", settingsOfModule);
            if (userSession == null || !userSession.hasWriteAccessToSettings(module, noInstanceSettings)) {
                throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "CORE_ERROR_DEPLOYMENT_UPDATE_MODULE_SETTINGS_NOT_ALLOWED", MapUtil.mapOf("moduleId", moduleId));
            }
            new MaskPasswords().unmaskPasswords(currentModuleConfiguration.getSettings().values(), noInstanceSettings);
            new MaskPasswords().clearMaskedPasswords(noInstanceSettings);
            if (validate) {
                moduleManager.validateModuleSettings(moduleId, currentModuleConfiguration.getSettings().values(), noInstanceSettings);
            }
            Collection<Setting> oldSettings = currentModuleConfiguration.getSettingsByName(ModuleConfiguration.getSettingNames(noInstanceSettings));
            ArrayList<Setting> newSettings = new ArrayList<Setting>(noInstanceSettings);
            for (Setting noInstanceSetting : noInstanceSettings) {
                if (currentModuleConfiguration.getSetting(noInstanceSetting.getName()) == null) {
                    LOG.info(moduleId + ": Adding the global setting: " + noInstanceSetting.getName());
                    currentModuleConfiguration.addSetting(noInstanceSetting);
                    continue;
                }
                LOG.info(moduleId + ": Updating the global setting: " + noInstanceSetting.getName());
                currentModuleConfiguration.updateSetting(noInstanceSetting);
            }
            UserAuditLog.info(userSession, "ModuleUpdated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Settings of module '" + module.getModuleName() + "' (" + module.getModuleId() + ") updated: " + StringUtil.implode(", ", ModuleConfiguration.getSettingNames(noInstanceSettings))), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(oldSettings), null), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(newSettings), null));
            broadcastCollector.moduleUpdated(moduleId);
        }
        instanceIDs.remove("noinstance");
        if (!instanceIDs.isEmpty() && !(module instanceof InstantiableModule)) {
            throw new ModuleNotInstantiableException(moduleId);
        }
        if (module instanceof InstantiableModule) {
            LOG.info(moduleId + ": Processing the module instances");
            InstantiableModule instantiableModule = (InstantiableModule)module;
            for (String instanceId : instanceIDs) {
                LOG.info(moduleId + "/" + instanceId + ": Processing the instance settings");
                List<Setting> settingsOfModuleInstance = this.filterSettingsByModuleIdAndInstanceId(moduleId, instanceId, settingsOfModule);
                String instanceType = this.extractInstanceType(settingsOfModuleInstance);
                if (userSession == null || !userSession.hasWriteAccessToSettings(module, settingsOfModuleInstance)) {
                    throw new SettingException((ErrorCode)CoreErrorCode.MODULE_SETTING_NO_ACCESS_RIGHT, "CORE_ERROR_DEPLOYMENT_UPDATE_MODULE_INSTANCE_SETTINGS_NOT_ALLOWED", MapUtil.mapOf("moduleId", moduleId, "moduleInstanceId", instanceId));
                }
                ModuleInstance moduleInstance = instantiableModule.getModuleInstance(instanceId);
                if (moduleInstance == null) {
                    LOG.info(moduleId + "/" + instanceId + ": Creating new module instance");
                    ModuleConfigurationImpl moduleInstanceConfiguration = new ModuleConfigurationImpl(instantiableModule, instanceId, instanceType, this.convertSettingsListToMap(settingsOfModuleInstance), (ModuleManagerImpl)moduleManager);
                    new MaskPasswords().clearMaskedPasswords(settingsOfModuleInstance);
                    if (validate) {
                        moduleManager.validateModuleInstanceSettings(moduleId, instanceId, instanceType, moduleInstanceConfiguration.getSettings().values(), settingsOfModuleInstance);
                    }
                    moduleInstance = instantiableModule.createModuleInstance(instanceId, instanceType, moduleInstanceConfiguration);
                    UserAuditLog.info(userSession, "ModuleInstanceCreated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + instanceId + ") of module '" + module.getModuleName() + "' (" + moduleId + ") created"));
                    instantiableModule.moduleInstanceCreated(moduleInstance);
                    broadcastCollector.moduleInstanceCreated(moduleId, instanceId, instanceType);
                    continue;
                }
                LOG.info(moduleId + "/" + instanceId + ": Updating existing module instance");
                ModuleConfiguration currentInstanceConfiguration = moduleInstance.getConfiguration();
                new MaskPasswords().unmaskPasswords(currentInstanceConfiguration.getSettings().values(), settingsOfModuleInstance);
                new MaskPasswords().clearMaskedPasswords(settingsOfModuleInstance);
                if (validate) {
                    moduleManager.validateModuleInstanceSettings(moduleId, instanceId, instanceType, currentInstanceConfiguration.getSettings().values(), settingsOfModuleInstance);
                }
                Collection<Setting> oldSettings = currentInstanceConfiguration.getSettingsByName(ModuleConfiguration.getSettingNames(settingsOfModuleInstance));
                ArrayList<Setting> newSettings = new ArrayList<Setting>(settingsOfModuleInstance);
                for (Setting instanceSetting : settingsOfModuleInstance) {
                    if (currentInstanceConfiguration.getSetting(instanceSetting.getName()) == null) {
                        LOG.info(moduleId + "/" + instanceId + ": Adding module instance setting: " + instanceSetting.getName());
                        currentInstanceConfiguration.addSetting(instanceSetting);
                        continue;
                    }
                    LOG.info(moduleId + "/" + instanceId + ": Updating module instance setting: " + instanceSetting.getName());
                    currentInstanceConfiguration.updateSetting(instanceSetting);
                }
                UserAuditLog.info(userSession, "ModuleInstanceUpdated", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Settings of module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + instanceId + ") of module '" + module.getModuleName() + "' (" + moduleId + ") updated: " + StringUtil.implode(", ", ModuleConfiguration.getSettingNames(settingsOfModuleInstance))), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(oldSettings), null), (Object)JsonUtil.getInstance().convertPojoToJsonString(new MaskPasswords().maskPasswords(newSettings), null));
                instantiableModule.moduleInstanceUpdated(moduleInstance);
                broadcastCollector.moduleInstanceUpdated(moduleId, instanceId, instanceType);
            }
        }
    }

    @Override
    public void importXmlFileLicense(UserSession userSession, DeploymentInitiator deploymentInitiator, Attachment attachment) throws DeploymentSystemException, InvalidSyntaxException, IOException, ServiceNotFoundException {
        LOG.info("importXmlFileLicense userSession=..., deploymentInitiator=" + deploymentInitiator + ", attachment=...");
        if (attachment == null) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_LICENSE_FILE_MISSING");
        }
        String attachmentFileName = this.getFilenameFromAttachment(attachment);
        if (!"license.xml.bpc".equals(attachmentFileName)) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_LICENSE_FILE_MISSING");
        }
        File deployFolder = FelixFileinstallUtil.getDeployFolder(this.bundleContext);
        LOG.info("Going to copy the uploaded '" + attachmentFileName + "' file to the deploy folder: " + deployFolder);
        File deployArchiveFolder = this.getDeployArchiveFolder(deployFolder);
        LOG.info("Making backup of the to be overwritten '" + attachmentFileName + "' to the folder: " + deployArchiveFolder);
        this.copyXmlFileLicenseToFolder(userSession, deploymentInitiator, attachment, deployFolder, deployArchiveFolder);
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void importBundles(UserSession userSession, DeploymentInitiator deploymentInitiator, List<Attachment> attachments) throws DeploymentSystemException, InvalidSyntaxException, IOException, ServiceNotFoundException {
        LOG.info("importBundles userSession=..., deploymentInitiator=" + deploymentInitiator + ", attachments=...");
        if (attachments == null || attachments.isEmpty()) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_IMPORT_BUNDLES_MISSING");
        }
        File deployFolder = FelixFileinstallUtil.getDeployFolder(this.bundleContext);
        LOG.info("Going to copy the uploaded bundles to the deploy folder: " + deployFolder);
        File deployArchiveFolder = this.getDeployArchiveFolder(deployFolder);
        LOG.info("Making backups of the to be overwritten bundles to the folder: " + deployArchiveFolder);
        BundleListener bl = null;
        try {
            final HashMap<String, Integer> processedBundleFileNames = new HashMap<String, Integer>();
            final long t1 = System.currentTimeMillis();
            bl = new BundleListener(){

                public void bundleChanged(BundleEvent bundleEvent) {
                    LOG.info("Received " + bundleEvent + " with type/status '" + bundleEvent.getType() + "' after " + (System.currentTimeMillis() - t1) + " milliseconds");
                    String bundleFileName = BpcBundleUtil.getBundleFilename(bundleEvent.getBundle());
                    processedBundleFileNames.put(bundleFileName, bundleEvent.getType());
                }
            };
            this.bundleContext.addBundleListener(bl);
            HashMap<String, Integer> copiedBundleFileNames = new HashMap<String, Integer>();
            for (Attachment attachment : attachments) {
                String bundleFileName;
                Bundle existingBundle = BpcBundleUtil.getBundle(this.bundleContext, bundleFileName = this.getFilenameFromAttachment(attachment));
                copiedBundleFileNames.put(bundleFileName, existingBundle == null ? -1 : existingBundle.getState());
                this.copyBundleFileToFolder(userSession, deploymentInitiator, attachment, deployFolder, deployArchiveFolder);
            }
            for (String bundleFileName : copiedBundleFileNames.keySet()) {
                LOG.info("Bundle status before import: " + bundleFileName + " = " + copiedBundleFileNames.get(bundleFileName));
            }
            long waitStartTime = System.currentTimeMillis();
            long maxWaitTimeInSeconds = 26L;
            while (true) {
                if (this.allBundlesProcessed(copiedBundleFileNames, processedBundleFileNames)) {
                    LOG.info("It seems that all deployed bundles are now processed by Karaf ... going on ...");
                    break;
                }
                if (System.currentTimeMillis() - waitStartTime > maxWaitTimeInSeconds * 1000L) {
                    LOG.info("Max wait time of " + maxWaitTimeInSeconds + " seconds reached ... giving up!");
                    break;
                }
                LOG.info("Waiting for bundles to be installed ... sleeping and trying again ...");
                Thread.sleep(250L);
            }
            if (bl == null) return;
        }
        catch (Exception ex) {
            try {
                LOG.log(Level.SEVERE, "Failed to copy the deployed bundles to the Karaf deploy folder and wait for them to be installed.", ex);
                if (bl == null) return;
            }
            catch (Throwable throwable) {
                if (bl == null) throw throwable;
                this.bundleContext.removeBundleListener(bl);
                throw throwable;
            }
            this.bundleContext.removeBundleListener(bl);
            return;
        }
        this.bundleContext.removeBundleListener(bl);
        return;
    }

    private boolean allBundlesProcessed(Map<String, Integer> copiedBundleFileNames, Map<String, Integer> processedBundleFileNames) {
        HashMap<Integer, Integer> expected = new HashMap<Integer, Integer>();
        expected.put(-1, 2);
        expected.put(32, 2);
        expected.put(2, 8);
        HashSet<String> confirmedFileNames = new HashSet<String>();
        for (String fileName : copiedBundleFileNames.keySet()) {
            int state = copiedBundleFileNames.get(fileName);
            if (!processedBundleFileNames.containsKey(fileName)) continue;
            int type = processedBundleFileNames.get(fileName);
            if (!expected.containsKey(state) || (Integer)expected.get(state) != type) continue;
            confirmedFileNames.add(fileName);
        }
        return copiedBundleFileNames.size() == confirmedFileNames.size();
    }

    private File getDeployArchiveFolder(File deployFolder) {
        LOG.info("getDeployArchiveFolder deployFolder=" + deployFolder);
        try {
            String parentDeployFolder = deployFolder.getParent();
            LOG.info("parentDeployFolder = " + parentDeployFolder);
            File baseDeployArchiveFolderFile = new File(parentDeployFolder, "deploy_archive");
            LOG.info("baseDeployArchiveFolderFile = " + baseDeployArchiveFolderFile);
            boolean baseDeployArchiveFolderCreated = baseDeployArchiveFolderFile.mkdir();
            LOG.info("baseDeployArchiveFolderCreated = " + baseDeployArchiveFolderCreated);
            String deployArchiveFolderName = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
            deployArchiveFolderName = deployArchiveFolderName.replaceAll("[:|.]", "-");
            LOG.info("deployArchiveFolderName = " + deployArchiveFolderName);
            File deployArchiveFolder = new File(baseDeployArchiveFolderFile, deployArchiveFolderName);
            LOG.info("deployArchiveFolder = " + deployArchiveFolder);
            boolean deployArchiveFolderCreated = deployArchiveFolder.mkdir();
            LOG.info("deployArchiveFolderCreated = " + deployArchiveFolderCreated);
            return deployArchiveFolderCreated ? deployArchiveFolder : null;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get/create the deploy archive folder.", ex);
            return null;
        }
    }

    private String getFilenameFromAttachment(Attachment attachment) {
        return attachment == null ? null : attachment.getContentDisposition().getParameter("filename");
    }

    private void copyXmlFileLicenseToFolder(UserSession userSession, DeploymentInitiator deploymentInitiator, Attachment attachment, File targetFolder, File targetArchiveFolder) throws IOException {
        LOG.info("copyXmlFileLicenseToFolder userSession=" + userSession + ", deploymentInitiator=" + deploymentInitiator + ", attachment=" + attachment + ", targetFolder=" + targetFolder + ", targetArchiveFolder=" + targetArchiveFolder);
        String filename = null;
        try {
            filename = this.getFilenameFromAttachment(attachment);
            this.copyFileToFolder(filename, attachment, targetFolder, targetArchiveFolder);
            UserAuditLog.info(userSession, "LicenseDeployed", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployed the license file '" + filename + "' to folder '" + targetFolder + "'"));
        }
        catch (Exception ex) {
            UserAuditLog.error(userSession, "LicenseNotDeployed", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Failed to deploy the license file '" + filename + "' to folder '" + targetFolder + "'. Error: " + ex.getLocalizedMessage()));
            throw ex;
        }
    }

    private void copyBundleFileToFolder(UserSession userSession, DeploymentInitiator deploymentInitiator, Attachment attachment, File targetFolder, File targetArchiveFolder) throws IOException {
        LOG.info("copyBundleFileToFolder userSession=" + userSession + ", deploymentInitiator=" + deploymentInitiator + ", attachment=" + attachment + ", targetFolder=" + targetFolder + ", targetArchiveFolder=" + targetArchiveFolder);
        String filename = null;
        try {
            filename = this.getFilenameFromAttachment(attachment);
            this.copyFileToFolder(filename, attachment, targetFolder, targetArchiveFolder);
            UserAuditLog.info(userSession, "BundleFileDeployed", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Deployed the bundle file '" + filename + "' to folder '" + targetFolder + "'"));
        }
        catch (Exception ex) {
            UserAuditLog.error(userSession, "BundleFileNotDeployed", this.appendDeploymentInitiatorInfoToLogMessage(deploymentInitiator, "Failed to deploy the bundle file '" + filename + "' to folder '" + targetFolder + "'. Error: " + ex.getLocalizedMessage()));
            throw ex;
        }
    }

    private void copyFileToFolder(String filename, Attachment attachment, File targetFolder, File targetArchiveFolder) throws IOException {
        LOG.info("copyAttachmentFileToFolder filename=" + filename + ", attachment=" + attachment + ", targetFolder=" + targetFolder + ", targetArchiveFolder=" + targetArchiveFolder);
        File targetFile = new File(targetFolder, filename);
        if (targetArchiveFolder != null) {
            LOG.info("Archiving the to be overwritten file: " + filename);
            try {
                Path sourceFilePath = new File(targetFolder, filename).toPath();
                Path targetFilePath = new File(targetArchiveFolder, filename).toPath();
                Files.copy(sourceFilePath, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception ex) {
                LOG.warning("Failed to create a backup of the file: " + filename);
            }
        }
        LOG.info("Copying filename:" + filename + ", content-type:" + attachment.getContentType() + " to " + targetFile);
        InputStream attachmentInputStream = attachment.getDataHandler().getInputStream();
        Files.copy(attachmentInputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        attachmentInputStream.close();
    }

    @Override
    public MimeMultipartData getBundlesAsMultipartData(List<Long> bundleIDs) throws IOException, URISyntaxException {
        LOG.info("getBundlesDeploymentMultipartPostData bundleIDs=" + bundleIDs);
        MimeMultipartDataImpl.Builder mimeMultipartDataBuilder = MimeMultipartDataImpl.newBuilder();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            long bundleId = bundle.getBundleId();
            if (!bundleIDs.contains(bundleId)) continue;
            LOG.info("Great, found the bundle with the ID '" + bundleId + "' for deployment.");
            String bundleFileLocation = bundle.getLocation();
            if (bundleFileLocation.startsWith("file:")) {
                URI bundleFileURI = new URI(bundleFileLocation);
                String bundleFileName = Paths.get(bundleFileURI).getFileName().toString();
                File bundleFile = new File(bundleFileURI);
                String bundleFileContentType = Files.probeContentType(bundleFile.toPath());
                if (bundleFileContentType == null) {
                    bundleFileContentType = "application/java-archive";
                }
                mimeMultipartDataBuilder.addFile(bundleFileName, bundleFile.toPath(), bundleFileContentType);
                continue;
            }
            LOG.warning("The bundle with the ID '" + bundleId + "' cannot be deployed, it uses an unknown location prefix (expecting 'file:'): " + bundleFileLocation);
        }
        return mimeMultipartDataBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMigrateModulesConfigFromDeploymentSystem(UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, Map<String, Object> modulesConfigToMigrate) throws ModuleNotFoundException, ModuleInstanceNotFoundException, ServiceNotFoundException, DeploymentSystemException, IOException, OpenSearchRelatedException {
        LOG.info("getMigrateModulesConfigFromDeploymentSystem userSession=..., deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide + ", modulesConfigToMigrate=...");
        ModuleConfiguration connectionConfig = this.getBackendConnectionConfiguration(deploymentSystemId);
        Map<String, Object> additionalHttpHeaders = DeploymentInitiatorImpl.httpHeaders(userSession, this.coreBundleConfigurationTracker.getService());
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(deploymentSide, connectionConfig);
            deploymentSystem.setAdditionalHttpHeaders(additionalHttpHeaders);
            String moduleConfigMigratedResp = deploymentSystem.migrateModulesConfig(modulesConfigToMigrate);
            Map<String, Object> map = JsonUtil.getInstance().jsonStringAsMap(moduleConfigMigratedResp);
            return map;
        }
        finally {
            if (deploymentSystem != null) {
                deploymentSystem.destroy();
            }
        }
    }

    @Override
    public Map<String, Object> migrateModulesConfig(UserSession userSession, DeploymentInitiator deploymentInitiator, Map<String, Object> modulesConfig) throws ServiceNotFoundException, IOException, OpenSearchRelatedException, IndexMigrationException {
        LOG.info("migrateModulesConfig userSession=..., deploymentInitiator=" + deploymentInitiator + ", modulesConfig=...");
        GlobalConfigMigrator configMigrator = new GlobalConfigMigrator(this.moduleManagerTracker.getService(), this.openSearchServiceTracker.getService());
        return configMigrator.migrate(modulesConfig);
    }
}

