/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.deployment.DeploymentSide;
import de.virtimo.bpc.core.deployment.DeploymentSystem;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeploymentSystemConnectionTester
implements ConnectionTester {
    private static final Logger LOG = Logger.getLogger(DeploymentSystemConnectionTester.class.getName());

    @Override
    public void destroy() {
        LOG.info("destroy");
    }

    @Override
    public boolean canBeUsedToPerformConnectionTest(ModuleInstance moduleInstance) {
        LOG.info("canBeUsedToPerformConnectionTest moduleInstance=...");
        return moduleInstance != null && "backendconnection".equalsIgnoreCase(moduleInstance.getParentModule().getModuleId()) && "deployment_system".equalsIgnoreCase(moduleInstance.getInstanceType());
    }

    @Override
    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws ConnectionTestException {
        LOG.info("performConnectionTest moduleInstance=..., testData=...");
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(DeploymentSide.Unknown, moduleInstance.getConfiguration());
            deploymentSystem.testConnection();
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
        finally {
            if (deploymentSystem != null) {
                try {
                    deploymentSystem.destroy();
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Failed to call destroy on the deployment system. This could leak a http client instance.", ex);
                }
            }
        }
    }
}

