/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

public class GZipContentUtil {
    private static final Logger LOG = Logger.getLogger(GZipContentUtil.class.getName());

    public static String getContentAsString(Response r) throws IOException {
        LOG.fine("getContentAsString r=...");
        String result = null;
        if (r != null) {
            String contentEncoding = r.getHeaderString("Content-Encoding");
            result = contentEncoding != null && contentEncoding.equals("gzip") ? new String(StreamUtil.unzip((InputStream)r.getEntity()), StandardCharsets.UTF_8) : (String)r.readEntity(String.class);
        }
        return result;
    }

    public static String getContentAsString(byte[] postedContent, HttpHeaders hh) throws IOException {
        LOG.fine("getContentAsString postedContent=..., hh=...");
        String result = null;
        if (postedContent != null) {
            String contentEncoding = hh.getHeaderString("Content-Encoding");
            result = contentEncoding != null && contentEncoding.equals("gzip") ? new String(StreamUtil.unzip(new ByteArrayInputStream(postedContent)), StandardCharsets.UTF_8) : new String(postedContent, StandardCharsets.UTF_8);
        }
        return result;
    }
}

