/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.virtimo.bpc.api.deployment.resource.DeploymentData;
import de.virtimo.bpc.api.deployment.resource.SettingsToDeploy;
import de.virtimo.bpc.core.deployment.resource.SettingsToDeployImpl;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeploymentDataImpl
implements DeploymentData {
    private static final Logger LOG = Logger.getLogger(DeploymentDataImpl.class.getName());
    @JsonDeserialize(as=SettingsToDeployImpl.class)
    private SettingsToDeploy settings;
    private List<Number> bundleIDs;
    private Set<String> indices;
    private int copyIndexBlockSize;

    private DeploymentDataImpl() {
        this.copyIndexBlockSize = 2500;
    }

    public DeploymentDataImpl(SettingsToDeploy settings, List<Number> bundleIDs, Set<String> indices, int copyIndexBlockSize) {
        this.settings = settings;
        this.bundleIDs = bundleIDs;
        this.indices = indices;
        this.copyIndexBlockSize = copyIndexBlockSize;
    }

    @Override
    public SettingsToDeploy getSettings() {
        return this.settings;
    }

    @Override
    public List<Number> getBundleIDs() {
        return this.bundleIDs;
    }

    @Override
    public Set<String> getIndices() {
        return this.indices;
    }

    @Override
    public int getCopyIndexBlockSize() {
        return this.copyIndexBlockSize;
    }

    @Override
    @JsonIgnore
    public boolean hasSettingsToDeploy() {
        return this.settings != null && (this.settings.hasDeleteSettingOperations() || this.settings.hasSettingsToUpdateOrCreate());
    }

    @Override
    @JsonIgnore
    public boolean hasBundlesToDeploy() {
        return this.bundleIDs != null && !this.bundleIDs.isEmpty();
    }

    @Override
    @JsonIgnore
    public boolean hasIndicesToDeploy() {
        return this.indices != null && !this.indices.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentDataImpl that = (DeploymentDataImpl)o;
        return this.copyIndexBlockSize == that.copyIndexBlockSize && Objects.equals(this.settings, that.settings) && Objects.equals(this.bundleIDs, that.bundleIDs) && Objects.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.bundleIDs, this.indices, this.copyIndexBlockSize);
    }

    public String toString() {
        return "DeploymentData{settings=" + this.settings + ", bundleIDs=" + this.bundleIDs + ", indices=" + this.indices + ", copyIndexBlockSize=" + this.copyIndexBlockSize + "}";
    }
}

