/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.deployment.DeploymentManager;
import de.virtimo.bpc.api.deployment.DeploymentSide;
import de.virtimo.bpc.api.deployment.MimeMultipartData;
import de.virtimo.bpc.api.deployment.exception.DeploymentException;
import de.virtimo.bpc.api.deployment.exception.DeploymentSystemException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.IndexInfo;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.SettingFactory;
import de.virtimo.bpc.core.deployment.DeploymentBundlesDiffer;
import de.virtimo.bpc.core.deployment.DeploymentDiffer;
import de.virtimo.bpc.core.deployment.DeploymentIndicesDiffer;
import de.virtimo.bpc.core.deployment.DeploymentInitiatorImpl;
import de.virtimo.bpc.core.deployment.DeploymentSettingsDiffer;
import de.virtimo.bpc.core.deployment.GZipContentUtil;
import de.virtimo.bpc.core.deployment.resource.DeploymentDataImpl;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexData;
import de.virtimo.bpc.core.deployment.resource.DeploymentIndexInfo;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.migration.BpcIndicesMigrator;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Path(value="deployment")
public class DeploymentEndpoint {
    private static final Logger LOG = Logger.getLogger(DeploymentEndpoint.class.getName());
    public static String JSON_TARGET_ID = "@@@JSON@@@";
    private final BundleContext bundleContext;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private BpcServicesTracker<DeploymentManager> deploymentManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<OpenSearchService> openSearchServiceTracker;

    public DeploymentEndpoint(BundleContext bundleContext) {
        LOG.info("DeploymentEndpoint bundleContext=" + bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOG.info("onStartup");
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
        this.deploymentManagerTracker = new BpcServicesTracker<DeploymentManager>(this.bundleContext, DeploymentManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(this.bundleContext, OpenSearchService.class);
    }

    public void onShutdown() {
        LOG.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/systems")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_GET_SYSTEMS", message="Not allowed to use deployment")
    public Response getDeploymentSystems(@Context HttpHeaders hh) {
        LOG.info("getDeploymentSystems");
        try {
            return Response.ok(Map.of("entries", this.deploymentManagerTracker.getService().getDeploymentSystemsInfo())).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the deployment systems.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    private Map<String, Object> createEmptyStatusOfDeploymentSystemForJsonExport() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("allBpcModules", new ArrayList());
        return result;
    }

    private Map<String, Object> createEmptyModulesConfigForJsonExport(Map<String, Object> otherTargetConfig) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (otherTargetConfig == null) {
            result.put("modules", new ArrayList());
        } else {
            List modules = JsonUtil.getInstance().convertJsonStringToPojo(JsonUtil.getInstance().convertPojoToJsonString(otherTargetConfig.get("modules")), List.class);
            for (Map module : modules) {
                List defaultModuleSettings = (List)module.get("defaultConfiguration");
                module.remove("instances");
                module.remove("defaultConfiguration");
                module.remove("instancesDefaultConfiguration");
                module.remove("settings");
                ArrayList<Map<String, Object>> newSettings = new ArrayList<Map<String, Object>>();
                if (defaultModuleSettings != null) {
                    for (Map defaultModuleSettingAsMap : defaultModuleSettings) {
                        Setting defaultModuleSetting = SettingFactory.parseMapSetting(defaultModuleSettingAsMap);
                        defaultModuleSetting.setInstanceId("noinstance");
                        String newModuleSettingAsString = JsonUtil.getInstance().convertPojoToJsonString(defaultModuleSetting);
                        Map<String, Object> newModuleSettingAsMap = JsonUtil.getInstance().jsonStringAsMap(newModuleSettingAsString);
                        newSettings.add(newModuleSettingAsMap);
                    }
                }
                module.put("settings", newSettings);
            }
            result.put("modules", modules);
        }
        return result;
    }

    private Map<String, Object> getMigratedSourceModulesConfigFromDeploymentSystem(DeploymentManager deploymentManager, UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, Map<String, Object> modulesConfigToMigrate) throws ModuleNotFoundException, ModuleInstanceNotFoundException, ServiceNotFoundException, DeploymentSystemException, IOException, OpenSearchRelatedException {
        LOG.info("getMigratedSourceModulesConfigFromDeploymentSystem deploymentManager=..., userSession=" + userSession + ", deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide + ", modulesConfigToMigrate=...");
        Map<String, Object> migratedModulesConfig = deploymentManager.getMigrateModulesConfigFromDeploymentSystem(userSession, deploymentSystemId, deploymentSide, modulesConfigToMigrate);
        return migratedModulesConfig;
    }

    private Map<String, Object> getModulesConfig(DeploymentManager deploymentManager, UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, Map<String, Object> deploymentSystemStatus) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, ServiceNotFoundException, IOException {
        LOG.info("getModulesConfig deploymentManager=..., userSession=" + userSession + ", deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide + ", deploymentSystemStatus=" + deploymentSystemStatus);
        HashMap loadedTargetModules = new HashMap();
        for (Object loadedModuleObject : (List)deploymentSystemStatus.get("loadedModules")) {
            Map loadedModuleEntry = (Map)loadedModuleObject;
            loadedTargetModules.put((String)loadedModuleEntry.get("id"), loadedModuleEntry.get("version"));
        }
        Map<String, Object> targetModulesConfig = deploymentManager.getModuleConfigurationsOfDeploymentSystem(userSession, deploymentSystemId, deploymentSide);
        targetModulesConfig.put("maintenanceModeEnabled", targetModulesConfig.getOrDefault("maintenanceModeEnabled", deploymentSystemStatus.get("maintenanceModeEnabled")));
        targetModulesConfig.put("loadedModules", loadedTargetModules);
        return targetModulesConfig;
    }

    private Map<String, Object> getModulesConfigFromBackup(DeploymentManager deploymentManager, UserSession userSession, String deploymentSystemId, DeploymentSide deploymentSide, Map<String, Object> deploymentSystemStatus, String snapshotName) throws ModuleNotFoundException, ModuleInstanceNotFoundException, DeploymentSystemException, ServiceNotFoundException, IOException {
        LOG.info("getModulesConfigFromBackup deploymentManager=..., userSession=" + userSession + ", deploymentSystemId=" + deploymentSystemId + ", deploymentSide=" + deploymentSide + ", deploymentSystemStatus=" + deploymentSystemStatus + ", snapshotName=" + snapshotName);
        HashMap loadedTargetModules = new HashMap();
        for (Object loadedModuleObject : (List)deploymentSystemStatus.get("loadedModules")) {
            Map loadedModuleEntry = (Map)loadedModuleObject;
            loadedTargetModules.put((String)loadedModuleEntry.get("id"), loadedModuleEntry.get("version"));
        }
        Map<String, Object> targetModulesConfig = deploymentManager.getModuleConfigurationsOfDeploymentSystemFromBackup(userSession, deploymentSystemId, deploymentSide, snapshotName);
        targetModulesConfig.put("maintenanceModeEnabled", targetModulesConfig.getOrDefault("maintenanceModeEnabled", deploymentSystemStatus.get("maintenanceModeEnabled")));
        targetModulesConfig.put("loadedModules", loadedTargetModules);
        return targetModulesConfig;
    }

    public static int getModelVersion(Map<String, Object> targetModulesConfig) {
        int modelVersion = -1;
        try {
            Object modelVersionObject;
            Object metadataObject;
            if (targetModulesConfig != null && (metadataObject = targetModulesConfig.get("metadata")) instanceof Map && (modelVersionObject = ((Map)metadataObject).get("modelVersion")) instanceof Number) {
                modelVersion = ((Number)modelVersionObject).intValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modelVersion;
    }

    private boolean checkModelVersionsForMigration(int sourceModelVersion, int targetModelVersion) throws DeploymentSystemException {
        if (sourceModelVersion == -1) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_MODEL_VERSION_ERROR, DeploymentSide.Source, "CORE_ERROR_DEPLOYMENT_MISSING_MODEL_VERSION");
        }
        if (targetModelVersion == -1) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_MODEL_VERSION_ERROR, DeploymentSide.Target, "CORE_ERROR_DEPLOYMENT_MISSING_MODEL_VERSION");
        }
        if (sourceModelVersion > targetModelVersion) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_MODEL_VERSION_ERROR, DeploymentSide.Unknown, "CORE_ERROR_DEPLOYMENT_MODEL_VERSIONS_DIFFER", MapUtil.mapOf("sourceModelVersion", sourceModelVersion, "targetModelVersion", targetModelVersion));
        }
        if (sourceModelVersion < BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcConfigurationIndex()) {
            throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_MODEL_VERSION_ERROR, DeploymentSide.Source, "CORE_ERROR_DEPLOYMENT_MODEL_VERSION_NOT_SUPPORTED", MapUtil.mapOf("sourceModelVersion", sourceModelVersion, "lowestSupportedModelVersion", BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcConfigurationIndex()));
        }
        return sourceModelVersion < targetModelVersion;
    }

    @GET
    @Path(value="/diff")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_GET_DIFF", message="Not allowed to use deployment")
    public Response getDeploymentData(@QueryParam(value="source") String sourceDeploymentSystemId, @QueryParam(value="target") String targetDeploymentSystemId, @QueryParam(value="snapshot") String sourceSnapshotName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getDeploymentData sourceDeploymentSystemId=" + sourceDeploymentSystemId + ", targetDeploymentSystemId=" + targetDeploymentSystemId + ", sourceSnapshotName=" + sourceSnapshotName);
        try {
            boolean sourceConfigMigrationNecessary;
            Map<String, Object> targetModulesConfig;
            Map<String, Object> sourceModulesConfig;
            Map<String, Object> targetStatus;
            Map<String, Object> sourceStatus;
            if (StringUtil.isNullOrEmpty(sourceDeploymentSystemId)) {
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Unknown, "Query parameter 'source' must be set.");
            }
            if (StringUtil.isNullOrEmpty(targetDeploymentSystemId)) {
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Unknown, "Query parameter 'target' must be set.");
            }
            if (StringUtil.isNullOrEmpty(sourceSnapshotName) && sourceDeploymentSystemId.equals(targetDeploymentSystemId)) {
                throw new DeploymentSystemException((ErrorCode)CoreErrorCode.DEPLOYMENT_SYSTEM_UNEXPECTED_ERROR, DeploymentSide.Unknown, "Query parameters 'source' and 'target' must be different.");
            }
            DeploymentManager deploymentManager = this.deploymentManagerTracker.getService();
            if (!StringUtil.isNullOrEmpty(sourceSnapshotName) && !targetDeploymentSystemId.equals(JSON_TARGET_ID)) {
                sourceStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                targetStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, targetDeploymentSystemId, DeploymentSide.Target);
                sourceModulesConfig = this.getModulesConfigFromBackup(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceStatus, sourceSnapshotName);
                targetModulesConfig = this.getModulesConfig(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, targetStatus);
                sourceConfigMigrationNecessary = this.checkModelVersionsForMigration(DeploymentEndpoint.getModelVersion(sourceModulesConfig), DeploymentEndpoint.getModelVersion(targetModulesConfig));
                if (sourceConfigMigrationNecessary) {
                    sourceModulesConfig = this.getMigratedSourceModulesConfigFromDeploymentSystem(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, sourceModulesConfig);
                }
            } else if (!StringUtil.isNullOrEmpty(sourceSnapshotName) && targetDeploymentSystemId.equals(JSON_TARGET_ID)) {
                sourceStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                sourceModulesConfig = this.getModulesConfigFromBackup(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceStatus, sourceSnapshotName);
                sourceConfigMigrationNecessary = this.checkModelVersionsForMigration(DeploymentEndpoint.getModelVersion(sourceModulesConfig), this.moduleManagerTracker.getService().getModelVersionOfBpcConfigurationIndex());
                if (sourceConfigMigrationNecessary) {
                    sourceModulesConfig = this.getMigratedSourceModulesConfigFromDeploymentSystem(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceModulesConfig);
                }
                targetStatus = this.createEmptyStatusOfDeploymentSystemForJsonExport();
                targetModulesConfig = this.createEmptyModulesConfigForJsonExport(sourceModulesConfig);
            } else if (sourceDeploymentSystemId.equals(JSON_TARGET_ID)) {
                sourceStatus = this.createEmptyStatusOfDeploymentSystemForJsonExport();
                targetStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, targetDeploymentSystemId, DeploymentSide.Target);
                targetModulesConfig = this.getModulesConfig(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, targetStatus);
                sourceModulesConfig = this.createEmptyModulesConfigForJsonExport(targetModulesConfig);
            } else if (targetDeploymentSystemId.equals(JSON_TARGET_ID)) {
                sourceStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                targetStatus = this.createEmptyStatusOfDeploymentSystemForJsonExport();
                sourceModulesConfig = this.getModulesConfig(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceStatus);
                targetModulesConfig = this.createEmptyModulesConfigForJsonExport(sourceModulesConfig);
            } else {
                sourceStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                targetStatus = deploymentManager.getStatusOfDeploymentSystem(userSession, targetDeploymentSystemId, DeploymentSide.Target);
                sourceModulesConfig = this.getModulesConfig(deploymentManager, userSession, sourceDeploymentSystemId, DeploymentSide.Source, sourceStatus);
                targetModulesConfig = this.getModulesConfig(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, targetStatus);
                sourceConfigMigrationNecessary = this.checkModelVersionsForMigration(DeploymentEndpoint.getModelVersion(sourceModulesConfig), DeploymentEndpoint.getModelVersion(targetModulesConfig));
                if (sourceConfigMigrationNecessary) {
                    sourceModulesConfig = this.getMigratedSourceModulesConfigFromDeploymentSystem(deploymentManager, userSession, targetDeploymentSystemId, DeploymentSide.Target, sourceModulesConfig);
                }
            }
            deploymentManager.enrichModuleConfigurationsWithDeploymentConstraints(sourceModulesConfig);
            DeploymentDiffer differ = new DeploymentDiffer((List)sourceModulesConfig.get("modules"), (List)targetModulesConfig.get("modules"));
            Map<String, Object> bundles = null;
            if (!sourceDeploymentSystemId.equals(JSON_TARGET_ID) && !targetDeploymentSystemId.equals(JSON_TARGET_ID) && StringUtil.isNullOrEmpty(sourceSnapshotName)) {
                DeploymentBundlesDiffer bundlesDiffer = new DeploymentBundlesDiffer(sourceStatus, targetStatus);
                bundles = MapUtil.mapOf("source", bundlesDiffer.getSourceBundles(), "target", bundlesDiffer.getTargetBundles(), "diff", bundlesDiffer.getBundlesDiff());
            }
            Map<String, Object> indices = null;
            if (!sourceDeploymentSystemId.equals(JSON_TARGET_ID) && !targetDeploymentSystemId.equals(JSON_TARGET_ID) && StringUtil.isNullOrEmpty(sourceSnapshotName)) {
                try {
                    Map<String, IndexInfo> sourceIndices = deploymentManager.getOpenSearchIndexInfos(userSession, sourceDeploymentSystemId, DeploymentSide.Source);
                    Map<String, IndexInfo> targetIndices = deploymentManager.getOpenSearchIndexInfos(userSession, targetDeploymentSystemId, DeploymentSide.Target);
                    DeploymentIndicesDiffer indicesDiffer = new DeploymentIndicesDiffer(sourceIndices, targetIndices);
                    indices = MapUtil.mapOf("source", indicesDiffer.getSourceIndices().values(), "target", indicesDiffer.getTargetIndices().values(), "diff", indicesDiffer.getIndicesDiff());
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Failed to get the OpenSearch indices from the involved deployment systems. Maybe one of them is older and does not support it. Deployment of indices gets disabled.", ex);
                }
            }
            HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
            result.put("source", sourceModulesConfig);
            result.put("target", targetModulesConfig);
            result.put("diff", differ.getModulesDiff());
            if (bundles != null) {
                result.put("bundles", bundles);
            }
            if (indices != null) {
                result.put("indices", indices);
            }
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the module configurations.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/diff/settings")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_GET_SETTINGS_DIFF", message="Not allowed to use deployment")
    public Response getSettingsDiff(Map<String, Object> sourceAndTargetSettings, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getSettingsDiff");
        try {
            List sourceSettings = (List)sourceAndTargetSettings.get("source");
            List targetSettings = (List)sourceAndTargetSettings.get("target");
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("source", sourceSettings);
            result.put("target", targetSettings);
            DeploymentSettingsDiffer differ = new DeploymentSettingsDiffer(sourceSettings, targetSettings);
            if (!differ.areSettingsEqual()) {
                result.put("diff", differ.getSettingsDiff());
            } else {
                result.put("diff", new HashMap());
            }
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while creating the settings diff.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/deploy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    public Response deploy(@QueryParam(value="deploymentSourceId") String sourceDeploymentSystemId, @QueryParam(value="deploymentTargetId") String targetDeploymentSystemId, @QueryParam(value="enableMaintenanceMode") @DefaultValue(value="false") boolean enableMaintenanceMode, @QueryParam(value="validate") @DefaultValue(value="true") boolean validate, DeploymentDataImpl deploymentData, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("deploy sourceDeploymentSystemId=" + sourceDeploymentSystemId + ", targetDeploymentSystemId=" + targetDeploymentSystemId + ", enabledMaintenanceMode=" + enableMaintenanceMode + ", validate=" + validate);
        try {
            if (JSON_TARGET_ID.equals(targetDeploymentSystemId)) {
                return Response.ok((Object)deploymentData, (MediaType)MediaType.APPLICATION_JSON_TYPE).header("Content-Disposition", (Object)"attachment; filename=bpcDeployment.json").build();
            }
            Map<String, Object> targetResponse = this.deploymentManagerTracker.getService().deploy(userSession, sourceDeploymentSystemId, targetDeploymentSystemId, deploymentData, enableMaintenanceMode, validate);
            return Response.ok(targetResponse).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception during deployment.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    public Response importDeployment(@QueryParam(value="enableMaintenanceMode") @DefaultValue(value="false") boolean enableMaintenanceMode, @QueryParam(value="validate") @DefaultValue(value="true") boolean validate, DeploymentDataImpl deploymentData, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("importDeployment enableMaintenanceMode=" + enableMaintenanceMode + ", validate=" + validate);
        try {
            this.deploymentManagerTracker.getService().importDeployment(userSession, new DeploymentInitiatorImpl(hh), deploymentData, enableMaintenanceMode, validate);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while importing a deployment.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/bundles/download")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    public Response downloadBundles(List<Number> bundleIDs, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("downloadBundles bundleIDs=" + bundleIDs);
        try {
            ArrayList<Long> convertedBundleIDs = new ArrayList<Long>();
            for (Number bundleID : bundleIDs) {
                long bundleId = bundleID.longValue();
                if (convertedBundleIDs.contains(bundleId)) continue;
                convertedBundleIDs.add(bundleId);
            }
            MimeMultipartData bundlesAsMultipartData = this.deploymentManagerTracker.getService().getBundlesAsMultipartData(convertedBundleIDs);
            return Response.ok((Object)bundlesAsMultipartData).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while importing a deployment.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/bundles/download/{bundleId}")
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    public Response downloadBundle(@PathParam(value="bundleId") String bundleId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("downloadBundle bundleId=" + bundleId);
        try {
            Bundle bundle = null;
            try {
                bundle = this.bundleContext.getBundle(Long.parseLong(bundleId));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bundle != null) {
                String bundleFileLocation = bundle.getLocation();
                if (bundleFileLocation.startsWith("file:")) {
                    URI bundleFileURI = new URI(bundleFileLocation);
                    String bundleFileName = Paths.get(bundleFileURI).getFileName().toString();
                    final File bundleFile = new File(bundleFileURI);
                    String bundleFileContentType = Files.probeContentType(bundleFile.toPath());
                    if (bundleFileContentType == null) {
                        bundleFileContentType = "application/java-archive";
                    }
                    StreamingOutput bundleFileOutputStream = new StreamingOutput(){

                        public void write(OutputStream output) throws IOException, WebApplicationException {
                            try (FileInputStream input = new FileInputStream(bundleFile);){
                                IOUtils.copy((InputStream)input, (OutputStream)output);
                                output.flush();
                            }
                            catch (Exception ex) {
                                throw new WebApplicationException("Bundle download/streaming failed.", (Throwable)ex);
                            }
                        }
                    };
                    return Response.ok((Object)bundleFileOutputStream, (String)bundleFileContentType).header("Content-Disposition", (Object)("attachment; filename=\"" + bundleFileName + "\"")).build();
                }
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_BUNDLE_NOT_DOWNLOADABLE, "The bundle with the ID '{bundleId}' cannot be downloaded, it uses an unknown location prefix (expecting 'file:'): {bundleFileLocation}", Map.of("bundleId", bundleId, "bundleFileLocation", bundleFileLocation));
            }
            throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_BUNDLE_NOT_FOUND, "The bundle with the ID '{bundleId}' does not exist.", Map.of("bundleId", bundleId));
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while downloading bundle content.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/bundles/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    public Response importBundles(List<Attachment> attachments, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("importBundles attachments=" + attachments);
        try {
            this.deploymentManagerTracker.getService().importBundles(userSession, new DeploymentInitiatorImpl(hh), attachments);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while importing bundle files.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/bundles/import/extjs")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_EXECUTE", message="Not allowed to use deployment")
    public Response importBundlesOrLicenseFileFromExtJs(List<Attachment> attachments, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("importBundlesOrLicenseFileFromExtJs attachments=" + attachments);
        String uploadFieldName = "module_bundle";
        try {
            if (attachments == null || attachments.size() != 1) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_FILE_NOT_UPLOADABLE, "Module bundle or 'license.xml.bpc' upload with no or multiple attachments is not possible.");
            }
            Attachment attachment = attachments.get(0);
            String name = attachment.getContentDisposition().getParameter("name");
            String filename = attachment.getContentDisposition().getParameter("filename");
            LOG.info("Uploaded attachment name:" + name + ", filename:" + filename + ", content-type:" + attachment.getContentType());
            if (!uploadFieldName.equals(name)) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_FILE_NOT_UPLOADABLE, "Invalid file upload. Attachment name is '" + name + "' and not '" + uploadFieldName + "'.");
            }
            if ("license.xml.bpc".equals(filename)) {
                this.deploymentManagerTracker.getService().importXmlFileLicense(userSession, new DeploymentInitiatorImpl(hh), attachment);
            } else if (SetUtil.setOf("jar", "war", "kar").contains(this.extractFileExtension(filename).toLowerCase())) {
                this.deploymentManagerTracker.getService().importBundles(userSession, new DeploymentInitiatorImpl(hh), attachments);
            } else {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_FILE_NOT_UPLOADABLE, "Invalid module bundle or license file upload. Only jar/war/kar and 'license.xml.bpc' files can be uploaded.");
            }
            return this.extJsFormSuccessResponse(filename);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while importing module bundle or license file.", ex);
            return this.extJsFormErrorResponse(uploadFieldName, ex.getLocalizedMessage());
        }
    }

    private String extractFileExtension(String filename) {
        int lastDotIdx;
        if (filename != null && (lastDotIdx = filename.lastIndexOf(46)) != -1) {
            return filename.substring(lastDotIdx + 1);
        }
        return "";
    }

    private Response extJsFormSuccessResponse(String filename) {
        HashMap<String, Object> successResp = new HashMap<String, Object>();
        successResp.put("success", true);
        successResp.put("file", filename);
        return Response.ok(successResp).build();
    }

    public Response extJsFormErrorResponse(String uploadFieldName, String errorMessage) {
        return Response.ok(MapUtil.mapOf("success", false, "msg", errorMessage)).build();
    }

    @POST
    @Path(value="/migrate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_GET_MIGRATED_MODULES_CONFIG", message="Not allowed to use deployment")
    public Response migrateModulesConfig(@Context UserSession userSession, @Context HttpHeaders hh, Map<String, Object> modulesConfig) {
        LOG.info("migrateModulesConfig");
        try {
            Map<String, Object> migratedModulesConfig = this.deploymentManagerTracker.getService().migrateModulesConfig(userSession, new DeploymentInitiatorImpl(hh), modulesConfig);
            return Response.ok(migratedModulesConfig).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while migrating a modules config for deployment.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/index/{index}/copy")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_COPY_INDEX", message="Not allowed to use deployment")
    public Response copyIndex(@PathParam(value="index") String indexName, @QueryParam(value="source") String sourceDeploymentSystemId, @QueryParam(value="target") String targetDeploymentSystemId, @QueryParam(value="blocksize") @DefaultValue(value="2500") int blockSize, @QueryParam(value="deleteOnTarget") @DefaultValue(value="false") boolean deleteIndexOnTarget, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("copyIndex indexName=" + indexName + ", sourceDeploymentSystemId=" + sourceDeploymentSystemId + ", targetDeploymentSystemId=" + targetDeploymentSystemId + ", deleteIndexOnTarget=" + deleteIndexOnTarget);
        try {
            this.deploymentManagerTracker.getService().copyIndex(userSession, indexName, sourceDeploymentSystemId, targetDeploymentSystemId, blockSize, deleteIndexOnTarget);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while copying an index from one deployment system to another.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/indices")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_LIST_INDICES", message="Not allowed to use deployment")
    public Response getIndexInfos(@Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getIndexInfos");
        try {
            Map<String, IndexInfo> indexInfos = this.openSearchServiceTracker.getService().getIndexInfos();
            return Response.ok(indexInfos).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while getting the list of indices.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/index/{index}/info")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_DOWNLOAD_INDEX", message="Not allowed to use deployment")
    public Response getIndexInfo(@PathParam(value="index") String indexName, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("getIndexInfo indexName=" + indexName);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            if (!oss.existsIndex(indexName)) {
                throw new OpenSearchIndexNotFoundException(indexName);
            }
            if (!oss.getIndexNamesWithAlias(indexName).isEmpty()) {
                throw new OpenSearchRelatedException((ErrorCode)CoreErrorCode.OPENSEARCH_EXCEPTION, "Please provide an index name instead of an alias: {alias}", MapUtil.mapOf("alias", indexName));
            }
            DeploymentIndexInfo indexInfo = new DeploymentIndexInfo(indexName, oss.getAliasesForIndexName(indexName), oss.getSettings(indexName), oss.getMapping(indexName));
            return Response.ok((Object)indexInfo).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while fetching info of an OpenSearch index.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/index/{index}/download")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_DOWNLOAD_INDEX", message="Not allowed to use deployment")
    public Response downloadFirstIndexBlock(@PathParam(value="index") String indexName, @QueryParam(value="blocksize") @DefaultValue(value="2500") int blockSize, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("downloadFirstIndexBlock indexName=" + indexName + ", blockSize=" + blockSize);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            SearchRequest searchReq = new SearchRequest().indices(indexName).scroll(new TimeValue(60000L)).source(new SearchSourceBuilder().size(blockSize).query(QueryBuilders.matchAllQuery()));
            SearchResponse searchResponse = oss.getClient().search(searchReq, RequestOptions.DEFAULT);
            DeploymentIndexData indexData = new DeploymentIndexData(indexName, searchResponse.getScrollId(), this.extractData(searchResponse));
            return Response.ok((Object)indexData).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while downloading the first block of an OpenSearch index.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/index/{index}/download/{scrollid}")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_DOWNLOAD_INDEX", message="Not allowed to use deployment")
    public Response downloadSubsequentIndexBlock(@PathParam(value="index") String indexName, @PathParam(value="scrollid") String scrollId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("downloadSubsequentIndexBlock indexName=" + indexName + ", scrollId=" + scrollId);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            SearchResponse searchResponse = oss.getClient().scroll(new SearchScrollRequest(scrollId).scroll(new TimeValue(600000L)), RequestOptions.DEFAULT);
            DeploymentIndexData indexData = new DeploymentIndexData(indexName, searchResponse.getScrollId(), this.extractData(searchResponse));
            return Response.ok((Object)indexData).build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while downloading the subsequent content of an OpenSearch index.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    List<Map<String, Object>> extractData(SearchResponse searchResponse) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (searchResponse != null) {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                result.add(Map.of("id", hit.getId(), "source", hit.getSourceAsMap()));
            }
        }
        return result;
    }

    @DELETE
    @Path(value="/index/{index}/download/{scrollid}")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_DOWNLOAD_INDEX", message="Not allowed to use deployment")
    public Response releaseScrollId(@PathParam(value="index") String indexName, @PathParam(value="scrollid") String scrollId, @Context UserSession userSession, @Context HttpHeaders hh) {
        LOG.info("releaseScrollId indexName=" + indexName + ", scrollId=" + scrollId);
        try {
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            oss.releaseScrollId(scrollId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while releasing the scroll identifier of an index download.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/index/{index}/prepare")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_UPLOAD_INDEX", message="Not allowed to use deployment")
    public Response prepareIndexForUpload(@PathParam(value="index") String indexName, @QueryParam(value="delete_existing") @DefaultValue(value="false") boolean deleteExistingIndex, @Context UserSession userSession, @Context HttpHeaders hh, byte[] postBodyInBytes) {
        LOG.info("prepareIndexForUpload indexName=" + indexName);
        try {
            String postBodyAsString = GZipContentUtil.getContentAsString(postBodyInBytes, hh);
            Map<String, Object> indexInfo = JsonUtil.getInstance().jsonStringAsMap(postBodyAsString);
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            if (indexInfo == null || !indexInfo.containsKey("settings") || !indexInfo.containsKey("mapping")) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "Index preparation failed. Data is missing or invalid.");
            }
            if (!(indexInfo.get("settings") instanceof Map)) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "Index preparation failed. Data is invalid.");
            }
            if (!(indexInfo.get("mapping") instanceof Map)) {
                throw new DeploymentException((ErrorCode)CoreErrorCode.DEPLOYMENT_DATA_MISSING, "Index preparation failed. Data is invalid.");
            }
            if (deleteExistingIndex) {
                if (oss.existsIndex(indexName)) {
                    Set<String> indexNames = oss.getIndexNamesWithAlias(indexName);
                    for (String name : indexNames) {
                        oss.deleteIndex(name);
                    }
                }
            } else if (oss.existsIndex(indexName)) {
                throw new OpenSearchRelatedException((ErrorCode)CoreErrorCode.OPENSEARCH_EXCEPTION, "Index exists already: {index}", MapUtil.mapOf("index", indexName));
            }
            Map settings = (Map)indexInfo.get("settings");
            Map mapping = (Map)indexInfo.get("mapping");
            settings.remove("creation_date");
            settings.remove("provided_name");
            settings.remove("uuid");
            settings.remove("version");
            oss.createIndex(indexName, settings, mapping);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while preparing the index for upload.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/index/{index}/upload")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="DEPLOYMENT_USER", right="DEPLOYMENT_UPLOAD_INDEX", message="Not allowed to use deployment")
    public Response uploadIndexData(@PathParam(value="index") String indexName, @Context UserSession userSession, @Context HttpHeaders hh, byte[] postBodyInBytes) {
        LOG.info("uploadIndexData indexName=" + indexName + ", dataEntries=...");
        try {
            String postBodyAsString = GZipContentUtil.getContentAsString(postBodyInBytes, hh);
            List dataEntries = JsonUtil.getInstance().jsonStringAsList(postBodyAsString);
            OpenSearchService oss = this.openSearchServiceTracker.getService();
            if (!oss.existsIndex(indexName)) {
                throw new OpenSearchRelatedException((ErrorCode)CoreErrorCode.OPENSEARCH_EXCEPTION, "Upload failed. The index '{index}' does not exist.", MapUtil.mapOf("index", indexName));
            }
            Set<String> indexNamesForAlias = oss.getIndexNamesWithAlias(indexName);
            if (indexNamesForAlias.size() == 0) {
                throw new OpenSearchRelatedException((ErrorCode)CoreErrorCode.OPENSEARCH_EXCEPTION, "Upload failed. Please provide an alias instead of an real index name: {index}", MapUtil.mapOf("index", indexName));
            }
            if (indexNamesForAlias.size() > 1) {
                throw new OpenSearchRelatedException((ErrorCode)CoreErrorCode.OPENSEARCH_EXCEPTION, "Upload failed. Please be sure that the alias '{alias}' is assigned to one index only.", MapUtil.mapOf("alias", indexName));
            }
            if (dataEntries != null && dataEntries.size() > 0) {
                BulkResponse bulkResponse;
                BulkRequest bulkRequest = new BulkRequest().timeout(TimeValue.timeValueSeconds(60L));
                for (Map dataEntry : dataEntries) {
                    String id = (String)dataEntry.get("id");
                    Map source = (Map)dataEntry.get("source");
                    bulkRequest.add(new IndexRequest(indexName).id(id).source(source, XContentType.JSON));
                }
                if (bulkRequest.numberOfActions() > 0 && (bulkResponse = oss.getClient().bulk(bulkRequest, RequestOptions.DEFAULT)).hasFailures()) {
                    throw new OpenSearchRelatedException((ErrorCode)CoreErrorCode.OPENSEARCH_EXCEPTION, "Indexing of uploaded data failed: ${error}", MapUtil.mapOf("error", bulkResponse.buildFailureMessage()));
                }
            }
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception while uploading index data.", ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

