/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.license;

import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.License;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.LicenseKey;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.license.NoLicense;
import de.virtimo.bpc.core.license.XmlFileLicense;
import de.virtimo.bpc.core.notification.ExpirationNotificationSettings;
import de.virtimo.bpc.core.utils.FelixFileinstallUtil;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.license.Validator;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;

public class LicenseServiceImpl
implements LicenseService,
BpcService {
    private static final Logger LOG = Logger.getLogger(LicenseServiceImpl.class.getName());
    public static final Integer DEFAULT_APPLICATION_LIMIT = 0;
    public static final Integer DEFAULT_CONCURRENT_USER_LIMIT = 5;
    private final BundleContext bundleContext;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final EventRegistration eventRegistration;
    private License license;

    public LicenseServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.license = new NoLicense();
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("_core", new CoreModuleLoadedEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        BpcServicesTracker.stopAll(this);
        this.eventRegistration.unregisterAllEventHandler();
    }

    @Override
    public boolean isLicenseSet() {
        return this.license != null && !(this.license instanceof NoLicense);
    }

    @Override
    public License getLicense() {
        return this.license;
    }

    @Override
    public void setLicense(License license) throws LicenseException, ServiceNotFoundException {
        LOG.info("setLicense license=" + license);
        if (license == null) {
            license = new NoLicense();
        }
        if (license.isExpired()) {
            throw new LicenseException((ErrorCode)CoreErrorCode.LICENSE_EXPIRED, "License expired on ${expirationDate}", MapUtil.mapOf("expirationDate", license.getValue(LicenseKey.LICENSE_EXPIRATION_DATE)));
        }
        this.license = license;
        this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/licenseChanged", DictionaryUtil.dictionaryOf("license", license));
    }

    @Override
    public void loadAndSetLicense(File licenseFile) {
        LOG.info("loadAndSetLicense licenseFile=" + licenseFile);
        try {
            License license;
            if (licenseFile == null) {
                File deployFolder = FelixFileinstallUtil.getDeployFolder(this.bundleContext);
                licenseFile = new File(deployFolder, "license.xml.bpc");
            }
            if ((license = this.loadAndValidateLicense(licenseFile)) != null) {
                this.setLicense(license);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to set the BPC license", e);
        }
    }

    private License loadAndValidateLicense(File licenseFile) {
        LOG.info("loadAndValidateLicense licenseFile=" + licenseFile);
        try {
            URL publicKeyResourcesURL = this.bundleContext.getBundle().getResource("defaults/core/public.key");
            Validator validator = new Validator(publicKeyResourcesURL);
            if (validator.isValid(licenseFile)) {
                return new XmlFileLicense(licenseFile);
            }
            LOG.log(Level.SEVERE, "The BPC license 'license.xml.bpc' loaded from the Karaf deploy folder is invalid.");
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.WARNING, "The BPC license 'license.xml.bpc' is missing in the Karaf deploy folder.");
        }
        catch (Throwable ex) {
            LOG.log(Level.SEVERE, "Failed to load the BPC license 'license.xml.bpc' from the Karaf deploy folder.", ex);
        }
        return null;
    }

    @Override
    public Integer getInstanceLimit(InstantiableModule instantiableModule) {
        Map moduleInstanceLimitMap;
        LOG.info("getInstanceLimit module=" + instantiableModule);
        if (instantiableModule != null && (moduleInstanceLimitMap = (Map)this.getLicense().getValue(LicenseKey.MODULE_INSTANCE_LIMIT.name())) != null && moduleInstanceLimitMap.containsKey(instantiableModule.getModuleId())) {
            int currentLimit = 0;
            Object limitValue = moduleInstanceLimitMap.get(instantiableModule.getModuleId());
            if (limitValue instanceof Integer) {
                currentLimit = (Integer)limitValue;
            } else if (limitValue instanceof String) {
                currentLimit = Integer.parseInt((String)limitValue);
            }
            return currentLimit;
        }
        return null;
    }

    @Override
    public Integer getConcurrentUserLimit() {
        LOG.info("getConcurrentUserLimit");
        try {
            Object concurrentUserLimitObject = this.getLicense().getValue(LicenseKey.CONCURRENT_USER_LIMIT.name());
            if (concurrentUserLimitObject instanceof Number) {
                return ((Number)concurrentUserLimitObject).intValue();
            }
            if (concurrentUserLimitObject instanceof String) {
                return Integer.parseInt((String)concurrentUserLimitObject);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to get the concurrent user limit from the license.", ex);
        }
        return DEFAULT_CONCURRENT_USER_LIMIT;
    }

    @Override
    public ExpirationNotificationSettings getLicenseExpirationNotificationSettings() throws ServiceNotFoundException, ModuleNotFoundException {
        LOG.info("getLicenseExpirationNotificationSettings");
        try (BpcServicesTracker<ModuleManager> moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);){
            CoreModule coreModule = (CoreModule)moduleManagerTracker.getService().getModuleById("_core");
            ExpirationNotificationSettings expirationNotificationSettings = ExpirationNotificationSettings.of(coreModule.getConfiguration().getSetting("licenseNotifications"));
            return expirationNotificationSettings;
        }
    }

    @Override
    public Map<String, Object> getLicenseDetails() {
        LOG.info("getLicenseDetails");
        return this.getLicenseDetails(this.license);
    }

    @Override
    public Map<String, Object> getLicenseDetails(License license) {
        LOG.info("getLicenseDetails license=...");
        HashMap<String, Object> licenceApplicationKeyMap = new HashMap<String, Object>();
        HashMap<String, Object> licenceModuleKeyMap = new HashMap<String, Object>();
        HashMap<String, Object> licenceOtherKeyMap = new HashMap<String, Object>();
        for (String lk : license.getLicenseKeys()) {
            if (lk.startsWith("APPLICATION_")) {
                licenceApplicationKeyMap.put(lk, license.getValue(lk));
                continue;
            }
            if (lk.startsWith("MODULE_")) {
                licenceModuleKeyMap.put(lk, license.getValue(lk));
                continue;
            }
            licenceOtherKeyMap.put(lk, license.getValue(lk));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("application", licenceApplicationKeyMap);
        result.put("module", licenceModuleKeyMap);
        result.put("other", licenceOtherKeyMap);
        return result;
    }

    private class CoreModuleLoadedEventHandler
    extends AbstractBackendModuleLoadedEventHandler {
        private CoreModuleLoadedEventHandler() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOG.info(this.getClass().getSimpleName() + ".processLoadedModule module=...");
            LicenseServiceImpl.this.loadAndSetLicense(null);
        }
    }
}

