/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.BpcIndexCreateCallable;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.notification.NotificationData;
import de.virtimo.bpc.core.notification.NotificationException;
import de.virtimo.bpc.core.notification.NotificationNotFoundException;
import de.virtimo.bpc.core.notification.Notifications;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;

public class NotificationPersistenceHandler {
    private static final Logger LOG = Logger.getLogger(NotificationPersistenceHandler.class.getName());
    public static final String NOTIFICATION_INDEX_ALIAS_NAME = "bpc-notification";
    private final OpenSearchService oss;

    public NotificationPersistenceHandler(OpenSearchService oss) {
        this.oss = oss;
    }

    public void createBpcNotificationIndexIfMissing() throws NotificationException {
        LOG.fine("createBpcNotificationIndexIfMissing");
        try {
            BpcIndexState bpcNotificationIndexState = this.oss.getIndexState(NOTIFICATION_INDEX_ALIAS_NAME);
            bpcNotificationIndexState.prepareUsing(new BpcIndexCreateCallable(){

                @Override
                public String createIndex(OpenSearchService oss) throws OpenSearchRelatedException, ServiceNotFoundException, ModuleNotFoundException {
                    return oss.getManagedIndicesHandler().createManagedIndex(NotificationPersistenceHandler.NOTIFICATION_INDEX_ALIAS_NAME);
                }
            });
        }
        catch (Exception ex) {
            throw new NotificationException((ErrorCode)CoreErrorCode.NOTIFICATION_FAILED, "Failed to prepare the notification index '${index}'.", MapUtil.mapOf("index", NOTIFICATION_INDEX_ALIAS_NAME), (Throwable)ex);
        }
    }

    public void deleteNotification(String notificationId) throws NotificationNotFoundException, OpenSearchRelatedException {
        LOG.info("deleteNotification notificationId=" + notificationId);
        try {
            DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(NOTIFICATION_INDEX_ALIAS_NAME)).id(notificationId);
            DeleteResponse response = this.oss.getClient().delete(deleteRequest, RequestOptions.DEFAULT);
            if (response == null || response.status() == RestStatus.NOT_FOUND) {
                throw new NotificationNotFoundException(notificationId);
            }
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public Notification loadNotification(String notificationId) throws NotificationNotFoundException, OpenSearchRelatedException {
        LOG.info("loadNotification notificationId=" + notificationId);
        try {
            GetRequest getRequest = ((GetRequest)new GetRequest().index(NOTIFICATION_INDEX_ALIAS_NAME)).id(notificationId);
            GetResponse response = this.oss.getClient().get(getRequest, RequestOptions.DEFAULT);
            if (response == null || !response.isExists()) {
                throw new NotificationNotFoundException(notificationId);
            }
            return this.createNotificationFromOpenSearchSource(response.getVersion(), response.getSourceAsString());
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public Notification saveNotification(Notification notification) throws OpenSearchRelatedException {
        LOG.info("saveNotification notification=...");
        try {
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest().index(NOTIFICATION_INDEX_ALIAS_NAME)).id(notification.getId()).source(JsonUtil.getInstance().convertPojoToJsonString(notification), XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            IndexResponse response = this.oss.getClient().index(indexRequest, RequestOptions.DEFAULT);
            return new Notification.Builder(notification).version(response.getVersion()).build();
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    public Notifications loadNotifications(Integer start, Integer limit, String userName, List<Role> roles, List<Organisation> organisations) throws OpenSearchRelatedException {
        LOG.info("loadNotifications start=" + start + ", limit=" + limit + ", userName=" + userName + ", roles=" + roles + ", organisations=" + organisations);
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            SearchRequest searchRequest = new SearchRequest().indices(NOTIFICATION_INDEX_ALIAS_NAME).source(new SearchSourceBuilder().from(start).size(limit).version(true).query(this.getQuery(userName, roles, organisations)).sort("date", SortOrder.DESC));
            SearchResponse searchResponse = osClient.search(searchRequest, RequestOptions.DEFAULT);
            Notifications notifications = new Notifications(start, limit);
            notifications.setTotalCountFromSource(searchResponse.getHits().getTotalHits().value);
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                String notificationId = hit.getId();
                try {
                    notifications.addData(this.createNotificationFromOpenSearchSource(hit.getVersion(), hit.getSourceAsString()));
                }
                catch (Exception ex) {
                    LOG.warning("Could not create a Notification object from a OpenSearch response hit. Please fix the notification with the ID '" + notificationId + "' in the index 'bpc-notification'.");
                    notifications.addAsIdWithError(notificationId);
                }
            }
            return notifications;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private QueryBuilder getQuery(String userName, List<Role> roles, List<Organisation> organisations) {
        BoolQueryBuilder qb = QueryBuilders.boolQuery();
        if (!StringUtil.isNullOrEmpty(userName)) {
            qb.should(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("recipientsType", "user")).must(QueryBuilders.termQuery("recipients", userName)));
        }
        if (roles != null && !roles.isEmpty()) {
            BoolQueryBuilder oneOfTheRolesQuery = QueryBuilders.boolQuery();
            for (Role role : roles) {
                oneOfTheRolesQuery.should(QueryBuilders.termQuery("recipients", role.getName()));
            }
            qb.should(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("recipientsType", "role")).must(oneOfTheRolesQuery));
        }
        if (organisations != null && !organisations.isEmpty()) {
            BoolQueryBuilder oneOfTheOrganisationsQuery = QueryBuilders.boolQuery();
            for (Organisation organisation : organisations) {
                oneOfTheOrganisationsQuery.should(QueryBuilders.termQuery("recipients", organisation.getName()));
            }
            qb.should(QueryBuilders.boolQuery().must(QueryBuilders.termQuery("recipientsType", "organisation")).must(oneOfTheOrganisationsQuery));
        }
        return qb;
    }

    private Notification createNotificationFromOpenSearchSource(long version, String sourceAsString) throws IOException {
        NotificationData osData = JsonUtil.getInstance().convertJsonStringToPojo(sourceAsString, NotificationData.class);
        return new Notification.Builder(osData).version(version).build();
    }
}

