/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.Broadcast;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BroadcastCollector {
    private static final Logger LOG = Logger.getLogger(BroadcastCollector.class.getName());
    private final Broadcast broadcast;
    private final List<Runnable> entries;

    public BroadcastCollector(EventManager eventManager) throws ServiceNotFoundException {
        this.broadcast = eventManager.broadcast();
        this.entries = new ArrayList<Runnable>();
    }

    public List<Runnable> getEntries() {
        return this.entries;
    }

    public void moduleInstanceCreated(final String moduleId, final String instanceId, final String instanceType) {
        LOG.info("moduleInstanceCreated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceCreated(moduleId, instanceId, instanceType);
            }
        });
    }

    public void moduleUpdated(final String moduleId) {
        LOG.info("moduleUpdated moduleId=" + moduleId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleUpdated(moduleId);
            }
        });
    }

    public void moduleInstanceUpdated(final String moduleId, final String instanceId, final String instanceType) {
        LOG.info("moduleInstanceUpdated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceUpdated(moduleId, instanceId, instanceType);
            }
        });
    }

    public void moduleInstanceDeleted(final String moduleId, final String instanceId) {
        LOG.info("moduleInstanceDeleted moduleId=" + moduleId + ", instanceId=" + instanceId);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceDeleted(moduleId, instanceId);
            }
        });
    }

    public void moduleSettingDeleted(final String moduleId, final String settingName) {
        LOG.info("moduleSettingDeleted moduleId=" + moduleId + ", settingName=" + settingName);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleSettingDeleted(moduleId, settingName);
            }
        });
    }

    public void moduleInstanceSettingDeleted(final String moduleId, final String instanceId, final String instanceType, final String settingName) {
        LOG.info("moduleInstanceSettingDeleted moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType + ", settingName=" + settingName);
        this.entries.add(new Runnable(){

            @Override
            public void run() {
                BroadcastCollector.this.broadcast.moduleInstanceSettingDeleted(moduleId, instanceId, instanceType, settingName);
            }
        });
    }
}

