/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.License;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.NoSuitableConnectionTesterFoundException;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.ModuleConfigurationNotFoundException;
import de.virtimo.bpc.api.exception.ModuleInstanceCreateException;
import de.virtimo.bpc.api.exception.ModuleInstanceExistsAlreadyException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotInstantiableException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import de.virtimo.bpc.core.CoreModule;
import de.virtimo.bpc.core.license.LicenseService;
import de.virtimo.bpc.core.license.NoLicense;
import de.virtimo.bpc.core.opensearch.BroadcastImpl;
import de.virtimo.bpc.core.opensearch.ConnectionTesters;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationImpl;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationPersistenceCallback;
import de.virtimo.bpc.core.opensearch.ModuleConfigurationPersistenceHandler;
import de.virtimo.bpc.core.opensearch.PasswordEncryptorService;
import de.virtimo.bpc.core.opensearch.SettingValidators;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.resource.response.MaskPasswords;
import de.virtimo.bpc.opensearch.plugin.websocket.message.BroadcastWebsocketMessage;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.MapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.Event;

public class ModuleManagerImpl
implements ModuleManager,
ManagedService,
ModuleConfigurationPersistenceCallback,
BpcService {
    private static final Logger LOG = Logger.getLogger(ModuleManagerImpl.class.getName());
    public static final String BPC_CONFIG_INDEX = "bpc-configuration";
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final BpcServicesTracker<PasswordEncryptorService> passwordEncryptorServiceTracker;
    private final BpcServicesTracker<LicenseService> licenseServiceTracker;
    private final EventRegistration eventRegistration;
    private final Map<String, Module> modules;
    private final Set<Module> moduleLoadQueue;
    private final SettingValidators settingValidators;
    private final ConnectionTesters connectionTesters;
    private static final Object ACCESS_MODULES_LOCK = new Object();

    public ModuleManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.modules = new HashMap<String, Module>();
        this.moduleLoadQueue = new HashSet<Module>();
        this.settingValidators = new SettingValidators();
        this.connectionTesters = new ConnectionTesters();
        this.licenseServiceTracker = new BpcServicesTracker<LicenseService>(bundleContext, LicenseService.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.passwordEncryptorServiceTracker = new BpcServicesTracker<PasswordEncryptorService>(bundleContext, PasswordEncryptorService.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forLicenseChangedEvents(new LicenseChangedEventHandler());
        this.eventRegistration.forLicenseExpiredEvents(new LicenseExpiredEventHandler());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOG.info("shutdownService");
        this.settingValidators.destroy();
        this.connectionTesters.destroy();
        this.unloadAllModules();
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public int getModelVersionOfBpcConfigurationIndex() throws ServiceNotFoundException {
        return this.openSearchServiceTracker.getService().getModelVersion(BPC_CONFIG_INDEX);
    }

    private ModuleConfigurationPersistenceHandler getPersistenceHandler() throws ServiceNotFoundException {
        return new ModuleConfigurationPersistenceHandler(this.openSearchServiceTracker.getService(), this.passwordEncryptorServiceTracker.getService());
    }

    @Override
    @NotNull
    public List<SettingValidator> getSettingValidators() {
        return this.settingValidators.getAll();
    }

    @Override
    public void setSettingValidator(SettingValidator settingValidator) {
        LOG.info("setSettingValidator: " + settingValidator);
        this.settingValidators.set(settingValidator);
    }

    @Override
    public void removeSettingValidator(SettingValidator settingValidator) {
        LOG.info("removeSettingValidator: " + settingValidator);
        this.settingValidators.remove(settingValidator);
    }

    @Override
    public List<FrontendWarningException> validateModuleSettings(String moduleId, Collection<Setting> existingSettings, Collection<? extends Setting> settings) throws ValidationException {
        LOG.info("validateModuleSettings moduleId=" + moduleId + ", existingSettings=...., settings=...");
        return this.settingValidators.validateModuleSettings(moduleId, existingSettings, settings);
    }

    @Override
    public List<FrontendWarningException> validateModuleInstanceSettings(String moduleId, String moduleInstanceId, String instanceType, Collection<Setting> existingSettings, Collection<? extends Setting> settings) throws ValidationException {
        LOG.info("validateModuleInstanceSettings moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType + ", existingSettings=...., settings=...");
        return this.settingValidators.validateModuleInstanceSettings(moduleId, moduleInstanceId, instanceType, existingSettings, settings);
    }

    @Override
    @NotNull
    public List<ConnectionTester> getConnectionTesters() {
        return this.connectionTesters.getAll();
    }

    @Override
    public void setConnectionTester(ConnectionTester connectionTester) {
        LOG.info("setConnectionTester: " + connectionTester);
        this.connectionTesters.set(connectionTester);
    }

    @Override
    public void removeConnectionTester(ConnectionTester connectionTester) {
        LOG.info("removeConnectionTester: " + connectionTester);
        this.connectionTesters.remove(connectionTester);
    }

    @Override
    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws NoSuitableConnectionTesterFoundException, ConnectionTestException {
        LOG.info("performConnectionTest moduleInstance=..., testData=...");
        this.connectionTesters.performConnectionTest(moduleInstance, testData);
    }

    private void fireBackendModuleLoadedEvent(Module module) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backendModuleLoaded", DictionaryUtil.dictionaryOf("moduleId", module.getModuleId(), "module", module));
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to fire the module loaded event for module '" + module + "'.", ex);
        }
    }

    private void fireBackendModuleUnloadedEvent(Module module) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backendModuleUnloaded", DictionaryUtil.dictionaryOf("moduleId", module.getModuleId()));
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to fire the module unloaded event for module '" + module + "'.", ex);
        }
    }

    private void fireBackendModuleReloadedEvent(Module module) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backendModuleReloaded", DictionaryUtil.dictionaryOf("moduleId", module.getModuleId(), "module", module));
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to fire the module reloaded event for module '" + module + "'.", ex);
        }
    }

    @Override
    public void setLicense(License license) throws LicenseException, SettingException, ServiceNotFoundException {
        LOG.log(Level.INFO, "Got deprecated licence: " + license);
        LOG.warning("****** You are using an outdated license file. Please contact the Virtimo support to get a new one. ******");
        this.licenseServiceTracker.getService().setLicense(license);
    }

    @Override
    public void deleteModuleInstance(ModuleInstance moduleInstance) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("deleteModuleInstance moduleInstance=" + moduleInstance);
        String moduleId = moduleInstance.getParentModule().getModuleId();
        String instanceId = moduleInstance.getModuleId();
        this.getPersistenceHandler().deleteModuleInstance(moduleId, instanceId);
    }

    @Override
    public void deleteModuleInstance(String moduleId, String instanceId) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("deleteModuleInstance moduleId=" + moduleId + ", instanceId=" + instanceId);
        this.getPersistenceHandler().deleteModuleInstance(moduleId, instanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Module> getLoadedModules() {
        Object object = ACCESS_MODULES_LOCK;
        synchronized (object) {
            return new HashMap<String, Module>(this.modules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Module> getAllModules() {
        Object object = ACCESS_MODULES_LOCK;
        synchronized (object) {
            HashMap<String, Module> allModules = new HashMap<String, Module>();
            allModules.putAll(this.modules);
            for (Module moduleFromQueue : this.moduleLoadQueue) {
                allModules.put(moduleFromQueue.getModuleId(), moduleFromQueue);
            }
            return allModules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Module getModule(String moduleId) {
        Object object = ACCESS_MODULES_LOCK;
        synchronized (object) {
            return this.modules.get(moduleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Module getModuleById(String moduleId) throws ModuleNotFoundException {
        Object object = ACCESS_MODULES_LOCK;
        synchronized (object) {
            Module result = this.modules.get(moduleId);
            if (result == null) {
                throw new ModuleNotFoundException(moduleId);
            }
            return result;
        }
    }

    @Override
    @NotNull
    public <T> T getModuleByClass(Class<T> clazz) throws ModuleNotFoundException {
        Object object = ACCESS_MODULES_LOCK;
        synchronized (object) {
            for (Module module : this.modules.values()) {
                if (!clazz.isInstance(module)) continue;
                return clazz.cast(module);
            }
            throw new ModuleNotFoundException(clazz.getName());
        }
    }

    @Override
    @Deprecated(since="4.0.0", forRemoval=true)
    public ModuleConfiguration getModuleConfiguration(String moduleId) {
        return this.getModule(moduleId).getConfiguration();
    }

    @Override
    public Map<String, ModuleConfiguration> getModuleInstanceConfiguration(InstantiableModule module) throws SettingException, ServiceNotFoundException, OpenSearchRelatedException {
        LOG.info("getModuleInstanceConfiguration: " + module.getModuleId());
        HashMap<String, ModuleConfiguration> result = new HashMap<String, ModuleConfiguration>();
        ModuleConfigurationPersistenceHandler persistenceHandler = this.getPersistenceHandler();
        String moduleId = module.getModuleId();
        Set<String> instanceIDs = persistenceHandler.readModuleInstanceIDs(moduleId);
        for (String instanceId : instanceIDs) {
            Map<String, Setting> instanceSettings = persistenceHandler.readModuleSettings(moduleId, instanceId);
            String instanceType = module.usesInstanceTypes() ? persistenceHandler.readInstanceType(moduleId, instanceId) : "none";
            result.put(instanceId, new ModuleConfigurationImpl(module, instanceId, instanceType, instanceSettings, this));
        }
        return result;
    }

    public static boolean isCantLiveWithoutModule(Module module) {
        return module instanceof CoreModule || module instanceof BackendConnectionsModule || module instanceof ReplicationModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadModule(Module module) throws SettingException, ServiceNotFoundException {
        Module loadedModule;
        LOG.info("loadModule : " + module.getModuleId());
        Object object = ACCESS_MODULES_LOCK;
        synchronized (object) {
            loadedModule = this.notSycnhronized_loadModule(module);
        }
        if (loadedModule != null) {
            this.fireBackendModuleLoadedEvent(module);
        }
    }

    private Module notSycnhronized_loadModule(Module module) throws SettingException, ServiceNotFoundException {
        LOG.info("notSycnhronized_loadModule : " + module.getModuleId());
        if (!ModuleManagerImpl.isCantLiveWithoutModule(module) && !this.licenseServiceTracker.getService().isLicenseSet()) {
            LOG.warning("Due to missing license (at the moment) the '" + module.getModuleId() + "' module gets added to a queue until a license is set.");
            this.moduleLoadQueue.add(module);
            return null;
        }
        this.modules.put(module.getModuleId(), module);
        ModuleConfiguration moduleConfig = this.loadModuleConfiguration(module);
        moduleConfig = this.manageConfigurationPersistence(module, moduleConfig);
        module.setConfiguration(moduleConfig);
        LOG.info("ready loadModule : " + module.getModuleId());
        return module;
    }

    private ModuleConfiguration loadModuleConfiguration(Module module) throws SettingException, ServiceNotFoundException {
        LOG.fine("loadModuleConfiguration module=" + module.getModuleId());
        Map<String, Setting> moduleSettings = this.readModuleSettings(module);
        return new ModuleConfigurationImpl(module, moduleSettings, this);
    }

    private ModuleConfiguration loadModuleInstanceConfiguration(InstantiableModule instantiableModule, String instanceId, String instanceType) throws SettingException, ServiceNotFoundException {
        LOG.fine("loadModuleInstanceConfiguration instantiableModule=" + instantiableModule + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        Map<String, Setting> moduleInstanceSettings = this.readModuleSettings(instantiableModule, instanceId);
        return new ModuleConfigurationImpl(instantiableModule, instanceId, instanceType, moduleInstanceSettings, this);
    }

    private void reloadModule(Module module) throws SettingException, ServiceNotFoundException {
        LOG.info("reloadModule: " + module.getModuleId());
        ModuleConfiguration moduleConfig = this.loadModuleConfiguration(module);
        moduleConfig = this.manageConfigurationPersistence(module, moduleConfig);
        module.setConfiguration(moduleConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadAllModules() throws SettingException, ServiceNotFoundException {
        LOG.info("reloadAllModules");
        ArrayList<Module> reloadedModules = new ArrayList<Module>();
        Iterator iterator = ACCESS_MODULES_LOCK;
        synchronized (iterator) {
            Module coreModule = this.modules.get("_core");
            this.reloadModule(coreModule);
            reloadedModules.add(coreModule);
            for (Module module : this.modules.values()) {
                if ("_core".equalsIgnoreCase(module.getModuleId())) continue;
                this.reloadModule(module);
                reloadedModules.add(module);
            }
            ((CoreModule)coreModule).refreshIdentityProvider();
        }
        for (Module reloadedModule : reloadedModules) {
            this.fireBackendModuleReloadedEvent(reloadedModule);
        }
    }

    @Override
    public ModuleConfiguration manageConfigurationPersistence(Module module, ModuleConfiguration moduleConfiguration) throws SettingException {
        LOG.log(Level.INFO, "manageConfigurationPersistence {0} - {1}", new Object[]{module, moduleConfiguration});
        ModuleConfiguration managedConfig = moduleConfiguration instanceof ModuleConfigurationImpl ? moduleConfiguration : new ModuleConfigurationImpl(module, moduleConfiguration.getSettings(), this);
        try {
            this.getPersistenceHandler().saveSettings(managedConfig.getSettings().values());
        }
        catch (ServiceNotFoundException ex) {
            throw new SettingException((ErrorCode)BpcErrorCode.SERVICE_NOT_FOUND, "Failed to get the required services.", MapUtil.mapOf("error", ex.getMessage()), (Throwable)ex);
        }
        return managedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllModules() {
        LOG.info("unloadAllModules");
        ArrayList<Module> unloadedModules = new ArrayList<Module>();
        Iterator iterator = ACCESS_MODULES_LOCK;
        synchronized (iterator) {
            for (Module module : new ArrayList<Module>(this.modules.values())) {
                Module unloadedModule = this.notSycnhronized_unloadModule(module);
                if (unloadedModule == null) continue;
                unloadedModules.add(module);
            }
        }
        for (Module unloadedModule : unloadedModules) {
            this.fireBackendModuleUnloadedEvent(unloadedModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadModule(Module module) {
        Module unloadedModule;
        LOG.info("unloadModule module=" + module);
        Object object = ACCESS_MODULES_LOCK;
        synchronized (object) {
            unloadedModule = this.notSycnhronized_unloadModule(module);
        }
        if (unloadedModule != null) {
            this.fireBackendModuleUnloadedEvent(module);
        }
    }

    private Module notSycnhronized_unloadModule(Module module) {
        LOG.info("notSycnhronized_unloadModule module=" + module);
        if (module != null) {
            try {
                if (this.modules.containsKey(module.getModuleId())) {
                    module.destroy();
                    this.modules.remove(module.getModuleId());
                    return module;
                }
                LOG.info("The module '" + module + "' is already unloaded.");
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to unload the module: " + module, ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Module, List<ModuleInstance>> getModulesAndModuleInstancesForUserSession(String onlyForThisModuleId, UserSession userSession) {
        if (userSession == null) {
            return null;
        }
        HashMap<Module, List<ModuleInstance>> result = new HashMap<Module, List<ModuleInstance>>();
        Object object = ACCESS_MODULES_LOCK;
        synchronized (object) {
            for (Module module : this.modules.values()) {
                String moduleId = module.getModuleId();
                if (onlyForThisModuleId != null && !onlyForThisModuleId.equals(moduleId) || !userSession.hasLoadModuleRight(moduleId)) continue;
                ArrayList<ModuleInstance> instances = new ArrayList<ModuleInstance>();
                if (module instanceof InstantiableModule) {
                    InstantiableModule instantiableModule = (InstantiableModule)module;
                    instances.addAll(instantiableModule.getUseableModuleInstances(userSession));
                }
                result.put(module, instances);
            }
        }
        return result;
    }

    public void updated(Dictionary dctnr) throws ConfigurationException {
    }

    @Override
    @NotNull
    public Set<String> readModuleInstanceIDs(String moduleId, String instanceType) throws ServiceNotFoundException, OpenSearchRelatedException {
        LOG.fine("readModuleInstanceIDs moduleId=" + moduleId + ", instanceType=" + instanceType);
        return this.getPersistenceHandler().readModuleInstanceIDs(moduleId, instanceType);
    }

    @Override
    public Map<String, Setting> readModuleSettings(String moduleId, String instanceId, String instanceType) throws ServiceNotFoundException, SettingException {
        LOG.info("readModuleSettings moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        return this.getPersistenceHandler().readModuleSettings(moduleId, instanceId, instanceType);
    }

    @Override
    public Map<String, Setting> readModuleSettings(String moduleId, String instanceId) throws ServiceNotFoundException, SettingException {
        LOG.log(Level.INFO, "readModuleSettings moduleId=" + moduleId + ", instanceId=" + instanceId);
        return this.getPersistenceHandler().readModuleSettings(moduleId, instanceId);
    }

    public Map<String, Setting> readModuleSettings(InstantiableModule instantiableModule, String instanceId) throws ServiceNotFoundException, SettingException {
        LOG.log(Level.INFO, "readModuleSettings instantiableModule=" + instantiableModule + ", instanceId=" + instanceId);
        return this.getPersistenceHandler().readModuleSettings(instantiableModule.getModuleId(), instanceId);
    }

    @Override
    public Map<String, Setting> readModuleSettings(Module module) throws ServiceNotFoundException, SettingException {
        String instanceId;
        String moduleId;
        LOG.info("readModuleSettings module=" + module);
        if (module instanceof ModuleInstance) {
            moduleId = ((ModuleInstance)module).getParentModule().getModuleId();
            instanceId = module.getModuleId();
        } else {
            moduleId = module.getModuleId();
            instanceId = "noinstance";
        }
        return this.getPersistenceHandler().readModuleSettings(moduleId, instanceId);
    }

    @Override
    public void onSettingRemoved(Setting setting, ModuleConfiguration initiatedByModuleConfiguration) throws SettingException {
        LOG.fine("onSettingRemoved setting=..., initiatedByModuleConfiguration=...");
        try {
            this.getPersistenceHandler().deleteSetting(setting);
        }
        catch (ServiceNotFoundException ex) {
            throw new SettingException((ErrorCode)BpcErrorCode.SERVICE_NOT_FOUND, "Failed to get the required services.", MapUtil.mapOf("error", ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void onSettingAddedOrUpdated(Setting setting, ModuleConfiguration initiatedByModuleConfiguration) throws SettingException {
        LOG.fine("onSettingAddedOrUpdated setting=..., initiatedByModuleConfiguration=...");
        try {
            boolean ifWasNecessaryToPersistSetting = this.getPersistenceHandler().saveSetting(setting);
            if (ifWasNecessaryToPersistSetting) {
                this.fireModuleUpdatedEventForCreatedOrUpdatedSetting(setting);
            }
        }
        catch (ServiceNotFoundException ex) {
            throw new SettingException((ErrorCode)BpcErrorCode.SERVICE_NOT_FOUND, "Failed to get the required services.", MapUtil.mapOf("error", ex.getMessage()), (Throwable)ex);
        }
    }

    private void fireModuleUpdatedEventForCreatedOrUpdatedSetting(Setting setting) {
        LOG.info("fireModuleUpdatedEventForCreatedOrUpdatedSetting setting=" + setting);
        if (setting != null) {
            String moduleId = setting.getModuleId();
            String instanceId = setting.getInstanceId();
            String instanceType = setting.getInstanceType();
            String settingName = setting.getName();
            LOG.info("Sending moduleUpdated Event for created/updated setting: name=" + settingName + ", moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/Configuration/moduleUpdated", DictionaryUtil.dictionaryOf("moduleId", moduleId, "moduleInstanceId", instanceId, "moduleInstanceType", instanceType == null ? "none" : instanceType, "settingName", settingName, "setting", new MaskPasswords().maskPasswords(Arrays.asList(setting))));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to send moduleUpdated event for the setting:" + setting, ex);
            }
        }
    }

    private void fireModuleUpdatedEventsForCreatedOrUpdatedSettings(ModuleConfiguration oldConfiguration, ModuleConfiguration newConfiguration) {
        LOG.info("fireModuleUpdatedEventsForCreatedOrUpdatedSettings oldConfiguration=..., newConfiguration=...");
        if (oldConfiguration == null) {
            for (Setting setting : newConfiguration.getSettings().values()) {
                this.fireModuleUpdatedEventForCreatedOrUpdatedSetting(setting);
            }
        } else {
            Map<String, Setting> oldSettings = oldConfiguration.getSettings();
            Map<String, Setting> newSettings = newConfiguration.getSettings();
            for (String settingName : newSettings.keySet()) {
                try {
                    Setting newSetting;
                    Setting oldSetting = oldSettings.get(settingName);
                    if (!ModuleConfigurationPersistenceHandler.settingsAreDifferent(oldSetting, newSetting = newSettings.get(settingName))) continue;
                    this.fireModuleUpdatedEventForCreatedOrUpdatedSetting(newSetting);
                }
                catch (SettingException ex) {
                    LOG.log(Level.SEVERE, "Failed to fire a settings created or updated event.", ex);
                }
            }
        }
    }

    public void handleOpenSearchBpcPluginBroadcastWebsocketMessage(BroadcastWebsocketMessage broadcastWebsocketMessage) {
        LOG.info("handleOpenSearchBpcPluginBroadcastWebsocketMessage broadcastWebsocketMessage=" + broadcastWebsocketMessage);
        try {
            Map data = broadcastWebsocketMessage.getData();
            if (broadcastWebsocketMessage.isType(BroadcastImpl.BroadcastType.ModuleInstanceDeleted.name())) {
                this.onBroadcastMessageModuleInstanceDeleted((String)data.get("moduleId"), (String)data.get("moduleInstanceId"));
            } else if (broadcastWebsocketMessage.isType(BroadcastImpl.BroadcastType.ModuleInstanceUpdated.name())) {
                this.onBroadcastMessageModuleInstanceUpdated((String)data.get("moduleId"), (String)data.get("moduleInstanceId"), (String)data.get("moduleInstanceType"));
            } else if (broadcastWebsocketMessage.isType(BroadcastImpl.BroadcastType.ModuleInstanceCreated.name())) {
                this.onBroadcastMessageModuleInstanceCreated((String)data.get("moduleId"), (String)data.get("moduleInstanceId"), (String)data.get("moduleInstanceType"));
            } else if (broadcastWebsocketMessage.isType(BroadcastImpl.BroadcastType.ModuleUpdated.name())) {
                this.onBroadcastMessageModuleUpdated((String)data.get("moduleId"));
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Could not process the broadcast websocket message: " + broadcastWebsocketMessage, t);
        }
    }

    private void onBroadcastMessageModuleInstanceDeleted(String moduleId, String instanceId) throws ModuleNotFoundException, ModuleNotInstantiableException, ModuleInstanceNotFoundException {
        LOG.info("onBroadcastMessageModuleInstanceDeleted moduleId=" + moduleId + ", instanceId=" + instanceId);
        Module module = this.getModuleById(moduleId);
        if (!(module instanceof InstantiableModule)) {
            throw new ModuleNotInstantiableException(moduleId, instanceId);
        }
        InstantiableModule instantiableModule = (InstantiableModule)module;
        ModuleInstance moduleInstance = instantiableModule.getModuleInstanceById(instanceId);
        moduleInstance.deleteInstance();
        instantiableModule.moduleInstanceDeleted(moduleInstance);
    }

    private void onBroadcastMessageModuleInstanceUpdated(String moduleId, String instanceId, String instanceType) throws ModuleNotFoundException, ModuleNotInstantiableException, ModuleInstanceNotFoundException, ModuleConfigurationNotFoundException, SettingException, ServiceNotFoundException {
        LOG.info("onBroadcastMessageModuleInstanceUpdated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        Module module = this.getModuleById(moduleId);
        if (!(module instanceof InstantiableModule)) {
            throw new ModuleNotInstantiableException(moduleId, instanceId);
        }
        InstantiableModule instantiableModule = (InstantiableModule)module;
        ModuleInstance moduleInstance = instantiableModule.getModuleInstanceById(instanceId);
        ModuleConfiguration moduleInstanceConfiguration = this.loadModuleInstanceConfiguration(instantiableModule, instanceId, instanceType);
        ModuleConfiguration oldModuleInstanceConfiguration = moduleInstance.getConfiguration();
        moduleInstance.setConfiguration(moduleInstanceConfiguration);
        instantiableModule.moduleInstanceUpdated(moduleInstance);
        this.fireModuleUpdatedEventsForCreatedOrUpdatedSettings(oldModuleInstanceConfiguration, moduleInstanceConfiguration);
    }

    private void onBroadcastMessageModuleInstanceCreated(String moduleId, String instanceId, String instanceType) throws LicenseException, ModuleNotFoundException, ModuleNotInstantiableException, ModuleInstanceExistsAlreadyException, ModuleInstanceCreateException, ModuleConfigurationNotFoundException, SettingException, ServiceNotFoundException {
        LOG.info("onBroadcastMessageModuleInstanceCreated moduleId=" + moduleId + ", instanceId=" + instanceId + ", instanceType=" + instanceType);
        Module module = this.getModuleById(moduleId);
        if (!(module instanceof InstantiableModule)) {
            throw new ModuleNotInstantiableException(moduleId, instanceId);
        }
        InstantiableModule instantiableModule = (InstantiableModule)module;
        ModuleInstance moduleInstance = instantiableModule.getModuleInstance(instanceId);
        if (moduleInstance != null) {
            throw new ModuleInstanceExistsAlreadyException(moduleId, instanceId);
        }
        ModuleConfiguration moduleInstanceConfiguration = this.loadModuleInstanceConfiguration(instantiableModule, instanceId, instanceType);
        moduleInstance = instantiableModule.createModuleInstance(instanceId, instanceType, moduleInstanceConfiguration);
        instantiableModule.moduleInstanceCreated(moduleInstance);
        this.fireModuleUpdatedEventsForCreatedOrUpdatedSettings(null, moduleInstanceConfiguration);
    }

    private void onBroadcastMessageModuleUpdated(String moduleId) throws ModuleNotFoundException, SettingException, ServiceNotFoundException {
        LOG.info("onBroadcastMessageModuleUpdated moduleId=" + moduleId);
        Module module = this.getModuleById(moduleId);
        ModuleConfiguration moduleConfiguration = this.loadModuleConfiguration(module);
        ModuleConfiguration oldModuleConfiguration = module.getConfiguration();
        module.setConfiguration(moduleConfiguration);
        this.fireModuleUpdatedEventsForCreatedOrUpdatedSettings(oldModuleConfiguration, moduleConfiguration);
    }

    private class LicenseChangedEventHandler
    extends AbstractEventHandler {
        private LicenseChangedEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            License license = (License)event.getProperty("license");
            if (license instanceof NoLicense) {
                return;
            }
            ArrayList<Module> loadedModules = new ArrayList<Module>();
            Iterator iterator = ACCESS_MODULES_LOCK;
            synchronized (iterator) {
                for (Module m : ModuleManagerImpl.this.moduleLoadQueue) {
                    try {
                        Module loadedModule = ModuleManagerImpl.this.notSycnhronized_loadModule(m);
                        if (loadedModule == null) continue;
                        loadedModules.add(loadedModule);
                    }
                    catch (Exception ex) {
                        LOG.log(Level.SEVERE, "License changed ... failed to load queued module '" + m + "'.", ex);
                    }
                }
                ModuleManagerImpl.this.moduleLoadQueue.clear();
            }
            for (Module loadedModule : loadedModules) {
                ModuleManagerImpl.this.fireBackendModuleLoadedEvent(loadedModule);
            }
        }
    }

    private class LicenseExpiredEventHandler
    extends AbstractEventHandler {
        private LicenseExpiredEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processEvent(Event event) {
            LOG.info(this.getClass().getSimpleName() + ".processEvent event=...");
            try {
                ArrayList<Module> modulesToUnload = new ArrayList<Module>();
                Iterator iterator = ACCESS_MODULES_LOCK;
                synchronized (iterator) {
                    for (Module module : ModuleManagerImpl.this.modules.values()) {
                        if (ModuleManagerImpl.isCantLiveWithoutModule(module)) continue;
                        modulesToUnload.add(module);
                    }
                    for (Module moduleToUnload : modulesToUnload) {
                        LOG.info("License expired ... unloading module : " + moduleToUnload);
                        ModuleManagerImpl.this.modules.remove(moduleToUnload.getModuleId());
                        ModuleManagerImpl.this.moduleLoadQueue.add(moduleToUnload);
                    }
                }
                for (Module moduleToUnload : modulesToUnload) {
                    ModuleManagerImpl.this.fireBackendModuleUnloadedEvent(moduleToUnload);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "License expired ... failed to unload modules.", ex);
            }
        }
    }
}

