/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;

public class SettingValidators {
    private static final Logger LOG = Logger.getLogger(SettingValidators.class.getName());
    private final List<SettingValidator> settingValidators = new ArrayList<SettingValidator>();

    public void destroy() {
        LOG.info("destroy");
        for (SettingValidator settingValidator : this.settingValidators) {
            settingValidator.destroy();
        }
        this.settingValidators.clear();
    }

    public List<SettingValidator> getAll() {
        return new ArrayList<SettingValidator>(this.settingValidators);
    }

    public void set(SettingValidator settingValidator) {
        LOG.info("set settingValidator=" + settingValidator);
        if (settingValidator != null) {
            final String newSettingValidatorClassName = settingValidator.getClass().getName();
            this.settingValidators.removeIf(new Predicate<SettingValidator>(){

                @Override
                public boolean test(SettingValidator settingValidator) {
                    return newSettingValidatorClassName.equals(settingValidator.getClass().getName());
                }
            });
            this.settingValidators.add(settingValidator);
        }
    }

    public void remove(SettingValidator settingValidator) {
        LOG.info("remove settingValidator=" + settingValidator);
        if (settingValidator != null) {
            final String newSettingValidatorClassName = settingValidator.getClass().getName();
            this.settingValidators.removeIf(new Predicate<SettingValidator>(){

                @Override
                public boolean test(SettingValidator settingValidator) {
                    return newSettingValidatorClassName.equals(settingValidator.getClass().getName());
                }
            });
        }
    }

    public List<FrontendWarningException> validateModuleSettings(String moduleId, Collection<Setting> existingSettings, Collection<? extends Setting> settings) throws ValidationException {
        LOG.info("validateModuleSettings moduleId=" + moduleId + ", existingSettings=...., settings=...");
        return this.validateModuleInstanceSettings(moduleId, "noinstance", "none", existingSettings, settings);
    }

    public List<FrontendWarningException> validateModuleInstanceSettings(String moduleId, String moduleInstanceId, String instanceType, Collection<Setting> existingSettings, Collection<? extends Setting> settings) throws ValidationException {
        LOG.info("validateModuleInstanceSettings moduleId=" + moduleId + ", moduleInstanceId=" + moduleInstanceId + ", instanceType=" + instanceType + ", existingSettings=...., settings=...");
        ArrayList<FrontendWarningException> frontendWarnings = new ArrayList<FrontendWarningException>();
        for (SettingValidator validator : this.getAll()) {
            for (Setting setting : settings) {
                List<FrontendWarningException> few;
                if (setting == null || !validator.canValidate(moduleId, moduleInstanceId, instanceType) || !validator.canValidate(setting) || (few = validator.validate(setting)) == null) continue;
                frontendWarnings.addAll(few);
            }
        }
        HashMap<String, Setting> tmpSettings = new HashMap<String, Setting>();
        if (existingSettings != null) {
            for (Setting setting : existingSettings) {
                tmpSettings.put(setting.getName(), setting);
            }
        }
        for (Setting setting : settings) {
            tmpSettings.put(setting.getName(), setting);
        }
        for (SettingValidator settingValidator : this.getAll()) {
            List<FrontendWarningException> list;
            if (!settingValidator.canValidate(moduleId, moduleInstanceId, instanceType) || (list = settingValidator.validate(moduleId, moduleInstanceId, instanceType, tmpSettings)) == null) continue;
            frontendWarnings.addAll(list);
        }
        return frontendWarnings;
    }
}

